/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.streaming.KafkaConfigManager;
import org.apache.kylin.rec.SqlValidateContext;
import org.apache.kylin.rec.query.LocalQueryRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRunnerBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryRunnerBuilder.class);
    private final KylinConfig kylinConfig;
    private final String[] sqls;
    private final String project;
    private List<NDataModel> models = Lists.newArrayList();

    public QueryRunnerBuilder(String project, KylinConfig kylinConfig, String[] sqls) {
        this.kylinConfig = kylinConfig;
        this.sqls = sqls;
        this.project = project;
    }

    public QueryRunnerBuilder of(List<NDataModel> models) {
        this.models = models;
        return this;
    }

    public LocalQueryRunner build() {
        HashSet dumpResources = Sets.newHashSet();
        HashMap mockupResources = Maps.newHashMap();
        this.prepareResources(dumpResources, mockupResources, this.models);
        return new LocalQueryRunner(this.kylinConfig, this.project, this.sqls, dumpResources, mockupResources);
    }

    private void prepareResources(Set<String> dumpResources, Map<String, RootPersistentEntity> mockupResources, List<NDataModel> dataModels) {
        ProjectInstance dumpProj = new ProjectInstance();
        dumpProj.setName(this.project);
        dumpProj.setDefaultDatabase(NProjectManager.getInstance((KylinConfig)this.kylinConfig).getDefaultDatabase(this.project));
        dumpProj.init(this.kylinConfig, true);
        mockupResources.put(dumpProj.getResourcePath(), (RootPersistentEntity)dumpProj);
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)this.kylinConfig, (String)this.project);
        SqlValidateContext context = new SqlValidateContext(this.kylinConfig, this.project, this.sqls);
        Set<String> relatedTables = context.getRelatedTables();
        relatedTables.stream().map(arg_0 -> ((NTableMetadataManager)tableManager).getTableDesc(arg_0)).forEach(tableDesc -> {
            dumpResources.add(tableDesc.getResourcePath());
            TableExtDesc tableExt = tableManager.getTableExtIfExists(tableDesc);
            if (tableExt != null) {
                dumpResources.add(tableExt.getResourcePath());
            }
        });
        KafkaConfigManager kafkaConfigManager = KafkaConfigManager.getInstance((KylinConfig)this.kylinConfig, (String)this.project);
        kafkaConfigManager.listAllKafkaConfigs().forEach(kafkaConfig -> dumpResources.add(kafkaConfig.getResourcePath()));
        dataModels.forEach(dataModel -> {
            mockupResources.put(dataModel.getResourcePath(), (RootPersistentEntity)dataModel);
            dataModel.setComputedColumnUuids(dataModel.getComputedColumnDescs().stream().map(RootPersistentEntity::getUuid).collect(Collectors.toList()));
            dataModel.getComputedColumnDescs().forEach(computedColumn -> {
                RootPersistentEntity cfr_ignored_0 = (RootPersistentEntity)mockupResources.put(computedColumn.getResourcePath(), (RootPersistentEntity)computedColumn);
            });
            this.mockupDataflowAndIndexPlan((NDataModel)dataModel, mockupResources);
        });
    }

    private void mockupDataflowAndIndexPlan(NDataModel dataModel, Map<String, RootPersistentEntity> mockupResources) {
        IndexPlan indexPlan = new IndexPlan();
        indexPlan.setUuid(dataModel.getUuid());
        indexPlan.setProject(this.project);
        indexPlan.setDescription("");
        NDataflow dataflow = NDataflow.create((IndexPlan)indexPlan, (RealizationStatusEnum)RealizationStatusEnum.ONLINE);
        dataflow.setProject(this.project);
        mockupResources.put(indexPlan.getResourcePath(), (RootPersistentEntity)indexPlan);
        mockupResources.put(dataflow.getResourcePath(), (RootPersistentEntity)dataflow);
    }
}

