/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.util;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractSemiContext;
import org.apache.kylin.rec.ModelCreateContext;
import org.apache.kylin.rec.ModelReuseContext;
import org.apache.kylin.rec.ProposerJob;
import org.apache.kylin.rec.SmartContext;
import org.apache.kylin.rec.SmartMaster;

public class AccelerationUtil {
    public static Consumer<AbstractContext> onlineHook = AccelerationUtil::onlineModel;

    private AccelerationUtil() {
    }

    public static AbstractContext runWithSmartContext(KylinConfig kylinConfig, String project, String[] sqlArray) {
        return AccelerationUtil.runWithSmartContext(kylinConfig, project, sqlArray, false);
    }

    public static AbstractContext runWithSmartContext(KylinConfig kylinConfig, String project, String[] sqlArray, boolean online) {
        KylinConfigExt config = NProjectManager.getInstance((KylinConfig)kylinConfig).getProject(project).getConfig();
        SmartContext context = new SmartContext((KylinConfig)config, project, sqlArray);
        SmartMaster smartMaster = new SmartMaster(context);
        Consumer<AbstractContext> hook = online ? onlineHook : null;
        smartMaster.runUtWithContext(hook);
        return smartMaster.getContext();
    }

    public static AbstractSemiContext runModelReuseContext(KylinConfig kylinConfig, String project, String[] sqlArray, boolean canCreateNewModel) {
        KylinConfigExt config = NProjectManager.getInstance((KylinConfig)kylinConfig).getProject(project).getConfig();
        ModelReuseContext context = new ModelReuseContext((KylinConfig)config, project, sqlArray, canCreateNewModel);
        context.getExtraMeta().setOnlineModelIds(AccelerationUtil.getOnlineModelIds(project));
        SmartMaster smartMaster = new SmartMaster(context);
        smartMaster.executePropose();
        return context;
    }

    public static AbstractSemiContext runModelReuseContext(KylinConfig kylinConfig, String project, String[] sqlArray) {
        KylinConfigExt config = NProjectManager.getInstance((KylinConfig)kylinConfig).getProject(project).getConfig();
        ModelReuseContext context = new ModelReuseContext((KylinConfig)config, project, sqlArray);
        context.getExtraMeta().setOnlineModelIds(AccelerationUtil.getOnlineModelIds(project));
        SmartMaster smartMaster = new SmartMaster(context);
        smartMaster.runUtWithContext(null);
        AccelerationUtil.onlineModel(context);
        return context;
    }

    private static Set<String> getOnlineModelIds(String project) {
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)project);
        return NDataflowManager.getInstance((KylinConfig)projectConfig, (String)project).listOnlineDataModels().stream().map(RootPersistentEntity::getUuid).collect(Collectors.toSet());
    }

    public static AbstractSemiContext runModelCreateContext(KylinConfig kylinConfig, String project, String[] sqlArray) {
        KylinConfigExt projectConfig = NProjectManager.getInstance((KylinConfig)kylinConfig).getProject(project).getConfig();
        ModelCreateContext context = new ModelCreateContext((KylinConfig)projectConfig, project, sqlArray){

            @Override
            public void saveMetadata() {
                UnitOfWork.doInTransactionWithRetry(() -> {
                    KylinConfig config = KylinConfig.getInstanceFromEnv();
                    NIndexPlanManager indexPlanMgr = NIndexPlanManager.getInstance((KylinConfig)config, (String)this.getProject());
                    NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject());
                    NDataModelManager modelMgr = NDataModelManager.getInstance((KylinConfig)config, (String)this.getProject());
                    for (AbstractContext.ModelContext modelCtx : this.getModelContexts()) {
                        if (modelCtx.skipSavingMetadata()) continue;
                        NDataModel model = modelCtx.getTargetModel();
                        if (modelMgr.getDataModelDesc(model.getUuid()) != null) {
                            modelMgr.updateDataModelDesc(model);
                        } else {
                            modelMgr.createDataModelDesc(model, model.getOwner());
                        }
                        IndexPlan indexPlan = modelCtx.getTargetIndexPlan();
                        if (indexPlanMgr.getIndexPlan(indexPlan.getUuid()) == null) {
                            indexPlanMgr.createIndexPlan(indexPlan);
                            dfMgr.createDataflow(indexPlan, indexPlan.getModel().getOwner());
                            continue;
                        }
                        indexPlanMgr.updateIndexPlan(indexPlan);
                    }
                    return true;
                }, (String)this.getProject());
            }
        };
        context.getProposers().execute();
        context.saveMetadata();
        AccelerationUtil.onlineModel(context);
        return context;
    }

    public static void onlineModel(AbstractContext context) {
        if (context == null || context.getModelContexts() == null) {
            return;
        }
        UnitOfWork.doInTransactionWithRetry(() -> {
            KylinConfig kylinConfig = context.getKapConfig().getKylinConfig();
            context.getModelContexts().forEach(ctx -> {
                NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)context.getProject());
                NDataModel model = ctx.getTargetModel();
                if (model == null || dfManager.getDataflow(model.getId()) == null) {
                    return;
                }
                dfManager.updateDataflowStatus(model.getId(), RealizationStatusEnum.ONLINE);
            });
            return true;
        }, (String)context.getProject());
    }

    public static AbstractContext genOptRec(KylinConfig config, String project, String[] sqls) {
        ModelReuseContext context = new ModelReuseContext(config, project, sqls);
        return ProposerJob.propose(context);
    }
}

