/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableAliasGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableAliasGenerator.class);
    private static final String UNKNOWN_SCHEMA = "N/A";
    private static final String KEY = "_KEY_";
    private static final String TO = "__TO__";

    private TableAliasGenerator() {
    }

    public static TableAliasDict generateNewDict(String[] tableNames) {
        LinkedHashMap schemaMap = Maps.newLinkedHashMap();
        HashSet unsortedNameSet = Sets.newHashSet((Object[])tableNames);
        unsortedNameSet.stream().sorted().filter(StringUtils::isNotEmpty).forEach(tableIdentity -> {
            String[] splits = tableIdentity.split("\\.");
            int lastIndex = splits.length - 1;
            String table = splits[lastIndex];
            String schema = lastIndex == 0 ? UNKNOWN_SCHEMA : splits[lastIndex - 1];
            schemaMap.putIfAbsent(schema, Lists.newArrayList());
            ((List)schemaMap.get(schema)).add(table);
        });
        Map<String, String> schemaDict = schemaMap.size() > 1 ? TableAliasGenerator.quickDict(schemaMap.keySet().toArray(new String[0]), true) : null;
        LinkedHashMap dict = Maps.newLinkedHashMap();
        schemaMap.forEach((schema, tableList) -> {
            Map<String, String> tableDict = TableAliasGenerator.quickDict(tableList.toArray(new String[0]), false);
            tableDict.forEach((table, alias) -> {
                alias = schemaDict == null ? alias : (String)schemaDict.get(schema) + "_" + alias;
                table = schema.equals(UNKNOWN_SCHEMA) ? table : schema + "." + table;
                dict.put(table, alias);
            });
        });
        return new TableAliasDict(dict);
    }

    public static TableAliasDict generateCommonDictForSpecificModel(String project) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        Map allTablesMap = NTableMetadataManager.getInstance((KylinConfig)config, (String)project).getAllTablesMap();
        return TableAliasGenerator.generateNewDict(allTablesMap.keySet().toArray(new String[0]));
    }

    private static Map<String, String> quickDict(String[] sourceNames, boolean isSchema) {
        String prefix = isSchema ? "D" : "T";
        HashMap dict = Maps.newHashMap();
        for (int i = 0; i < sourceNames.length; ++i) {
            dict.put(sourceNames[i], prefix + i);
        }
        return dict;
    }

    public static class TableAliasDict {
        private final Map<String, String> alias2TblName = Maps.newHashMap();
        private final Map<String, String> tblName2Alias = Maps.newHashMap();

        public TableAliasDict(Map<String, String> dict) {
            dict.forEach((tableName, alias) -> {
                this.alias2TblName.putIfAbsent((String)alias, (String)tableName);
                this.tblName2Alias.put((String)tableName, (String)alias);
            });
        }

        public String getAlias(String tableName) {
            return this.tblName2Alias.get(tableName);
        }

        public String getTableName(String alias) {
            return this.alias2TblName.get(alias);
        }

        public String getHierarchyAliasFromJoins(JoinDesc[] joins) {
            if (ArrayUtils.isEmpty((Object[])joins)) {
                return "";
            }
            StringBuilder alias = new StringBuilder(this.getAlias(joins[0].getFKSide().getTableIdentity()));
            for (JoinDesc join : joins) {
                if (join.getPrimaryKeyColumns() == null || join.getPrimaryKeyColumns().length == 0 && join.getNonEquiJoinCondition() == null) break;
                if (join.getNonEquiJoinCondition() != null) {
                    alias.append(TableAliasGenerator.KEY).append(join.getNonEquiJoinCondition().toString());
                    alias.append(TableAliasGenerator.TO).append(this.getAlias(join.getPKSide().getTableIdentity()));
                    continue;
                }
                alias.append(TableAliasGenerator.KEY).append(Arrays.toString(Arrays.stream(join.getForeignKeyColumns()).map(TblColRef::getName).toArray()));
                alias.append(TableAliasGenerator.TO).append(this.getAlias(join.getPrimaryKeyColumns()[0].getTableRef().getTableIdentity()));
                alias.append(TableAliasGenerator.KEY).append(Arrays.toString(Arrays.stream(join.getPrimaryKeyColumns()).map(TblColRef::getName).toArray()));
            }
            return alias.toString();
        }
    }
}

