/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.favorite.AccelerateRuleUtil;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffset;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.QuerySmartSupporter;
import org.apache.kylin.rest.util.SpringContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class QueryHistoryAccelerateScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryHistoryAccelerateScheduler.class);
    private ScheduledExecutorService taskScheduler;
    @VisibleForTesting
    RDBMSQueryHistoryDAO queryHistoryDAO = RDBMSQueryHistoryDAO.getInstance();
    AccelerateRuleUtil accelerateRuleUtil = new AccelerateRuleUtil();
    private QuerySmartSupporter querySmartSupporter;
    private IUserGroupService userGroupService;
    private final QueryHistoryAccelerateRunner queryHistoryAccelerateRunner;
    private static volatile QueryHistoryAccelerateScheduler INSTANCE = null;

    public QueryHistoryAccelerateScheduler() {
        if (this.userGroupService == null && SpringContext.getApplicationContext() != null) {
            this.userGroupService = (IUserGroupService)SpringContext.getApplicationContext().getBean("userGroupService");
        }
        this.queryHistoryAccelerateRunner = new QueryHistoryAccelerateRunner(false);
        if (this.querySmartSupporter == null && SpringContext.getApplicationContext() != null) {
            this.querySmartSupporter = (QuerySmartSupporter)SpringContext.getBean(QuerySmartSupporter.class);
        }
        log.debug("New QueryHistoryAccelerateScheduler created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryHistoryAccelerateScheduler getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<QueryHistoryAccelerateScheduler> clazz = QueryHistoryAccelerateScheduler.class;
        synchronized (QueryHistoryAccelerateScheduler.class) {
            if (INSTANCE == null) {
                INSTANCE = new QueryHistoryAccelerateScheduler();
                INSTANCE.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void init() {
        this.taskScheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("QueryHistoryWorker"));
        this.taskScheduler.scheduleWithFixedDelay(this.queryHistoryAccelerateRunner, 0L, KylinConfig.getInstanceFromEnv().getQueryHistoryAccelerateInterval(), TimeUnit.MINUTES);
        log.info("Query history task scheduler is started.");
    }

    public void scheduleImmediately(QueryHistoryTask runner) {
        runner.run();
    }

    public static void shutdown() {
        log.info("Shutting down QueryHistoryAccelerateScheduler ....");
        if (INSTANCE != null) {
            ExecutorServiceUtil.forceShutdown((ExecutorService)QueryHistoryAccelerateScheduler.INSTANCE.taskScheduler);
            INSTANCE = null;
        }
    }

    public static abstract class QueryHistoryTask
    implements Runnable {
        protected String project;

        protected abstract String name();

        public void batchHandle(int batchSize, int maxSize, String project, Consumer<Pair<List<QueryHistory>, String>> consumer) {
            List<QueryHistory> queryHistories;
            if (batchSize <= 0 || maxSize < batchSize) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s task, batch size: %d , maxsize: %d is illegal", this.name(), batchSize, maxSize));
            }
            int finishNum = 0;
            do {
                queryHistories = this.getQueryHistories(batchSize, project);
                finishNum += queryHistories.size();
                if (this.isInterrupted()) break;
                if (!queryHistories.isEmpty()) {
                    consumer.accept((Pair<List<QueryHistory>, String>)new Pair(queryHistories, (Object)project));
                }
                log.debug("{} handled {} query history", (Object)this.name(), (Object)queryHistories.size());
            } while (queryHistories.size() >= batchSize && finishNum < maxSize);
        }

        protected boolean isInterrupted() {
            return false;
        }

        protected abstract List<QueryHistory> getQueryHistories(int var1, String var2);

        @Override
        public void run() {
            List<String> projects = null;
            if (this.project != null) {
                projects = Collections.singletonList(this.project);
            } else {
                KylinConfig config = KylinConfig.getInstanceFromEnv();
                projects = NProjectManager.getInstance((KylinConfig)config).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
            }
            projects.forEach(projectName -> {
                try {
                    this.work((String)projectName);
                }
                catch (Exception e) {
                    log.warn("QueryHistory {}  process failed of project({})", new Object[]{this.name(), projectName, e});
                }
            });
        }

        protected abstract void work(String var1);
    }

    public class QueryHistoryAccelerateRunner
    extends QueryHistoryTask {
        private final boolean isManual;

        public QueryHistoryAccelerateRunner(boolean isManual, String project) {
            this.isManual = isManual;
            this.project = project;
        }

        public QueryHistoryAccelerateRunner(boolean isManual) {
            this(isManual, null);
        }

        @Override
        protected String name() {
            return "queryAcc";
        }

        @Override
        protected List<QueryHistory> getQueryHistories(int batchSize, String project) {
            QueryHistoryIdOffsetManager qhIdOffsetManager = QueryHistoryIdOffsetManager.getInstance((String)project);
            return (List)JdbcUtil.withTxAndRetry((DataSourceTransactionManager)qhIdOffsetManager.getTransactionManager(), () -> {
                QueryHistoryIdOffset qhIdOffset = qhIdOffsetManager.get(QueryHistoryIdOffset.OffsetType.ACCELERATE);
                List queryHistoryList = QueryHistoryAccelerateScheduler.this.queryHistoryDAO.queryQueryHistoriesByIdOffset(qhIdOffset.getOffset(), batchSize, project);
                if (!queryHistoryList.isEmpty()) {
                    long maxId = 0L;
                    for (QueryHistory queryHistory : queryHistoryList) {
                        if (queryHistory.getId() <= maxId) continue;
                        maxId = queryHistory.getId();
                    }
                    this.updateIdOffset(maxId, project);
                }
                return queryHistoryList;
            });
        }

        @Override
        public void work(String project) {
            if (NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).isExpertMode()) {
                log.info("Skip QueryHistoryAccelerateRunner job, project [{}].", (Object)project);
                return;
            }
            log.info("Start QueryHistoryAccelerateRunner job, project [{}].", (Object)project);
            int batchSize = KylinConfig.getInstanceFromEnv().getQueryHistoryAccelerateBatchSize();
            int maxSize = this.isManual() ? KylinConfig.getInstanceFromEnv().getQueryHistoryAccelerateBatchSize() : KylinConfig.getInstanceFromEnv().getQueryHistoryAccelerateMaxSize();
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            QueryHistoryIdOffsetManager qhIdOffsetManager = QueryHistoryIdOffsetManager.getInstance((String)project);
            if (System.currentTimeMillis() - qhIdOffsetManager.get(QueryHistoryIdOffset.OffsetType.ACCELERATE).getUpdateTime() >= TimeUnit.MINUTES.toMillis(kylinConfig.getQueryHistoryAccelerateInterval()) || this.isManual) {
                this.batchHandle(batchSize, maxSize, project, this::accelerateAndUpdateMetadata);
                log.info("End QueryHistoryAccelerateRunner job, project [{}].", (Object)project);
            } else {
                log.info("Skip QueryHistoryAccelerateRunner job, project [{}].", (Object)project);
            }
        }

        public void accelerateAndUpdateMetadata(Pair<List<QueryHistory>, String> pair) {
            List queryHistories = (List)pair.getFirst();
            String project = (String)pair.getSecond();
            if (CollectionUtils.isEmpty((Collection)queryHistories)) {
                return;
            }
            ArrayList idToQHInfoList = Lists.newArrayList();
            Map<String, Set<String>> submitterToGroups = this.getUserToGroups(queryHistories);
            List matchedCandidate = QueryHistoryAccelerateScheduler.this.accelerateRuleUtil.findMatchedCandidate(project, queryHistories, submitterToGroups, (List)idToQHInfoList);
            QueryHistoryAccelerateScheduler.this.queryHistoryDAO.batchUpdateQueryHistoriesInfo((List)idToQHInfoList);
            if (QueryHistoryAccelerateScheduler.this.querySmartSupporter != null) {
                QueryHistoryAccelerateScheduler.this.querySmartSupporter.onMatchQueryHistory(project, matchedCandidate);
            }
        }

        protected Map<String, Set<String>> getUserToGroups(List<QueryHistory> queryHistories) {
            HashMap<String, Set<String>> submitterToGroups = new HashMap<String, Set<String>>();
            for (QueryHistory qh : queryHistories) {
                QueryHistoryInfo queryHistoryInfo = qh.getQueryHistoryInfo();
                if (queryHistoryInfo == null) continue;
                String querySubmitter = qh.getQuerySubmitter();
                submitterToGroups.putIfAbsent(querySubmitter, QueryHistoryAccelerateScheduler.this.userGroupService.listUserGroups(querySubmitter));
            }
            return submitterToGroups;
        }

        private void updateIdOffset(long maxId, String project) {
            QueryHistoryIdOffsetManager offsetManager = QueryHistoryIdOffsetManager.getInstance((String)project);
            JdbcUtil.withTxAndRetry((DataSourceTransactionManager)offsetManager.getTransactionManager(), () -> {
                offsetManager.updateOffset(QueryHistoryIdOffset.OffsetType.ACCELERATE, copyForWrite -> copyForWrite.setOffset(maxId));
                return null;
            });
        }

        @Generated
        public boolean isManual() {
            return this.isManual;
        }
    }
}

