/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.condition;

import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;

public class JobModeCondition
implements Condition {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobModeCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String beanName = "N/A";
        if (metadata instanceof AnnotationMetadata) {
            beanName = ((AnnotationMetadata)metadata).getClassName();
        } else if (metadata instanceof MethodMetadata) {
            beanName = ((MethodMetadata)metadata).getMethodName();
        }
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (kylinConfig.isUTEnv()) {
            log.info("skip load bean = {} on UT env", (Object)beanName);
            return false;
        }
        if (kylinConfig.isDataLoadingNode() || kylinConfig.isMetadataNode() || kylinConfig.isOpsNode()) {
            log.info("load bean = {} on common/data-loading/ops", (Object)beanName);
            return true;
        }
        if (null == kylinConfig.getMicroServiceMode()) {
            log.info("load bean = {} on all/job mode", (Object)beanName);
            return true;
        }
        log.info("skip load bean = {} on query mode or not data-loading mirco-service", (Object)beanName);
        return false;
    }
}

