/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.mail.MailNotificationType;
import org.apache.kylin.common.mail.MailNotifier;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.common.util.ThrowableUtils;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.MoreObjects;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.core.AbstractJobExecutable;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.exception.JobStoppedException;
import org.apache.kylin.job.exception.JobStoppedNonVoluntarilyException;
import org.apache.kylin.job.execution.ChainedExecutable;
import org.apache.kylin.job.execution.ChainedStageExecutable;
import org.apache.kylin.job.execution.DagExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableParams;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.JobSchedulerModeEnum;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.execution.StageExecutable;
import org.apache.kylin.job.mail.JobMailUtil;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutable
extends AbstractJobExecutable
implements Executable {
    protected static final String SUBMITTER = "submitter";
    protected static final String PARENT_ID = "parentId";
    private static final Integer DEFAULT_DRIVER_MEMORY = 512;
    public static final String RUNTIME_INFO = "runtimeInfo";
    public static final String DEPENDENT_FILES = "dependentFiles";
    protected static final Logger logger = LoggerFactory.getLogger(AbstractExecutable.class);
    protected int retry = 0;
    private String name;
    private JobTypeEnum jobType;
    private String logPath;
    private String targetSubject;
    private List<String> targetSegments = Lists.newArrayList();
    private String id;
    private boolean resumable = false;
    private ExecutableParams executableParams = new ExecutableParams();
    protected String project;
    protected JobContext context;
    private Map<String, Object> runTimeInfo = Maps.newHashMap();
    private Set<Long> targetPartitions = Sets.newHashSet();
    private int priority = 3;
    private Object tag;
    private int stepId = -1;
    private ExecutablePO po;
    private JobSchedulerModeEnum jobSchedulerMode = JobSchedulerModeEnum.CHAIN;
    private String previousStep;
    private Set<String> nextSteps = Sets.newHashSet();

    public boolean isBucketJob() {
        return CollectionUtils.isNotEmpty(this.targetPartitions);
    }

    public String getTargetModelAlias() {
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataModel dataModelDesc = NDataModelManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject()).getDataModelDesc(this.targetSubject);
        if (dataModelDesc != null) {
            if (modelManager.isModelBroken(this.targetSubject)) {
                return modelManager.getDataModelDescWithoutInit(this.targetSubject).getAlias();
            }
            return dataModelDesc.getFusionModelAlias();
        }
        return null;
    }

    public String getTargetModelId() {
        return AbstractExecutable.getTargetModelId(this.getProject(), this.targetSubject);
    }

    public static String getTargetModelId(String project, String targetSubject) {
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NDataModel dataModelDesc = modelManager.getDataModelDesc(targetSubject);
        if (dataModelDesc == null) {
            return null;
        }
        return modelManager.isModelBroken(targetSubject) ? modelManager.getDataModelDescWithoutInit(targetSubject).getId() : dataModelDesc.getId();
    }

    public String getTargetSubjectAlias() {
        return this.getTargetModelAlias();
    }

    public AbstractExecutable() {
        this.setId(RandomUtil.randomUUIDStr());
    }

    public AbstractExecutable(Object notSetId) {
    }

    @Override
    public void cancelJob() {
    }

    public boolean safetyIfDiscard() {
        return true;
    }

    protected KylinConfig getConfig() {
        return KylinConfig.getInstanceFromEnv();
    }

    protected ExecutableManager getManager() {
        return AbstractExecutable.getExecutableManager(this.project);
    }

    protected void wrapWithCheckQuit(Callback f) throws JobStoppedException {
        boolean tryAgain = true;
        while (tryAgain) {
            this.checkNeedQuit(true);
            tryAgain = false;
            try {
                JobContextUtil.withTxAndRetry(() -> {
                    this.checkNeedQuit(false);
                    f.process();
                    return true;
                });
            }
            catch (Exception e) {
                if (Throwables.getCausalChain((Throwable)e).stream().anyMatch(x -> x instanceof JobStoppedException)) {
                    logger.info("[LESS_LIKELY_THINGS_HAPPENED] JobStoppedException thrown from in a UnitOfWork", (Throwable)e);
                    tryAgain = true;
                    continue;
                }
                throw new JobStoppedException(e);
            }
        }
    }

    protected void onExecuteStart() throws JobStoppedException {
        this.wrapWithCheckQuit(() -> this.updateJobOutput(this.project, this.getId(), ExecutableState.RUNNING, null, null, null));
    }

    protected void onExecuteFinished(ExecuteResult result) throws ExecuteException {
        logger.info("Execute finished {}, state:{}", (Object)this.getDisplayName(), (Object)result.state());
        MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.JOB_STEP_ATTEMPTED, (MetricsCategory)MetricsCategory.PROJECT, (String)this.project, (long)this.retry);
        if (result.succeed()) {
            this.wrapWithCheckQuit(() -> {
                ExecutableState state = this.adjustState(ExecutableState.SUCCEED);
                logger.info("Job {} adjust future state from {} to {}", new Object[]{this.getId(), ExecutableState.SUCCEED.name(), state.name()});
                this.updateJobOutput(this.project, this.getId(), state, result.getExtraInfo(), result.output(), null);
            });
        } else if (result.skip()) {
            this.wrapWithCheckQuit(() -> this.updateJobOutput(this.project, this.getId(), ExecutableState.SKIP, result.getExtraInfo(), result.output(), null));
        } else {
            MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.JOB_FAILED_STEP_ATTEMPTED, (MetricsCategory)MetricsCategory.PROJECT, (String)this.project, (long)this.retry);
            this.wrapWithCheckQuit(() -> {
                this.updateJobOutput(this.project, this.getId(), ExecutableState.ERROR, result.getExtraInfo(), result.getErrorMsg(), result.getShortErrMsg(), this::onExecuteErrorHook);
                this.killOtherPipelineApplicationOrUpdateOtherPipelineStepStatus();
            });
            throw new ExecuteException(result.getThrowable());
        }
    }

    public void onExecuteStopHook() {
        this.onExecuteErrorHook(this.getId());
    }

    protected ExecutableState adjustState(ExecutableState originalState) {
        return originalState;
    }

    protected void onExecuteErrorHook(String jobId) {
    }

    public void updateJobOutput(String project, String jobId, ExecutableState newStatus, Map<String, String> info, String output, Consumer<String> hook) {
        this.updateJobOutput(project, jobId, newStatus, info, output, null, hook);
    }

    public void updateJobOutput(String project, String jobId, ExecutableState newStatus, Map<String, String> info, String output, String failedMsg, Consumer<String> hook) {
        this.updateJobOutput(project, jobId, newStatus, info, output, this.getLogPath(), failedMsg, hook);
    }

    public void updateJobOutput(String project, String jobId, ExecutableState newStatus, Map<String, String> info, String output, String logPath, String failedMsg, Consumer<String> hook) {
        JobContextUtil.withTxAndRetry(() -> {
            ExecutableManager executableManager = AbstractExecutable.getExecutableManager(project);
            Map<String, String> existedInfo = executableManager.getOutput(jobId).getExtra();
            if (info != null) {
                existedInfo.putAll(info);
            }
            if (this instanceof ChainedStageExecutable) {
                if (newStatus.isNotBad()) {
                    executableManager.makeStageSuccess(jobId);
                } else if (newStatus == ExecutableState.ERROR) {
                    executableManager.makeStageError(jobId);
                }
            }
            executableManager.updateJobOutput(jobId, newStatus, existedInfo, null, null, 0L, failedMsg);
            return true;
        });
        if (hook != null) {
            hook.accept(jobId);
        }
        AbstractExecutable.updateJobOutputToHDFS(project, jobId, output, logPath);
    }

    private static void updateJobOutputToHDFS(String project, String jobId, String output, String logPath) {
        ExecutableManager executableManager = AbstractExecutable.getExecutableManager(project);
        ExecutableOutputPO jobOutput = executableManager.getJobOutput(jobId);
        if (null != output) {
            jobOutput.setContent(output);
        }
        if (null != logPath) {
            jobOutput.setLogPath(logPath);
        }
        String outputHDFSPath = KylinConfig.getInstanceFromEnv().getJobTmpOutputStorePath(project, jobId);
        executableManager.updateJobOutputToHDFS(outputHDFSPath, jobOutput);
    }

    protected static ExecutableManager getExecutableManager(String project) {
        return ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
    }

    @Override
    public final ExecuteResult execute(JobContext jobContext) throws ExecuteException {
        ExecuteResult result;
        logger.info("Executing AbstractExecutable {}", (Object)this.getDisplayName());
        this.context = jobContext;
        this.onExecuteStart();
        do {
            if (this.retry > 0) {
                this.pauseOnRetry();
                logger.info("Retrying for the {}th time ", (Object)this.retry);
            }
            try {
                result = this.wrapWithExecuteException(() -> this.doWork(jobContext));
            }
            catch (JobStoppedException jse) {
                result = ExecuteResult.createSucceed();
            }
            catch (Exception e) {
                result = ExecuteResult.createError(e);
            }
            ++this.retry;
        } while (this.needRetry(this.retry, result.getThrowable()));
        this.onExecuteFinished(result);
        if (result.getThrowable() != null) {
            result.getThrowable().printStackTrace();
        }
        return result;
    }

    protected void killOtherPipelineApplicationOrUpdateOtherPipelineStepStatus() {
        logger.error("{} kill other piper line application or update other piper line step status", (Object)this.getDisplayName());
        List<AbstractExecutable> otherPipelineRunningStep = this.getOtherPipelineRunningStep();
        otherPipelineRunningStep.forEach(AbstractExecutable::killApplicationIfExistsOrUpdateStepStatus);
    }

    protected List<AbstractExecutable> getOtherPipelineRunningStep() {
        AbstractExecutable parent = this.getParent();
        String previousStepId = this.getPreviousStep();
        if (parent instanceof DefaultExecutable && parent.getJobSchedulerMode() == JobSchedulerModeEnum.DAG) {
            List<AbstractExecutable> otherPipelineTasks = this.getOtherPipelineTasks((DefaultExecutable)parent, previousStepId);
            Map<String, AbstractExecutable> dagExecutablesMap = ((DefaultExecutable)parent).getTasks().stream().collect(Collectors.toMap(AbstractExecutable::getId, task -> task));
            return otherPipelineTasks.stream().map(task -> this.getStepOrNextStepsWithStatus((AbstractExecutable)task, dagExecutablesMap, ExecutableState.RUNNING)).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
        }
        return Lists.newArrayList();
    }

    private List<AbstractExecutable> getOtherPipelineTasks(DefaultExecutable parent, String previousStepId) {
        return parent.getTasks().stream().filter(task -> StringUtils.equals((CharSequence)task.getPreviousStep(), (CharSequence)previousStepId)).filter(task -> !task.getId().equals(this.getId())).collect(Collectors.toList());
    }

    protected List<AbstractExecutable> getStepOrNextStepsWithStatus(AbstractExecutable executable, Map<String, AbstractExecutable> dagExecutablesMap, ExecutableState state) {
        if (executable.getStatus() == state) {
            return Lists.newArrayList((Object[])new AbstractExecutable[]{executable});
        }
        return executable.getNextSteps().stream().map(dagExecutablesMap::get).map(step -> this.getStepOrNextStepsWithStatus((AbstractExecutable)step, dagExecutablesMap, state)).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
    }

    public void killApplicationIfExistsOrUpdateStepStatus() {
        ExecutableManager executableManager = AbstractExecutable.getExecutableManager(this.project);
        executableManager.updateJobOutput(this.getId(), ExecutableState.PAUSED, null, null, null, 0L, null);
    }

    protected void checkNeedQuit(boolean applyChange) throws JobStoppedException {
        this.abortIfJobStopped(applyChange);
    }

    public boolean checkSuicide() {
        AbstractExecutable parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.checkSuicide();
    }

    protected boolean needCheckState() {
        return true;
    }

    public void abortIfJobStopped(boolean applyChange) throws JobStoppedException {
        if (!this.needCheckState()) {
            return;
        }
        Boolean aborted = (Boolean)JobContextUtil.withTxAndRetry(() -> {
            boolean abort = false;
            AbstractExecutable parent = this.getParent();
            ExecutableState state = parent.getStatus();
            switch (state) {
                case READY: 
                case PENDING: 
                case PAUSED: 
                case DISCARDED: {
                    if (applyChange) {
                        logger.debug("abort {} because parent job is {}", (Object)this.getId(), (Object)state);
                        this.updateJobOutput(this.project, this.getId(), state, null, null, null);
                    }
                    abort = true;
                    break;
                }
            }
            return abort;
        });
        if (aborted.booleanValue()) {
            throw new JobStoppedNonVoluntarilyException();
        }
    }

    public boolean needRetry(int retry, Throwable t) {
        if (t == null || this instanceof DefaultExecutable) {
            return false;
        }
        if (retry > KylinConfig.getInstanceFromEnv().getJobRetry()) {
            return false;
        }
        if (ThrowableUtils.isInterruptedException((Throwable)t)) {
            return false;
        }
        return AbstractExecutable.isRetryableException(t.getClass().getName());
    }

    private void pauseOnRetry() {
        int interval = KylinConfig.getInstanceFromEnv().getJobRetryInterval();
        logger.info("Pause {} milliseconds before retry", (Object)interval);
        try {
            TimeUnit.MILLISECONDS.sleep(interval);
        }
        catch (InterruptedException e) {
            logger.error("Job retry was interrupted, details: {}", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static boolean isRetryableException(String exceptionName) {
        Object[] jobRetryExceptions = KylinConfig.getInstanceFromEnv().getJobRetryExceptions();
        return ArrayUtils.isEmpty((Object[])jobRetryExceptions) || ArrayUtils.contains((Object[])jobRetryExceptions, (Object)exceptionName);
    }

    protected abstract ExecuteResult doWork(JobContext var1) throws ExecuteException;

    @Override
    public boolean isRunnable() {
        return this.getStatus() == ExecutableState.PENDING;
    }

    @Override
    public String getDisplayName() {
        return this.name + " (" + this.id + ")";
    }

    @Override
    public final ExecutableState getStatus() {
        ExecutableManager manager = this.getManager();
        return manager.getOutput(this.getId()).getState();
    }

    public final ExecutableState getStatusInMem() {
        return this.getStatus(this.getPo());
    }

    public final ExecutableState getStatus(ExecutablePO po) {
        ExecutableManager manager = this.getManager();
        return manager.getOutput(this.getId(), po).getState();
    }

    public final long getLastModified() {
        return AbstractExecutable.getLastModified(this.getOutput());
    }

    public static long getLastModified(Output output) {
        return output.getLastModified();
    }

    public final long getByteSize() {
        return AbstractExecutable.getByteSize(this.getOutput());
    }

    public static long getByteSize(Output output) {
        return output.getByteSize();
    }

    public boolean notifyUserIfNecessary(NDataLayout[] addOrUpdateCuboids) {
        boolean hasEmptyLayout = false;
        for (NDataLayout dataCuboid : addOrUpdateCuboids) {
            if (dataCuboid.getRows() != 0L) continue;
            hasEmptyLayout = true;
            break;
        }
        if (hasEmptyLayout && this.getConfig().isMailEnabled()) {
            logger.info("Layout rows is 0, notify user");
            return this.notifyUser(MailNotificationType.JOB_LOAD_EMPTY_DATA);
        }
        return false;
    }

    public boolean notifyUser(MailNotificationType notificationType) {
        Preconditions.checkState((this instanceof DefaultExecutable || this.getParent() instanceof DefaultExecutable ? 1 : 0) != 0);
        KylinConfigExt projectConfig = NProjectManager.getInstance((KylinConfig)this.getConfig()).getProject(this.project).getConfig();
        boolean needNotification = notificationType.needNotify((KylinConfig)projectConfig);
        if (!needNotification) {
            logger.info("[{}] is not specified by user, not need to notify users.", (Object)notificationType.getDisplayName());
            return false;
        }
        List<String> users = this.getAllNotifyUsers((KylinConfig)projectConfig);
        if (this instanceof DefaultExecutable) {
            return MailNotifier.notifyUser((KylinConfig)projectConfig, JobMailUtil.createMail(notificationType, this), users);
        }
        return MailNotifier.notifyUser((KylinConfig)projectConfig, JobMailUtil.createMail(notificationType, this.getParent()), users);
    }

    public void setSparkYarnQueueIfEnabled(String project, String yarnQueue) {
        ProjectInstance proj = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project);
        KylinConfigExt config = proj.getConfig();
        if (config.isSetYarnQueueInTaskEnabled() && config.getYarnQueueInTaskAvailable().contains(yarnQueue)) {
            this.setSparkYarnQueue(yarnQueue);
        }
    }

    public final AbstractExecutable getParent() {
        return this.getManager().getJob(this.getParam(PARENT_ID));
    }

    public final AbstractExecutable getParent(ExecutablePO po) {
        return this.getManager().getJob(this.getParam(PARENT_ID), po);
    }

    public void checkParentJobStatus() {
        if (this.getParent().getStatus() != ExecutableState.RUNNING) {
            throw new IllegalStateException("invalid parent job state, parent job:" + this.getParent().getDisplayName() + ", state:" + (Object)((Object)this.getParent().getStatus()));
        }
    }

    @Override
    public final String getProject() {
        if (this.project == null) {
            throw new IllegalStateException("project is not set for abstract executable " + this.getId());
        }
        return this.project;
    }

    public final void setProject(String project) {
        this.project = project;
    }

    @Override
    public final String getJobId() {
        return this.getId();
    }

    @Override
    public final Output getOutput() {
        return this.getManager().getOutput(this.getId());
    }

    public final Output getOutput(ExecutablePO executablePO) {
        return this.getManager().getOutput(this.getId(), executablePO);
    }

    public final long getStartTime() {
        return AbstractExecutable.getStartTime(this.getOutput());
    }

    public static long getStartTime(Output output) {
        return output.getStartTime();
    }

    public final long getEndTime() {
        return AbstractExecutable.getEndTime(this.getOutput());
    }

    public static long getEndTime(Output output) {
        return output.getEndTime();
    }

    public final long getEndTime(ExecutablePO po) {
        return AbstractExecutable.getEndTime(this.getOutput(po));
    }

    public final Map<String, String> getExtraInfo() {
        return this.getOutput().getExtra();
    }

    public final long getCreateTime() {
        return this.getManager().getCreateTime(this.getId());
    }

    public static long getCreateTime(Output output) {
        return output.getCreateTime();
    }

    public long getDurationFromStepOrStageDurationSum(ExecutablePO executablePO) {
        long duration = this.getDuration(executablePO);
        if (this instanceof DagExecutable && this.getJobSchedulerMode() == JobSchedulerModeEnum.DAG) {
            duration = this.calculateDagExecutableDuration(executablePO);
        } else if (this instanceof ChainedExecutable) {
            duration = this.calculateChainedExecutableDuration(executablePO);
        }
        return duration;
    }

    private long calculateDagExecutableDuration(ExecutablePO executablePO) {
        List<AbstractExecutable> tasks = ((DagExecutable)((Object)this)).getTasks();
        Map<String, AbstractExecutable> tasksMap = tasks.stream().collect(Collectors.toMap(AbstractExecutable::getId, task -> task));
        return tasks.stream().filter(task -> StringUtils.isBlank((CharSequence)task.getPreviousStep())).map(task -> this.calculateDagTaskExecutableDuration((AbstractExecutable)task, executablePO, (Map<String, ? extends AbstractExecutable>)tasksMap)).max(Long::compare).orElse(0L);
    }

    private Long calculateDagTaskExecutableDuration(AbstractExecutable task, ExecutablePO executablePO, Map<String, ? extends AbstractExecutable> tasksMap) {
        Long nextTaskDurationMax = task.getNextSteps().stream().map(tasksMap::get).map(nextTask -> this.calculateDagTaskExecutableDuration((AbstractExecutable)nextTask, executablePO, tasksMap)).max(Long::compare).orElse(0L);
        return this.getTaskDuration(task, executablePO) + nextTaskDurationMax;
    }

    private long calculateChainedExecutableDuration(ExecutablePO executablePO) {
        List<AbstractExecutable> tasks = ((ChainedExecutable)((Object)this)).getTasks();
        AtomicLong jobAtomicDuration = new AtomicLong(0L);
        tasks.forEach(task -> {
            long taskDuration = this.getTaskDuration((AbstractExecutable)task, executablePO);
            jobAtomicDuration.addAndGet(taskDuration);
        });
        return jobAtomicDuration.get();
    }

    @VisibleForTesting
    public long getTaskDurationToTest(AbstractExecutable task, ExecutablePO executablePO) {
        return this.getTaskDuration(task, executablePO);
    }

    private long getTaskDuration(AbstractExecutable task, ExecutablePO executablePO) {
        long taskDuration = task.getDuration(executablePO);
        if (task instanceof ChainedStageExecutable) {
            taskDuration = this.calculateSingleSegmentStagesDuration((ChainedStageExecutable)((Object)task), executablePO, taskDuration);
        }
        return taskDuration;
    }

    private long calculateSingleSegmentStagesDuration(ChainedStageExecutable task, ExecutablePO executablePO, long taskDuration) {
        Map<String, List<StageExecutable>> stagesMap = task.getStagesMap();
        if (stagesMap.size() == 1) {
            for (Map.Entry<String, List<StageExecutable>> entry : stagesMap.entrySet()) {
                taskDuration = entry.getValue().stream().map(stage -> AbstractExecutable.getStageDuration(stage.getOutput((String)entry.getKey()), this.getParent())).mapToLong(Long::valueOf).sum();
            }
        }
        return taskDuration;
    }

    public long getDuration() {
        return AbstractExecutable.getDuration(this.getOutput());
    }

    public long getDuration(ExecutablePO executablePO) {
        return AbstractExecutable.getDuration(this.getOutput(executablePO));
    }

    public static long computeDuration(Output output) {
        if (output.getStartTime() == 0L) {
            return 0L;
        }
        return output.getEndTime() == 0L ? System.currentTimeMillis() - output.getStartTime() : output.getEndTime() - output.getStartTime();
    }

    public static long getStageDuration(Output output, AbstractExecutable parent) {
        if (output.getDuration() != 0L) {
            long duration = output.getDuration();
            if (parent != null && parent.getStatus() == ExecutableState.RUNNING && ExecutableState.RUNNING == output.getState()) {
                duration = duration + System.currentTimeMillis() - output.getLastRunningStartTime();
            }
            return duration;
        }
        return AbstractExecutable.computeDuration(output);
    }

    public static long getDuration(Output output) {
        if (output.getDuration() != 0L) {
            long duration = output.getDuration();
            if (ExecutableState.RUNNING == output.getState()) {
                duration = duration + System.currentTimeMillis() - output.getLastRunningStartTime();
            }
            return duration;
        }
        return AbstractExecutable.computeDuration(output);
    }

    public long getWaitTime() {
        String jobId = ExecutableManager.extractJobId(this.getId());
        return this.getWaitTime(this.getManager().getExecutablePO(jobId));
    }

    public long getWaitTime(ExecutablePO po) {
        long waitTime;
        Output output = this.getOutput(po);
        long startTime = output.getStartTime();
        long lastTaskEndTime = output.getCreateTime();
        ExecutableState lastTaskStatus = output.getState();
        int stepId = this.getStepId();
        if (this.getParent(po) instanceof DefaultExecutable) {
            DefaultExecutable parentExecutable = (DefaultExecutable)this.getParent(po);
            Optional<AbstractExecutable> lastExecutable = parentExecutable.getSubTaskByStepId(stepId - 1);
            lastTaskEndTime = lastExecutable.map(e -> e.getEndTime(po)).orElse(parentExecutable.getOutput(po).getCreateTime());
            lastTaskStatus = lastExecutable.map(e -> e.getStatus(po)).orElse(parentExecutable.getStatus(po));
        }
        if (stepId > 0 && (lastTaskEndTime == 0L || lastTaskStatus != ExecutableState.SUCCEED)) {
            return 0L;
        }
        if (startTime == 0L) {
            startTime = this.getParent(po) != null && this.getParent(po).getStatus(po) == ExecutableState.DISCARDED ? this.getParent(po).getEndTime(po) : System.currentTimeMillis();
        }
        return (waitTime = startTime - lastTaskEndTime) < 0L ? 0L : waitTime;
    }

    public long getTotalDurationTime() {
        return this.getDuration() + this.getWaitTime();
    }

    public final Set<String> getDependentFiles() {
        String value = this.getExtraInfo().getOrDefault(DEPENDENT_FILES, "");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet((Object[])value.split(","));
    }

    protected final boolean isStoppedNonVoluntarily() {
        Preconditions.checkState((this.getParent() == null ? 1 : 0) != 0);
        ExecutableState status = this.getOutput().getState();
        return status.isStoppedNonVoluntarily();
    }

    protected boolean needRetry() {
        return this.retry <= this.getConfig().getJobRetry();
    }

    public Set<String> getDependencies(KylinConfig config) {
        return Sets.newHashSet();
    }

    private static int computeTableAnalyzeMemory() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        return config.getSparkEngineDriverMemoryTableSampling();
    }

    private static int computeSnapshotAnalyzeMemory() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        return config.getSparkEngineDriverMemorySnapshotBuilding();
    }

    private static int computeInternalTableLoadMemory() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        return config.getSparkEngineDriverMemoryInternalTableLoading();
    }

    @Override
    public int computeStepDriverMemory() {
        switch (this.getJobType().getCategory()) {
            case "OTHER": {
                return AbstractExecutable.computeTableAnalyzeMemory();
            }
            case "SNAPSHOT": {
                return AbstractExecutable.computeSnapshotAnalyzeMemory();
            }
            case "INTERNAL": {
                return AbstractExecutable.computeInternalTableLoadMemory();
            }
        }
        String layouts = this.getParam("layoutIds");
        if (layouts != null) {
            return AbstractExecutable.computeDriverMemory(StringHelper.splitAndTrim((String)layouts, (String)",").length);
        }
        return DEFAULT_DRIVER_MEMORY;
    }

    public static Integer computeDriverMemory(Integer cuboidNum) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int[] driverMemoryStrategy = config.getSparkEngineDriverMemoryStrategy();
        ArrayList strategy = Lists.newArrayList((Object[])new Integer[]{cuboidNum});
        Arrays.stream(driverMemoryStrategy).forEach(strategy::add);
        Collections.sort(strategy);
        int index = strategy.indexOf(cuboidNum);
        int driverMemoryMaximum = config.getSparkEngineDriverMemoryMaximum();
        int driverMemoryBase = config.getSparkEngineDriverMemoryBase();
        driverMemoryBase += driverMemoryBase * index;
        return Math.min(driverMemoryBase, driverMemoryMaximum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("state", (Object)this.getStatus()).toString();
    }

    public <T> T wrapWithExecuteException(Callable<T> lambda) throws ExecuteException {
        Throwable exception = null;
        try {
            T t = lambda.call();
            return t;
        }
        catch (ExecuteException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ExecuteException((Throwable)e);
        }
        finally {
            if (exception != null && !(exception instanceof JobStoppedNonVoluntarilyException)) {
                this.wrapWithExecuteExceptionUpdateJobError((Exception)exception);
            }
        }
    }

    protected void wrapWithExecuteExceptionUpdateJobError(Exception exception) {
        JobContextUtil.withTxAndRetry(() -> {
            AbstractExecutable.getExecutableManager(this.project).updateJobError(this.getId(), this.getId(), null, ExceptionUtils.getStackTrace((Throwable)exception), exception.getMessage());
            return true;
        });
    }

    public boolean isInternalTableSparkJob() {
        return false;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public JobTypeEnum getJobType() {
        return this.jobType;
    }

    @Generated
    public void setJobType(JobTypeEnum jobType) {
        this.jobType = jobType;
    }

    @Generated
    public String getLogPath() {
        return this.logPath;
    }

    @Generated
    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    @Generated
    public void setTargetSubject(String targetSubject) {
        this.targetSubject = targetSubject;
    }

    @Generated
    public String getTargetSubject() {
        return this.targetSubject;
    }

    @Generated
    public void setTargetSegments(List<String> targetSegments) {
        this.targetSegments = targetSegments;
    }

    @Generated
    public List<String> getTargetSegments() {
        return this.targetSegments;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public boolean isResumable() {
        return this.resumable;
    }

    @Generated
    public void setResumable(boolean resumable) {
        this.resumable = resumable;
    }

    @Generated
    public Map<String, Object> getRunTimeInfo() {
        return this.runTimeInfo;
    }

    @Generated
    public void setRunTimeInfo(Map<String, Object> runTimeInfo) {
        this.runTimeInfo = runTimeInfo;
    }

    @Generated
    public void setTargetPartitions(Set<Long> targetPartitions) {
        this.targetPartitions = targetPartitions;
    }

    @Generated
    public Set<Long> getTargetPartitions() {
        return this.targetPartitions;
    }

    @Override
    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Generated
    public Object getTag() {
        return this.tag;
    }

    @Generated
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Generated
    public int getStepId() {
        return this.stepId;
    }

    @Generated
    public void setStepId(int stepId) {
        this.stepId = stepId;
    }

    @Generated
    public ExecutablePO getPo() {
        return this.po;
    }

    @Generated
    public void setPo(ExecutablePO po) {
        this.po = po;
    }

    @Generated
    public JobSchedulerModeEnum getJobSchedulerMode() {
        return this.jobSchedulerMode;
    }

    @Generated
    public void setJobSchedulerMode(JobSchedulerModeEnum jobSchedulerMode) {
        this.jobSchedulerMode = jobSchedulerMode;
    }

    @Override
    @Generated
    public String getPreviousStep() {
        return this.previousStep;
    }

    @Generated
    public void setPreviousStep(String previousStep) {
        this.previousStep = previousStep;
    }

    @Override
    @Generated
    public Set<String> getNextSteps() {
        return this.nextSteps;
    }

    @Generated
    public void setNextSteps(Set<String> nextSteps) {
        this.nextSteps = nextSteps;
    }

    @Generated
    public String getParam(String key) {
        return this.executableParams.getParam(key);
    }

    @Generated
    public void setParam(String key, String value) {
        this.executableParams.setParam(key, value);
    }

    @Generated
    public void setParams(Map<String, String> params) {
        this.executableParams.setParams(params);
    }

    @Generated
    public void setParentId(String parentId) {
        this.executableParams.setParentId(parentId);
    }

    @Generated
    public void setSubmitter(String submitter) {
        this.executableParams.setSubmitter(submitter);
    }

    @Generated
    public void setParent(AbstractExecutable parent) {
        this.executableParams.setParent(parent);
    }

    @Generated
    public List<String> getAllNotifyUsers(KylinConfig kylinConfig) {
        return this.executableParams.getAllNotifyUsers(kylinConfig);
    }

    @Generated
    public String getParentId() {
        return this.executableParams.getParentId();
    }

    @Generated
    public String getSubmitter() {
        return this.executableParams.getSubmitter();
    }

    @Generated
    public long getDataRangeEnd() {
        return this.executableParams.getDataRangeEnd();
    }

    @Generated
    public long getDataRangeStart() {
        return this.executableParams.getDataRangeStart();
    }

    @Generated
    public Set<Long> getToBeDeletedLayoutIds() {
        return this.executableParams.getToBeDeletedLayoutIds();
    }

    @Generated
    public Set<Long> getLayoutIds() {
        return this.executableParams.getLayoutIds();
    }

    @Generated
    public Set<String> getSegmentIds() {
        return this.executableParams.getSegmentIds();
    }

    @Generated
    public void setSparkYarnQueue(String queue) {
        this.executableParams.setSparkYarnQueue(queue);
    }

    @Generated
    public String getSparkYarnQueue() {
        return this.executableParams.getSparkYarnQueue();
    }

    @Generated
    public Map<String, Set<Long>> getPartitionsBySegment() {
        return this.executableParams.getPartitionsBySegment();
    }

    @Override
    @Generated
    public Map<String, String> getParams() {
        return this.executableParams.getParams();
    }

    public static interface Callback {
        public void process() throws Exception;
    }
}

