/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.handler;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.AbstractJobHandler;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeSegmentHandler
extends AbstractJobHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergeSegmentHandler.class);

    @Override
    protected AbstractExecutable createJob(JobParam jobParam) {
        NDataflow df = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getDataflow(jobParam.getModel());
        NDataSegment newSeg = df.getSegment(jobParam.getSegment());
        HashSet<NDataSegment> mergeSegment = new HashSet<NDataSegment>();
        mergeSegment.add(newSeg);
        return JobFactory.createJob("MERGE_JOB_FACTORY", new JobFactory.JobBuildParams(mergeSegment, jobParam.getProcessLayouts(), jobParam.getOwner(), JobTypeEnum.INDEX_MERGE, jobParam.getJobId(), null, jobParam.getIgnoredSnapshotTables(), jobParam.getTargetPartitions(), jobParam.getTargetBuckets(), jobParam.getExtParams()));
    }

    @Override
    protected void checkBeforeHandle(JobParam jobParam) {
        super.checkBeforeHandle(jobParam);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NDataflow df = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)jobParam.getProject()).getDataflow(jobParam.getModel());
        Segments segments = df.getSegments();
        NDataSegment newSegment = df.getSegment(jobParam.getSegment());
        Set layoutIds = null;
        for (NDataSegment seg : segments) {
            if (seg.getId().equals(newSegment.getId())) continue;
            if (seg.getSegRange().overlaps(newSegment.getSegRange()) && null == layoutIds) {
                layoutIds = seg.getLayoutsMap().keySet();
            }
            if (!seg.getSegRange().overlaps(newSegment.getSegRange()) || seg.getLayoutsMap().keySet().equals(layoutIds)) continue;
            log.warn("Segment's layout is not matched,segID:{}, {} -> {}", new Object[]{seg.getId(), layoutIds, seg.getLayoutsMap().keySet()});
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_SEGMENT_FAIL, new Object[0]);
        }
    }
}

