/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.bisync.tableau;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.tool.bisync.BISyncModel;
import org.apache.kylin.tool.bisync.tableau.datasource.TableauDatasource;

public class TableauDatasourceModel
implements BISyncModel {
    private final TableauDatasource tableauDatasource;

    public TableauDatasourceModel(TableauDatasource tableauDatasource) {
        this.tableauDatasource = tableauDatasource;
    }

    public static void dumpModelAsXML(TableauDatasource biSyncModel, OutputStream outputStream) throws XMLStreamException, IOException {
        XmlMapper xmlMapper = new XmlMapper();
        XMLStreamWriter writer = xmlMapper.getFactory().getXMLOutputFactory().createXMLStreamWriter(outputStream);
        xmlMapper.enable(ToXmlGenerator.Feature.WRITE_XML_DECLARATION);
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        xmlMapper.getFactory().getXMLOutputFactory().setProperty("javax.xml.stream.isRepairingNamespaces", false);
        xmlMapper.writeValue(writer, (Object)biSyncModel);
    }

    @Override
    public void dump(OutputStream outputStream) {
        try {
            TableauDatasourceModel.dumpModelAsXML(this.tableauDatasource, outputStream);
        }
        catch (IOException | XMLStreamException e) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.UNKNOWN_ERROR_CODE, (Throwable)e);
        }
    }
}

