/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.guava30.shaded.common.base.Charsets;
import org.apache.kylin.guava30.shaded.common.hash.Hashing;
import org.apache.kylin.rest.ISmartApplicationListenerForSystem;
import org.apache.kylin.rest.LoadBalanced;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JCircuitBreakerFactory;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.session.config.annotation.web.http.EnableSpringHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@ImportResource(locations={"applicationContext.xml", "kylinSecurity.xml"})
@SpringBootApplication(scanBasePackages={"org.apache.kylin"})
@EnableScheduling
@EnableAsync
@EnableCaching
@EnableDiscoveryClient
@LoadBalancerClient(name="spring-boot-provider", configuration={LoadBalanced.class})
@EnableSpringHttpSession
@MapperScan(value={"org.apache.kylin.job.mapper"})
public class BootstrapServer
implements ISmartApplicationListenerForSystem {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapServer.class);

    public static void main(String[] args) {
        SpringApplication.run(BootstrapServer.class, (String[])args);
    }

    @Bean
    public ServletWebServerFactory servletContainer() {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        tomcat.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.setRequestCharacterEncoding("UTF-8")});
        if (KylinConfig.getInstanceFromEnv().isServerHttpsEnabled()) {
            tomcat.addAdditionalTomcatConnectors(new Connector[]{this.createSslConnector()});
        }
        return tomcat;
    }

    @Bean
    public Customizer<Resilience4JCircuitBreakerFactory> defaultCustomizer() {
        return factory -> factory.configureDefault(id -> new Resilience4JConfigBuilder(id).timeLimiterConfig(TimeLimiterConfig.custom().timeoutDuration(Duration.ofHours(1L)).build()).build());
    }

    private Connector createSslConnector() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
        connector.setScheme("https");
        connector.setSecure(true);
        connector.setPort(kylinConfig.getServerHttpsPort());
        protocol.setSSLEnabled(true);
        protocol.setKeystoreType(kylinConfig.getServerHttpsKeyType());
        protocol.setKeystoreFile(kylinConfig.getServerHttpsKeystore());
        protocol.setKeyAlias(kylinConfig.getServerHttpsKeyAlias());
        String serverHttpsKeyPassword = kylinConfig.getServerHttpsKeyPassword();
        if (EncryptUtil.isEncrypted((String)serverHttpsKeyPassword)) {
            serverHttpsKeyPassword = EncryptUtil.decryptPassInKylin((String)serverHttpsKeyPassword);
        }
        protocol.setKeystorePass(serverHttpsKeyPassword);
        return connector;
    }

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        StorageURL url = KylinConfig.getInstanceFromEnv().getMetadataUrl();
        String cookieName = url.getIdentifier() + (url.getParameter("url") == null ? "" : "_" + url.getParameter("url"));
        cookieName = cookieName.replaceAll("\\W", "_");
        cookieName = Hashing.sha256().newHasher().putString((CharSequence)cookieName, Charsets.UTF_8).hash().toString();
        serializer.setCookieName(cookieName);
        return serializer;
    }

    @Bean
    public InstanceSerializer<ZookeeperInstance> zookeeperInstanceInstanceSerializer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            logger.info("init backend end...");
        } else if (event instanceof ContextClosedEvent) {
            logger.info("Stop Kylin 5 node...");
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

