/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.interceptor.ProjectInfoParser;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import reactor.core.publisher.Mono;

public class ResourceGroupLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceGroupLoadBalancer.class);
    private ClusterManager clusterManager;

    public ResourceGroupLoadBalancer(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        return Mono.fromCallable(() -> this.getInstanceResponse());
    }

    private Response<ServiceInstance> getInstanceResponse() {
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        ResourceGroupManager rgManager = ResourceGroupManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        List jobNodes = this.clusterManager.getJobServers().stream().map(ServerInfoResponse::getHost).collect(Collectors.toList());
        String project = (String)ProjectInfoParser.parseProjectInfo((HttpServletRequest)httpServletRequest).getFirst();
        if (rgManager.isResourceGroupEnabled() && !project.equals("_global")) {
            jobNodes = rgManager.getInstancesForProject(project);
        }
        if (jobNodes.isEmpty()) {
            Message msg = MsgPicker.getMsg();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SYSTEM_IS_RECOVER, msg.getLeadersHandleOver());
        }
        String randomNode = (String)jobNodes.get(RandomUtil.nextInt((int)jobNodes.size()));
        String[] host = randomNode.split(":");
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance("all", "all", host[0], Integer.parseInt(host[1]), false);
        log.info("Request {} is redirecting to random job node {}.", (Object)httpServletRequest.getRequestURI(), (Object)serviceInstance);
        return new DefaultResponse((ServiceInstance)serviceInstance);
    }
}

