/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage;

import com.google.common.base.Throwables;
import io.delta.storage.HadoopFileSystemLogStore;
import io.delta.storage.internal.ThreadUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;

public class GCSLogStore
extends HadoopFileSystemLogStore {
    final String preconditionFailedExceptionMessage = "412 Precondition Failed";

    public GCSLogStore(Configuration configuration) {
        super(configuration);
    }

    @Override
    public void write(Path path, Iterator<String> iterator, Boolean bl, Configuration configuration) throws IOException {
        FileSystem fileSystem = path.getFileSystem(configuration);
        if (fileSystem instanceof LocalFileSystem && !bl.booleanValue() && fileSystem.exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        Callable<Object> callable = () -> {
            FSDataOutputStream fSDataOutputStream = fileSystem.create(path, bl.booleanValue());
            while (iterator.hasNext()) {
                fSDataOutputStream.write(((String)iterator.next() + "\n").getBytes(StandardCharsets.UTF_8));
            }
            fSDataOutputStream.close();
            return "";
        };
        try {
            ThreadUtils.runInNewThread("delta-gcs-logstore-write", true, callable);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        catch (IOException iOException) {
            if (this.isPreconditionFailure(iOException)) {
                if (!bl.booleanValue()) {
                    throw new java.nio.file.FileAlreadyExistsException(path.toString());
                }
            }
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
    }

    private boolean isPreconditionFailure(Throwable throwable2) {
        return Throwables.getCausalChain((Throwable)throwable2).stream().filter(throwable -> throwable != null).filter(throwable -> throwable.getMessage() != null).anyMatch(throwable -> throwable.getMessage().contains("412 Precondition Failed"));
    }

    @Override
    public Boolean isPartialWriteVisible(Path path, Configuration configuration) throws IOException {
        return false;
    }
}

