/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import io.kyligence.config.core.loader.IExternalConfigLoader;
import io.kyligence.config.external.loader.NacosExternalConfigLoader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinExternalConfigLoader;
import org.apache.kylin.common.ShellKylinExternalConfigLoaderFactory;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.SetEnvironmentVariable;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;

@MetadataInfo
class ShellKylinExternalConfigLoaderFactoryTest {
    ShellKylinExternalConfigLoaderFactoryTest() {
    }

    @Test
    void testGetConfigLoader() {
        IExternalConfigLoader configLoader = ShellKylinExternalConfigLoaderFactory.getConfigLoader();
        Assertions.assertInstanceOf(KylinExternalConfigLoader.class, (Object)configLoader);
    }

    @Test
    void testGetConfigLoaderByConfigYaml() throws IOException {
        Path confPath = Paths.get(KylinConfig.getKylinHome(), "conf");
        confPath.toFile().mkdir();
        Path configFile = Files.createFile(Paths.get(KylinConfig.getKylinHome(), "conf", "config.yaml"), new FileAttribute[0]);
        String content = "spring:\n  cloud:\n    nacos:\n      config:\n        server-addr: ${NACOS_CONFIG_SERVER_ADDR}\n\nkylin:\n  external:\n    config:\n      infos:\n        - target: org.apache.kylin.common.KylinConfig\n          type: nacos\n          properties:\n            app: \"${APP_NAME:ShellKylinExternalConfigLoaderFactoryTest}\"\n            zhName: \"${APP_DISPLAY_NAME}\"\n            dataIds: \"${APP_NAME:common}-kylin-config\"\n            group: \"${TENANT_ID}\"\n            autoRefresh: true\n            needInit: true\n            initConfigContent: \"${KYLIN_HOME}/conf/init.properties\"\n            configPropertyFileType: \"PROPERTIES\"\n            configLibrary: \"${KYLIN_HOME}/conf/config_library.csv\"";
        Files.write(configFile, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        try (MockedConstruction mockedConstruction = Mockito.mockConstruction(NacosExternalConfigLoader.class);){
            IExternalConfigLoader configLoader = ShellKylinExternalConfigLoaderFactory.getConfigLoader();
            Assertions.assertInstanceOf(NacosExternalConfigLoader.class, (Object)configLoader);
        }
    }

    @Test
    @SetEnvironmentVariable(key="KYLIN_LEGACY_CONFIG", value="true")
    void testGetConfigLoaderWithConfigYamlAndUSE_LEGACY_CONFIG() throws IOException {
        Path confPath = Paths.get(KylinConfig.getKylinHome(), "conf");
        confPath.toFile().mkdir();
        Path configFile = Files.createFile(Paths.get(KylinConfig.getKylinHome(), "conf", "config.yaml"), new FileAttribute[0]);
        String content = "spring:\n  cloud:\n    nacos:\n      config:\n        server-addr: ${NACOS_CONFIG_SERVER_ADDR}\n\nkylin:\n  external:\n    config:\n      infos:\n        - target: org.apache.kylin.common.KylinConfig\n          type: nacos\n          properties:\n            app: \"${APP_NAME:ShellKylinExternalConfigLoaderFactoryTest}\"\n            zhName: \"${APP_DISPLAY_NAME}\"\n            dataIds: \"${APP_NAME:common}-kylin-config\"\n            group: \"${TENANT_ID}\"\n            autoRefresh: true\n            needInit: true\n            initConfigContent: \"${KYLIN_HOME}/conf/init.properties\"\n            configPropertyFileType: \"PROPERTIES\"\n            configLibrary: \"${KYLIN_HOME}/conf/config_library.csv\"";
        Files.write(configFile, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        try (MockedConstruction mockedConstruction = Mockito.mockConstruction(NacosExternalConfigLoader.class);){
            IExternalConfigLoader configLoader = ShellKylinExternalConfigLoaderFactory.getConfigLoader();
            Assertions.assertInstanceOf(KylinExternalConfigLoader.class, (Object)configLoader);
        }
    }
}

