/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.util.Collections;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.metadata.MemoryAuditLogStore;
import org.apache.kylin.common.persistence.resources.ProjectRawResource;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@MetadataInfo(onlyProps=true)
class MemoryAuditLogStoreTest {
    MemoryAuditLogStoreTest() {
    }

    @Test
    void testGet() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        MemoryAuditLogStore logStore = new MemoryAuditLogStore(config);
        ProjectRawResource prj = new ProjectRawResource();
        prj.setMvcc(0L);
        prj.setName("p1");
        prj.setTs(Long.valueOf(System.currentTimeMillis()));
        prj.setContent("abc".getBytes());
        prj.setProject("_global");
        ResourceCreateOrUpdateEvent event = new ResourceCreateOrUpdateEvent("PROJECT/p1", (RawResource)prj);
        UnitMessages unitMessages = new UnitMessages(Collections.singletonList(event));
        logStore.save(unitMessages);
        Assertions.assertNull((Object)logStore.get("PROJECT/p2", 0L));
        Assertions.assertNull((Object)logStore.get("PROJECT/p1", 1L));
        Assertions.assertNotNull((Object)logStore.get("PROJECT/p1", 0L));
    }
}

