/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import org.apache.kylin.common.util.FilePathUtil;
import org.junit.Assert;
import org.junit.Test;

public class FilePathUtilTest {
    @Test
    public void testReturnFilePathIfExists() throws IOException {
        Assert.assertTrue((boolean)FilePathUtil.returnFilePathIfExists(null).isEmpty());
        Assert.assertTrue((boolean)FilePathUtil.returnFilePathIfExists((String[])new String[]{null, ""}).isEmpty());
        Assert.assertTrue((boolean)FilePathUtil.returnFilePathIfExists((String[])new String[]{null, "notEmpty"}).isEmpty());
        Assert.assertTrue((boolean)FilePathUtil.returnFilePathIfExists((String[])new String[]{"notNull", ""}).isEmpty());
        Assert.assertTrue((String)"", (boolean)FilePathUtil.returnFilePathIfExists((String[])new String[]{"testPath"}).isEmpty());
        File tempFile = File.createTempFile("start-", "-end");
        Assert.assertTrue((boolean)FilePathUtil.returnFilePathIfExists((String[])new String[]{tempFile.getParent()}).isEmpty());
        Assert.assertFalse((boolean)FilePathUtil.returnFilePathIfExists((String[])new String[]{tempFile.getAbsolutePath()}).isEmpty());
        tempFile.deleteOnExit();
    }
}

