/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kylin.common.util.RangeUtil;
import org.apache.kylin.guava30.shaded.common.collect.Range;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RangeUtilTest {
    @Test
    public void testFilter() {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        map.put(3, 3);
        map.put(1, 1);
        map.put(2, 2);
        NavigableMap subMap = RangeUtil.filter(map, (Range)Range.all());
        Assertions.assertEquals((int)subMap.size(), (int)3);
        subMap = RangeUtil.filter(map, (Range)Range.atLeast((Comparable)Integer.valueOf(2)));
        Assertions.assertEquals((int)subMap.size(), (int)2);
        subMap = RangeUtil.filter(map, (Range)Range.greaterThan((Comparable)Integer.valueOf(2)));
        Assertions.assertEquals((int)subMap.size(), (int)1);
        subMap = RangeUtil.filter(map, (Range)Range.greaterThan((Comparable)Integer.valueOf(0)));
        Assertions.assertEquals((int)subMap.size(), (int)3);
        subMap = RangeUtil.filter(map, (Range)Range.greaterThan((Comparable)Integer.valueOf(5)));
        Assertions.assertEquals((int)subMap.size(), (int)0);
        subMap = RangeUtil.filter(map, (Range)Range.atMost((Comparable)Integer.valueOf(2)));
        Assertions.assertEquals((int)subMap.size(), (int)2);
        subMap = RangeUtil.filter(map, (Range)Range.lessThan((Comparable)Integer.valueOf(2)));
        Assertions.assertEquals((int)subMap.size(), (int)1);
        subMap = RangeUtil.filter(map, (Range)Range.lessThan((Comparable)Integer.valueOf(5)));
        Assertions.assertEquals((int)subMap.size(), (int)3);
        subMap = RangeUtil.filter(map, (Range)Range.lessThan((Comparable)Integer.valueOf(0)));
        Assertions.assertEquals((int)subMap.size(), (int)0);
    }

    @Test
    public void testBuildRanges() {
        int[] test1 = new int[]{1, 2, 3, 5, 7, 8, 10, 4};
        TreeSet treeSet = Sets.newTreeSet();
        for (int t : test1) {
            treeSet.add(t);
        }
        ArrayList ranges = RangeUtil.buildRanges(new TreeSet(treeSet));
        Assertions.assertEquals((int)3, (int)ranges.size());
    }
}

