/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.SSHClient;
import org.apache.kylin.common.util.SSHClientOutput;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@MetadataInfo(onlyProps=true)
public class SSHClientTest {
    private boolean isRemote;
    private String hostname;
    private int port;
    private String username;
    private String password;

    @BeforeEach
    public void setUp() throws Exception {
        this.loadPropertiesFile();
    }

    private void loadPropertiesFile() throws IOException {
        KylinConfig cfg = KylinConfig.getInstanceFromEnv();
        this.isRemote = cfg.getRunAsRemoteCommand();
        this.port = cfg.getRemoteHadoopCliPort();
        this.hostname = cfg.getRemoteHadoopCliHostname();
        this.username = cfg.getRemoteHadoopCliUsername();
        this.password = cfg.getRemoteHadoopCliPassword();
    }

    @Test
    public void testCmd() throws Exception {
        if (!this.isRemote) {
            return;
        }
        SSHClient ssh = new SSHClient(this.hostname, this.port, this.username, this.password);
        SSHClientOutput output = ssh.execCommand("echo hello");
        Assert.assertEquals((long)0L, (long)output.getExitCode());
        Assert.assertEquals((Object)"hello\n", (Object)output.getText());
    }

    @Test
    public void testCmdWithLargeOutput() throws Exception {
        if (!this.isRemote) {
            return;
        }
        int maxCommandLineOutputLength = KylinConfig.getInstanceFromEnv().getMaxCommandLineOutputLength();
        Assertions.assertEquals((int)0x500000, (int)maxCommandLineOutputLength);
        int HEAD_TAIL_LEN = 18;
        SSHClient ssh = new SSHClient(this.hostname, this.port, this.username, this.password);
        SSHClientOutput sshClientOutput = ssh.execCommand("echo 'testhead' && line=$(printf 'a%.0s' {1..1251}) && yes \"$line\" 2>/dev/null | head -n 5505 && echo 'testtail'");
        String result = sshClientOutput.getText();
        Assertions.assertEquals((int)maxCommandLineOutputLength, (int)result.length());
        Assertions.assertTrue((boolean)result.startsWith("testhead"));
        Assertions.assertTrue((boolean)result.endsWith("testtail\n"));
        sshClientOutput = ssh.execCommand("echo 'testhead' && line=$(printf 'a%.0s' {1..111}) && yes \"$line\" 2>/dev/null | head -n 53248 && echo 'testtail'");
        result = sshClientOutput.getText();
        Assertions.assertEquals((int)maxCommandLineOutputLength, (int)result.length());
        Assertions.assertTrue((boolean)result.startsWith("testhead"));
        Assertions.assertTrue((boolean)result.endsWith("testtail\n"));
        sshClientOutput = ssh.execCommand("echo 'testhead' && line=$(printf 'a%.0s' {1..9}) && yes \"$line\" 2>/dev/null | head -n 525312 && echo 'testtail'");
        result = sshClientOutput.getText();
        Assertions.assertEquals((int)maxCommandLineOutputLength, (int)result.length());
        Assertions.assertTrue((boolean)result.startsWith("testhead"));
        Assertions.assertTrue((boolean)result.endsWith("testtail\n"));
        sshClientOutput = ssh.execCommand("echo 'testhead' && line=$(printf 'a%.0s' {1..1251}) && yes \"$line\" 2>/dev/null | head -n 1000 && echo 'testtail'");
        result = sshClientOutput.getText();
        Assertions.assertEquals((int)1252018, (int)result.length());
        Assertions.assertTrue((boolean)result.startsWith("testhead"));
        Assertions.assertTrue((boolean)result.endsWith("testtail\n"));
        sshClientOutput = ssh.execCommand("echo 'testhead' && line=$(printf 'a%.0s' {1..111}) && yes \"$line\" 2>/dev/null | head -n 10240 && echo 'testtail'");
        result = sshClientOutput.getText();
        Assertions.assertEquals((int)1146898, (int)result.length());
        Assertions.assertTrue((boolean)result.startsWith("testhead"));
        Assertions.assertTrue((boolean)result.endsWith("testtail\n"));
        sshClientOutput = ssh.execCommand("echo 'testhead' && line=$(printf 'a%.0s' {1..9}) && yes \"$line\" 2>/dev/null | head -n 102400 && echo 'testtail'");
        result = sshClientOutput.getText();
        Assertions.assertEquals((int)1024018, (int)result.length());
        Assertions.assertTrue((boolean)result.startsWith("testhead"));
        Assertions.assertTrue((boolean)result.endsWith("testtail\n"));
    }

    @Test
    public void testScpFileToRemote() throws Exception {
        if (!this.isRemote) {
            return;
        }
        SSHClient ssh = new SSHClient(this.hostname, this.port, this.username, this.password);
        File tmpFile = File.createTempFile("test_scp", "", new File("/tmp"));
        tmpFile.deleteOnExit();
        FileUtils.write((File)tmpFile, (CharSequence)"test_scp", (Charset)Charset.defaultCharset());
        ssh.scpFileToRemote(tmpFile.getAbsolutePath(), "/tmp");
    }

    @Test
    public void testRemoveKerberosPromption() throws Exception {
        SSHClient ssh = new SSHClient(this.hostname, this.port, this.username, this.password);
        Method newJSchSession = ssh.getClass().getDeclaredMethod("newJSchSession", new Class[0]);
        newJSchSession.setAccessible(true);
        Session s = (Session)newJSchSession.invoke((Object)ssh, new Object[0]);
        Assert.assertEquals((Object)"no", (Object)s.getConfig("StrictHostKeyChecking"));
        Assert.assertEquals((Object)"publickey,keyboard-interactive,password", (Object)s.getConfig("PreferredAuthentications"));
    }
}

