/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.kylin.common.util.TailBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TailBuilderTest {
    @Test
    public void testConstructor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TailBuilder(-1));
    }

    @Test
    public void testAppendCharSequence() {
        TailBuilder tailBuilder = new TailBuilder(10);
        tailBuilder.append((CharSequence)"");
        Assertions.assertEquals((int)0, (int)tailBuilder.length());
        tailBuilder.append((CharSequence)"abc");
        Assertions.assertEquals((int)3, (int)tailBuilder.length());
        tailBuilder.append((CharSequence)"12345678");
        Assertions.assertEquals((Object)"bc12345678", (Object)tailBuilder.toString());
        Assertions.assertEquals((int)10, (int)tailBuilder.length());
        tailBuilder = new TailBuilder(10);
        tailBuilder.append((CharSequence)"1234567890");
        Assertions.assertEquals((Object)"1234567890", (Object)tailBuilder.toString());
        Assertions.assertEquals((int)10, (int)tailBuilder.length());
        tailBuilder = new TailBuilder(6);
        tailBuilder.append((CharSequence)"12345678901");
        Assertions.assertEquals((Object)"678901", (Object)tailBuilder.toString());
        Assertions.assertEquals((int)6, (int)tailBuilder.length());
    }

    @Test
    public void testAppendChar() {
        TailBuilder tailBuilder = new TailBuilder(10);
        tailBuilder.append('a');
        Assertions.assertEquals((int)1, (int)tailBuilder.length());
    }

    @Test
    public void testEnsureWriteEntry() {
        TailBuilder tailBuilder = new TailBuilder(10);
        for (int i = 0; i < 10; ++i) {
            tailBuilder.append('a');
        }
        tailBuilder.append('b');
        Assertions.assertEquals((int)10, (int)tailBuilder.length());
        Assertions.assertEquals((Object)"aaaaaaaaab", (Object)tailBuilder.toString());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testLargeStr(boolean appendHead) {
        StringBuilder stringBuilder = new StringBuilder();
        TailBuilder tailBuilder = new TailBuilder(512);
        if (appendHead) {
            stringBuilder.append("test head");
            tailBuilder.append((CharSequence)"test head");
        }
        char[] chars = new char[1124];
        for (int i = 0; i < 1124; ++i) {
            chars[i] = (char)(97 + i % 26);
        }
        String testStr = new String(chars);
        stringBuilder.append(testStr);
        tailBuilder.append((CharSequence)testStr);
        Assertions.assertEquals((int)512, (int)tailBuilder.length());
        Assertions.assertEquals((Object)stringBuilder.substring(stringBuilder.length() - 512), (Object)tailBuilder.toString());
    }
}

