/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DeltaTableUtils$
implements PredicateHelper,
DeltaLogging {
    public static DeltaTableUtils$ MODULE$;
    private final List<String> validDeltaTableHadoopPrefixes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaTableUtils$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public List<String> validDeltaTableHadoopPrefixes() {
        return this.validDeltaTableHadoopPrefixes;
    }

    public boolean isDeltaTable(CatalogTable table) {
        return DeltaSourceUtils$.MODULE$.isDeltaTable((Option<String>)table.provider());
    }

    public boolean isDeltaTable(SparkSession spark, TableIdentifier tableName) {
        SessionCatalog catalog = spark.sessionState().catalog();
        boolean tableIsNotTemporaryTable = !catalog.isTempView(tableName);
        boolean tableExists = (tableName.database().isEmpty() || catalog.databaseExists((String)tableName.database().get())) && catalog.tableExists(tableName);
        return tableIsNotTemporaryTable && tableExists && this.isDeltaTable(catalog.getTableMetadata(tableName));
    }

    public boolean isDeltaTable(SparkSession spark, Path path, Map<String, String> options) {
        return this.findDeltaTableRoot(spark, path, options).isDefined();
    }

    public Map<String, String> isDeltaTable$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean isCatalogTable(SessionCatalog catalog, TableIdentifier tableIdent) {
        boolean bl;
        Tuple2<Object, Object> tuple2 = this.dbExistsAndAssumePath(catalog, tableIdent);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean dbExists = tuple2._1$mcZ$sp();
        boolean assumePath = tuple2._2$mcZ$sp();
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(dbExists, assumePath);
        Tuple2.mcZZ.sp sp3 = sp2;
        boolean dbExists2 = sp3._1$mcZ$sp();
        boolean assumePath2 = sp3._2$mcZ$sp();
        if (assumePath2) {
            return false;
        }
        if ((dbExists2 || tableIdent.database().isEmpty()) && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> catalog.tableExists(tableIdent)).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            bl = true;
        } else if (this.isValidPath(tableIdent)) {
            bl = false;
        } else {
            throw new NoSuchTableException((String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), tableIdent.table());
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<Object, Object> dbExistsAndAssumePath(SessionCatalog catalog, TableIdentifier ident) {
        boolean bl;
        boolean bl2 = false;
        Success success = null;
        boolean bl3 = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> DeltaTableUtils$.databaseExists$1(ident, catalog));
        if (try_ instanceof Success) {
            bl2 = true;
            success = (Success)try_;
            boolean bl4 = BoxesRunTime.unboxToBoolean((Object)success.value());
            if (bl4) {
                return new Tuple2.mcZZ.sp(true, false);
            }
        }
        if (bl2 && !(bl = BoxesRunTime.unboxToBoolean((Object)success.value()))) {
            return new Tuple2.mcZZ.sp(false, new Path(ident.table()).isAbsolute());
        }
        if (try_ instanceof Failure) {
            bl3 = true;
            failure = (Failure)try_;
            if (this.isValidPath(ident)) {
                return new Tuple2.mcZZ.sp(false, true);
            }
        }
        if (!bl3) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        throw e;
    }

    public boolean isValidPath(TableIdentifier tableIdent) {
        return DeltaSourceUtils$.MODULE$.isDeltaDataSourceName((String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")) && new Path(tableIdent.table()).isAbsolute();
    }

    public Option<Path> findDeltaTableRoot(SparkSession spark, Path path, Map<String, String> options) {
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConfWithOptions(options));
        return this.findDeltaTableRoot(fs, path);
    }

    public Option<Path> findDeltaTableRoot(FileSystem fs, Path path) {
        for (Path currentPath = path; currentPath != null; currentPath = currentPath.getParent()) {
            String string = currentPath.getName();
            String string2 = "_delta_log";
            if (!(string == null ? string2 != null : !string.equals(string2))) break;
            String string3 = currentPath.getName();
            String string4 = "_samples";
            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break;
            Path deltaLogPath = new Path(currentPath, "_delta_log");
            if (!BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fs.exists(deltaLogPath)).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) continue;
            return Option$.MODULE$.apply((Object)currentPath);
        }
        return None$.MODULE$;
    }

    public Map<String, String> findDeltaTableRoot$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean isHiddenDirectory(Seq<String> partitionColumnNames, String pathName) {
        return (pathName.startsWith(".") || pathName.startsWith("_")) && !pathName.startsWith("_delta_index") && !pathName.startsWith("_change_data") && !partitionColumnNames.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)pathName.startsWith((String)new StringOps(Predef$.MODULE$.augmentString(c)).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString("=")), Predef$.MODULE$.StringCanBuildFrom()))));
    }

    public boolean isPredicatePartitionColumnsOnly(Expression condition, Seq<String> partitionColumns, SparkSession spark) {
        Function2 nameEquality = spark.sessionState().analyzer().resolver();
        return condition.references().forall((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)partitionColumns.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.$anonfun$isPredicatePartitionColumnsOnly$2(nameEquality$1, r, x$4)))));
    }

    public Tuple2<Seq<Expression>, Seq<Expression>> splitMetadataAndDataPredicates(Expression condition2, Seq<String> partitionColumns, SparkSession spark) {
        Tuple2 tuple2 = this.splitConjunctivePredicates(condition2).partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.MODULE$.isPredicateMetadataOnly(x$5, (Seq<String>)partitionColumns, spark)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq metadataPredicates = (Seq)tuple2._1();
        Seq dataPredicates = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metadataPredicates, (Object)dataPredicates);
        Tuple2 tuple23 = tuple22;
        Seq metadataPredicates2 = (Seq)tuple23._1();
        Seq dataPredicates2 = (Seq)tuple23._2();
        Seq extraMetadataPredicates = dataPredicates2.nonEmpty() ? (Seq)this.extractMetadataPredicates((Expression)dataPredicates2.reduce((Function2)And$.MODULE$), partitionColumns, spark).map((Function1 & Serializable & scala.Serializable)condition -> MODULE$.splitConjunctivePredicates((Expression)condition)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$) : (Seq)Nil$.MODULE$;
        return new Tuple2(metadataPredicates2.$plus$plus((GenTraversableOnce)extraMetadataPredicates, Seq$.MODULE$.canBuildFrom()), (Object)dataPredicates2);
    }

    private Option<Expression> extractMetadataPredicates(Expression condition, Seq<String> partitionColumns, SparkSession spark) {
        None$ none$;
        Expression expression = condition;
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            Option<Expression> lhs2 = this.extractMetadataPredicates(left, partitionColumns, spark);
            Option<Expression> rhs = this.extractMetadataPredicates(right, partitionColumns, spark);
            none$ = ((TraversableOnce)Option$.MODULE$.option2Iterable(lhs2).toSeq().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(rhs).toSeq(), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2)And$.MODULE$);
        } else if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            none$ = this.extractMetadataPredicates(left, partitionColumns, spark).flatMap((Function1 & Serializable & scala.Serializable)lhs -> MODULE$.extractMetadataPredicates(right, partitionColumns, spark).map((Function1 & Serializable & scala.Serializable)rhs -> new Or(lhs, rhs)));
        } else {
            none$ = this.isPredicatePartitionColumnsOnly(expression, partitionColumns, spark) ? new Some((Object)expression) : None$.MODULE$;
        }
        return none$;
    }

    public boolean containsSubquery(Expression condition) {
        return SubqueryExpression$.MODULE$.hasSubquery(condition);
    }

    public boolean isPredicateMetadataOnly(Expression condition, Seq<String> partitionColumns, SparkSession spark) {
        return this.isPredicatePartitionColumnsOnly(condition, partitionColumns, spark) && !this.containsSubquery(condition);
    }

    public LogicalPlan replaceFileIndex(LogicalPlan target, FileIndex fileIndex) {
        return (LogicalPlan)target.transform((PartialFunction)new scala.Serializable(fileIndex){
            public static final long serialVersionUID = 0L;
            private final FileIndex fileIndex$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                LogicalRelation logicalRelation;
                BaseRelation hfsr;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && (hfsr = (logicalRelation = (LogicalRelation)A1).relation()) instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)hfsr;
                    object = logicalRelation.copy((BaseRelation)hadoopFsRelation.copy(this.fileIndex$1, hadoopFsRelation.copy$default$2(), hadoopFsRelation.copy$default$3(), hadoopFsRelation.copy$default$4(), hadoopFsRelation.copy$default$5(), hadoopFsRelation.copy$default$6(), hadoopFsRelation.sparkSession()), logicalRelation.copy$default$2(), logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalRelation logicalRelation;
                BaseRelation hfsr;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof LogicalRelation && (hfsr = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof HadoopFsRelation;
                return bl;
            }
            {
                this.fileIndex$1 = fileIndex$1;
            }
        });
    }

    public LogicalPlan replaceFileFormat(LogicalPlan target, FileFormat updatedFileFormat) {
        return (LogicalPlan)target.transform((PartialFunction)new scala.Serializable(updatedFileFormat){
            public static final long serialVersionUID = 0L;
            private final FileFormat updatedFileFormat$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                LogicalRelation logicalRelation;
                BaseRelation hfsr;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && (hfsr = (logicalRelation = (LogicalRelation)A1).relation()) instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)hfsr;
                    FileFormat x$1 = this.updatedFileFormat$1;
                    FileIndex x$2 = hadoopFsRelation.copy$default$1();
                    StructType x$3 = hadoopFsRelation.copy$default$2();
                    StructType x$4 = hadoopFsRelation.copy$default$3();
                    Option x$5 = hadoopFsRelation.copy$default$4();
                    Map x$6 = hadoopFsRelation.copy$default$6();
                    SparkSession x$7 = hadoopFsRelation.sparkSession();
                    object = logicalRelation.copy((BaseRelation)hadoopFsRelation.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7), logicalRelation.copy$default$2(), logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalRelation logicalRelation;
                BaseRelation hfsr;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof LogicalRelation && (hfsr = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof HadoopFsRelation;
                return bl;
            }
            {
                this.updatedFileFormat$1 = updatedFileFormat$1;
            }
        });
    }

    public Tuple2<String, Option<DeltaTimeTravelSpec>> extractIfPathContainsTimeTravel(SparkSession session, String path, Map<String, String> options) {
        SQLConf conf = session.sessionState().conf();
        if (!DeltaTimeTravelSpec$.MODULE$.isApplicable(conf, path)) {
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)None$.MODULE$);
        }
        Path maybePath = new Path(path);
        FileSystem fs = maybePath.getFileSystem(session.sessionState().newHadoopConfWithOptions(options));
        if (fs.exists(maybePath)) {
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)None$.MODULE$);
        }
        Tuple2<DeltaTimeTravelSpec, String> tuple2 = DeltaTimeTravelSpec$.MODULE$.resolvePath(conf, path);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DeltaTimeTravelSpec tt = (DeltaTimeTravelSpec)tuple2._1();
        String realPath = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tt, (Object)realPath);
        Tuple2 tuple23 = tuple22;
        DeltaTimeTravelSpec tt2 = (DeltaTimeTravelSpec)tuple23._1();
        String realPath2 = (String)tuple23._2();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)realPath2), (Object)new Some((Object)tt2));
    }

    public Tuple2<Object, String> resolveTimeTravelVersion(SQLConf conf, DeltaLog deltaLog, DeltaTimeTravelSpec tt, boolean canReturnLastCommit) {
        Tuple2 tuple2;
        if (tt.version().isDefined()) {
            long userVersion = BoxesRunTime.unboxToLong((Object)tt.version().get());
            deltaLog.history().checkVersionExists(userVersion, deltaLog.history().checkVersionExists$default$2(), deltaLog.history().checkVersionExists$default$3());
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)userVersion)), (Object)"version");
        } else {
            Timestamp timestamp = tt.getTimestamp(conf);
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)deltaLog.history().getActiveCommitAtTime(timestamp, canReturnLastCommit, deltaLog.history().getActiveCommitAtTime$default$3(), deltaLog.history().getActiveCommitAtTime$default$4()).version())), (Object)"timestamp");
        }
        return tuple2;
    }

    public boolean resolveTimeTravelVersion$default$4() {
        return false;
    }

    public IdentityTransform parseColToTransform(String col) {
        return new IdentityTransform((NamedReference)new FieldReference((Seq)new .colon.colon((Object)col, (List)Nil$.MODULE$)));
    }

    private static final boolean databaseExists$1(TableIdentifier ident$1, SessionCatalog catalog$2) {
        return ident$1.database().forall((Function1 & Serializable & scala.Serializable)db -> BoxesRunTime.boxToBoolean((boolean)catalog$2.databaseExists(db)));
    }

    public static final /* synthetic */ boolean $anonfun$isPredicatePartitionColumnsOnly$2(Function2 nameEquality$1, Attribute r$1, String x$4) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$1.apply((Object)r$1.name(), (Object)x$4));
    }

    private DeltaTableUtils$() {
        MODULE$ = this;
        AliasHelper.$init$((AliasHelper)this);
        Logging.$init$((Logging)this);
        PredicateHelper.$init$((PredicateHelper)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.validDeltaTableHadoopPrefixes = new .colon.colon((Object)"fs.", (List)new .colon.colon((Object)"dfs.", (List)Nil$.MODULE$));
    }
}

