/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.commands.CloneSource;
import org.apache.spark.sql.delta.commands.CloneTableBase;
import org.apache.spark.sql.delta.commands.CloneTableCommand$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%c\u0001B\u001d;\u0001\u001eC\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005/\"A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005d\u0001\tE\t\u0015!\u0003^\u0011!!\u0007A!f\u0001\n\u0003)\u0007\u0002\u0003;\u0001\u0005#\u0005\u000b\u0011\u00024\t\u0011U\u0004!Q3A\u0005\u0002YD\u0001b \u0001\u0003\u0012\u0003\u0006Ia\u001e\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\ty\u0001\u0001C)\u0003#Aq!!\u000f\u0001\t\u0003\nY\u0004C\u0005\u0002H\u0001\t\t\u0011\"\u0001\u0002J!I\u00111\u000b\u0001\u0012\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003W\u0002\u0011\u0013!C\u0001\u0003[B\u0011\"!\u001d\u0001#\u0003%\t!a\u001d\t\u0013\u0005]\u0004!%A\u0005\u0002\u0005e\u0004\"CA?\u0001\u0005\u0005I\u0011IA@\u0011%\ty\tAA\u0001\n\u0003\t\t\nC\u0005\u0002\u001a\u0002\t\t\u0011\"\u0001\u0002\u001c\"I\u0011q\u0015\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0016\u0005\n\u0003o\u0003\u0011\u0011!C\u0001\u0003sC\u0011\"a1\u0001\u0003\u0003%\t%!2\b\u000f\u0005%'\b#\u0001\u0002L\u001a1\u0011H\u000fE\u0001\u0003\u001bDq!!\u0001\u0019\t\u0003\t)\u000eC\u0005\u0002Xb\u0011\r\u0011\"\u0001\u0002\u0000!A\u0011\u0011\u001c\r!\u0002\u0013\t\t\tC\u0005\u0002\\b\u0011\r\u0011\"\u0001\u0002\u0000!A\u0011Q\u001c\r!\u0002\u0013\t\t\tC\u0005\u0002`b\u0011\r\u0011\"\u0001\u0002\u0000!A\u0011\u0011\u001d\r!\u0002\u0013\t\t\tC\u0005\u0002db\u0011\r\u0011\"\u0001\u0002\u0000!A\u0011Q\u001d\r!\u0002\u0013\t\t\tC\u0005\u0002hb\u0011\r\u0011\"\u0001\u0002\u0000!A\u0011\u0011\u001e\r!\u0002\u0013\t\t\tC\u0005\u0002lb\u0011\r\u0011\"\u0001\u0002\u0000!A\u0011Q\u001e\r!\u0002\u0013\t\t\tC\u0005\u0002pb\u0011\r\u0011\"\u0001\u0002\u0000!A\u0011\u0011\u001f\r!\u0002\u0013\t\t\tC\u0005\u0002tb\u0011\r\u0011\"\u0003\u0002\u0000!A\u0011Q\u001f\r!\u0002\u0013\t\t\tC\u0005\u0002xb\u0011\r\u0011\"\u0003\u0002\u0000!A\u0011\u0011 \r!\u0002\u0013\t\t\tC\u0005\u0002|b\u0011\r\u0011\"\u0003\u0002\u0000!A\u0011Q \r!\u0002\u0013\t\t\tC\u0005\u0002\u0000b\u0011\r\u0011\"\u0003\u0002\u0000!A!\u0011\u0001\r!\u0002\u0013\t\t\tC\u0005\u0003\u0004a\u0011\r\u0011\"\u0003\u0002\u0000!A!Q\u0001\r!\u0002\u0013\t\t\tC\u0005\u0003\ba\u0011\r\u0011\"\u0003\u0002\u0000!A!\u0011\u0002\r!\u0002\u0013\t\t\tC\u0005\u0003\fa\u0011\r\u0011\"\u0001\u0003\u000e!A!Q\u0004\r!\u0002\u0013\u0011y\u0001C\u0005\u0003 a\t\t\u0011\"!\u0003\"!I!1\u0006\r\u0002\u0002\u0013\u0005%Q\u0006\u0005\n\u0005\u007fA\u0012\u0011!C\u0005\u0005\u0003\u0012\u0011c\u00117p]\u0016$\u0016M\u00197f\u0007>lW.\u00198e\u0015\tYD(\u0001\u0005d_6l\u0017M\u001c3t\u0015\tid(A\u0003eK2$\u0018M\u0003\u0002@\u0001\u0006\u00191/\u001d7\u000b\u0005\u0005\u0013\u0015!B:qCJ\\'BA\"E\u0003\u0019\t\u0007/Y2iK*\tQ)A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u00112\u0013\u0006CA%K\u001b\u0005Q\u0014BA&;\u00059\u0019En\u001c8f)\u0006\u0014G.\u001a\"bg\u0016\u0004\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002N'&\u0011AK\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\fg>,(oY3UC\ndW-F\u0001X!\tI\u0005,\u0003\u0002Zu\tY1\t\\8oKN{WO]2f\u00031\u0019x.\u001e:dKR\u000b'\r\\3!\u0003-!\u0018M]4fi&#WM\u001c;\u0016\u0003u\u0003\"AX1\u000e\u0003}S!\u0001\u0019 \u0002\u0011\r\fG/\u00197zgRL!AY0\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\fA\u0002^1sO\u0016$\u0018\nZ3oi\u0002\na\u0003^1cY\u0016\u0004&o\u001c9feRLxJ^3se&$Wm]\u000b\u0002MB!qM\\9r\u001d\tAG\u000e\u0005\u0002j\u001d6\t!N\u0003\u0002l\r\u00061AH]8pizJ!!\u001c(\u0002\rA\u0013X\rZ3g\u0013\ty\u0007OA\u0002NCBT!!\u001c(\u0011\u0005\u001d\u0014\u0018BA:q\u0005\u0019\u0019FO]5oO\u00069B/\u00192mKB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000fI\u0001\u000bi\u0006\u0014x-\u001a;QCRDW#A<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018A\u00014t\u0015\ta()\u0001\u0004iC\u0012|w\u000e]\u0005\u0003}f\u0014A\u0001U1uQ\u0006YA/\u0019:hKR\u0004\u0016\r\u001e5!\u0003\u0019a\u0014N\\5u}QQ\u0011QAA\u0004\u0003\u0013\tY!!\u0004\u0011\u0005%\u0003\u0001\"B+\n\u0001\u00049\u0006\"B.\n\u0001\u0004i\u0006\"\u00023\n\u0001\u00041\u0007\"B;\n\u0001\u00049\u0018\u0001D4fi>+H\u000f];u'\u0016\fH\u0003BA\n\u0003[\u0001b!!\u0006\u0002 \u0005\u0015b\u0002BA\f\u00037q1![A\r\u0013\u0005y\u0015bAA\u000f\u001d\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0011\u0003G\u00111aU3r\u0015\r\tiB\u0014\t\u0005\u0003O\tI#D\u0001?\u0013\r\tYC\u0010\u0002\u0004%><\bbBA\u0018\u0015\u0001\u0007\u0011\u0011G\u0001\u0011_B,'/\u0019;j_:lU\r\u001e:jGN\u0004Ra\u001a8r\u0003g\u00012!TA\u001b\u0013\r\t9D\u0014\u0002\u0005\u0019>tw-A\u0002sk:$B!a\u0005\u0002>!9\u0011qH\u0006A\u0002\u0005\u0005\u0013\u0001D:qCJ\\7+Z:tS>t\u0007\u0003BA\u0014\u0003\u0007J1!!\u0012?\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005\u0015\u00111JA'\u0003\u001f\n\t\u0006C\u0004V\u0019A\u0005\t\u0019A,\t\u000fmc\u0001\u0013!a\u0001;\"9A\r\u0004I\u0001\u0002\u00041\u0007bB;\r!\u0003\u0005\ra^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9FK\u0002X\u00033Z#!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Kr\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011NA0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyGK\u0002^\u00033\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002v)\u001aa-!\u0017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0010\u0016\u0004o\u0006e\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0002B!\u00111QAG\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015\u0001\u00027b]\u001eT!!a#\u0002\t)\fg/Y\u0005\u0004g\u0006\u0015\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAJ!\ri\u0015QS\u0005\u0004\u0003/s%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAO\u0003G\u00032!TAP\u0013\r\t\tK\u0014\u0002\u0004\u0003:L\b\"CAS'\u0005\u0005\t\u0019AAJ\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0016\t\u0007\u0003[\u000b\u0019,!(\u000e\u0005\u0005=&bAAY\u001d\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0016q\u0016\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002<\u0006\u0005\u0007cA'\u0002>&\u0019\u0011q\u0018(\u0003\u000f\t{w\u000e\\3b]\"I\u0011QU\u000b\u0002\u0002\u0003\u0007\u0011QT\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m\u0016q\u0019\u0005\n\u0003K3\u0012\u0011!a\u0001\u0003;\u000b\u0011c\u00117p]\u0016$\u0016M\u00197f\u0007>lW.\u00198e!\tI\u0005d\u0005\u0003\u0019\u0003\u001f\u0014\u0006cA'\u0002R&\u0019\u00111\u001b(\u0003\r\u0005s\u0017PU3g)\t\tY-A\tT\u001fV\u00136)R0U\u0003\ncUiX*J5\u0016\u000b!cU(V%\u000e+u\fV!C\u0019\u0016{6+\u0013.FA\u0005\u00192kT+S\u0007\u0016{f*V'`\u001f\u001a{f)\u0013'F'\u0006!2kT+S\u0007\u0016{f*V'`\u001f\u001a{f)\u0013'F'\u0002\n\u0011CT+N?J+Uj\u0014,F\t~3\u0015\nT#T\u0003IqU+T0S\u000b6{e+\u0012#`\r&cUi\u0015\u0011\u0002!9+VjX\"P!&+Ei\u0018$J\u0019\u0016\u001b\u0016!\u0005(V\u001b~\u001bu\nU%F\t~3\u0015\nT#TA\u0005\u0011\"+R'P-\u0016#uLR%M\u000bN{6+\u0013.F\u0003M\u0011V)T(W\u000b\u0012{f)\u0013'F'~\u001b\u0016JW#!\u0003E\u0019u\nU%F\t~3\u0015\nT#T?NK%,R\u0001\u0013\u0007>\u0003\u0016*\u0012#`\r&cUiU0T\u0013j+\u0005%A\u0004P!~s\u0015)T#\u0002\u0011=\u0003vLT!N\u000b\u0002\n\u0001dQ(M+6sulU(V%\u000e+u\fV!C\u0019\u0016{6+\u0013.F\u0003e\u0019u\nT+N\u001d~\u001bv*\u0016*D\u000b~#\u0016I\u0011'F?NK%,\u0012\u0011\u00025\r{E*V'O?N{UKU\"F?:+VjX(G?\u001aKE*R*\u00027\r{E*V'O?N{UKU\"F?:+VjX(G?\u001aKE*R*!\u0003a\u0019u\nT+N\u001d~sU+T0S\u000b6{e+\u0012#`\r&cUiU\u0001\u001a\u0007>cU+\u0014(`\u001dVkuLU#N\u001fZ+Ei\u0018$J\u0019\u0016\u001b\u0006%A\fD\u001f2+VJT0O+6{6i\u0014)J\u000b\u0012{f)\u0013'F'\u0006A2i\u0014'V\u001b:{f*V'`\u0007>\u0003\u0016*\u0012#`\r&cUi\u0015\u0011\u00023\r{E*V'O?J+Uj\u0014,F\t~3\u0015\nT#T?NK%,R\u0001\u001b\u0007>cU+\u0014(`%\u0016kuJV#E?\u001aKE*R*`'&SV\tI\u0001\u0019\u0007>cU+\u0014(`\u0007>\u0003\u0016*\u0012#`\r&cUiU0T\u0013j+\u0015!G\"P\u0019VkejX\"P!&+Ei\u0018$J\u0019\u0016\u001bvlU%[\u000b\u0002\naa\\;uaV$XC\u0001B\b!\u0019\t)\"a\b\u0003\u0012A!!1\u0003B\r\u001b\t\u0011)BC\u0002\u0003\u0018}\u000b1\"\u001a=qe\u0016\u001c8/[8og&!!1\u0004B\u000b\u0005%\tE\u000f\u001e:jEV$X-A\u0004pkR\u0004X\u000f\u001e\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\u0005\u0015!1\u0005B\u0013\u0005O\u0011I\u0003C\u0003Vm\u0001\u0007q\u000bC\u0003\\m\u0001\u0007Q\fC\u0003em\u0001\u0007a\rC\u0003vm\u0001\u0007q/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t=\"1\b\t\u0006\u001b\nE\"QG\u0005\u0004\u0005gq%AB(qi&|g\u000eE\u0004N\u0005o9VLZ<\n\u0007\tebJ\u0001\u0004UkBdW\r\u000e\u0005\n\u0005{9\u0014\u0011!a\u0001\u0003\u000b\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0003\u0003BAB\u0005\u000bJAAa\u0012\u0002\u0006\n1qJ\u00196fGR\u0004")
public class CloneTableCommand
extends CloneTableBase
implements scala.Serializable {
    private final CloneSource sourceTable;
    private final TableIdentifier targetIdent;
    private final Map<String, String> tablePropertyOverrides;
    private final Path targetPath;

    public static Option<Tuple4<CloneSource, TableIdentifier, Map<String, String>, Path>> unapply(CloneTableCommand cloneTableCommand) {
        return CloneTableCommand$.MODULE$.unapply(cloneTableCommand);
    }

    public static String OP_NAME() {
        return CloneTableCommand$.MODULE$.OP_NAME();
    }

    public static String COPIED_FILES_SIZE() {
        return CloneTableCommand$.MODULE$.COPIED_FILES_SIZE();
    }

    public static String REMOVED_FILES_SIZE() {
        return CloneTableCommand$.MODULE$.REMOVED_FILES_SIZE();
    }

    public static String NUM_COPIED_FILES() {
        return CloneTableCommand$.MODULE$.NUM_COPIED_FILES();
    }

    public static String NUM_REMOVED_FILES() {
        return CloneTableCommand$.MODULE$.NUM_REMOVED_FILES();
    }

    public static String SOURCE_NUM_OF_FILES() {
        return CloneTableCommand$.MODULE$.SOURCE_NUM_OF_FILES();
    }

    public static String SOURCE_TABLE_SIZE() {
        return CloneTableCommand$.MODULE$.SOURCE_TABLE_SIZE();
    }

    public CloneSource sourceTable() {
        return this.sourceTable;
    }

    public TableIdentifier targetIdent() {
        return this.targetIdent;
    }

    public Map<String, String> tablePropertyOverrides() {
        return this.tablePropertyOverrides;
    }

    public Path targetPath() {
        return this.targetPath;
    }

    @Override
    public Seq<Row> getOutputSeq(Map<String, Object> operationMetrics) {
        return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operationMetrics.get((Object)CloneTableCommand$.MODULE$.SOURCE_TABLE_SIZE()), operationMetrics.get((Object)CloneTableCommand$.MODULE$.SOURCE_NUM_OF_FILES()), operationMetrics.get((Object)CloneTableCommand$.MODULE$.NUM_REMOVED_FILES()), operationMetrics.get((Object)CloneTableCommand$.MODULE$.NUM_COPIED_FILES()), operationMetrics.get((Object)CloneTableCommand$.MODULE$.REMOVED_FILES_SIZE()), operationMetrics.get((Object)CloneTableCommand$.MODULE$.COPIED_FILES_SIZE())})), (List)Nil$.MODULE$);
    }

    public Seq<Row> run(SparkSession sparkSession) {
        Object object;
        if (!this.targetPath().isAbsolute()) {
            throw DeltaErrors$.MODULE$.cloneOnRelativePath(this.targetIdent().toString());
        }
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Cloning ").append(this.sourceTable().description()).append(" to ").append(this.targetPath()).toString());
        Configuration hdpConf = sparkSession.sessionState().newHadoopConf();
        if (!BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CLONE_REPLACE_ENABLED()))) {
            FileSystem targetFs = this.targetPath().getFileSystem(hdpConf);
            try {
                FileStatus[] subFiles = targetFs.listStatus(this.targetPath());
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subFiles)).nonEmpty()) {
                    throw DeltaErrors$.MODULE$.cloneReplaceUnsupported(this.targetIdent());
                }
                object = BoxedUnit.UNIT;
            }
            catch (FileNotFoundException fileNotFoundException) {
                object = BoxesRunTime.boxToBoolean((boolean)targetFs.mkdirs(this.targetPath()));
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return this.runInternal(sparkSession, CloneTableCommand$.MODULE$.OP_NAME(), hdpConf, new DeltaOperations.Clone(this.sourceTable().name(), BoxesRunTime.unboxToLong((Object)this.sourceTable().snapshot().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.version())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))), (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public CloneTableCommand copy(CloneSource sourceTable, TableIdentifier targetIdent, Map<String, String> tablePropertyOverrides, Path targetPath) {
        return new CloneTableCommand(sourceTable, targetIdent, tablePropertyOverrides, targetPath);
    }

    public CloneSource copy$default$1() {
        return this.sourceTable();
    }

    public TableIdentifier copy$default$2() {
        return this.targetIdent();
    }

    public Map<String, String> copy$default$3() {
        return this.tablePropertyOverrides();
    }

    public Path copy$default$4() {
        return this.targetPath();
    }

    public String productPrefix() {
        return "CloneTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Path path;
        int n = x$1;
        switch (n) {
            case 0: {
                path = this.sourceTable();
                break;
            }
            case 1: {
                path = this.targetIdent();
                break;
            }
            case 2: {
                path = this.tablePropertyOverrides();
                break;
            }
            case 3: {
                path = this.targetPath();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return path;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CloneTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CloneTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CloneTableCommand cloneTableCommand = (CloneTableCommand)x$1;
        CloneSource cloneSource = this.sourceTable();
        CloneSource cloneSource2 = cloneTableCommand.sourceTable();
        if (cloneSource == null) {
            if (cloneSource2 != null) {
                return false;
            }
        } else if (!cloneSource.equals(cloneSource2)) return false;
        TableIdentifier tableIdentifier = this.targetIdent();
        TableIdentifier tableIdentifier2 = cloneTableCommand.targetIdent();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Map<String, String> map = this.tablePropertyOverrides();
        Map<String, String> map2 = cloneTableCommand.tablePropertyOverrides();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Path path = this.targetPath();
        Path path2 = cloneTableCommand.targetPath();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        if (!cloneTableCommand.canEqual(this)) return false;
        return true;
    }

    public CloneTableCommand(CloneSource sourceTable, TableIdentifier targetIdent, Map<String, String> tablePropertyOverrides, Path targetPath) {
        this.sourceTable = sourceTable;
        this.targetIdent = targetIdent;
        this.tablePropertyOverrides = tablePropertyOverrides;
        this.targetPath = targetPath;
        super(sourceTable, tablePropertyOverrides, targetPath);
    }
}

