/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CompositeMapView;
import org.apache.kylin.guava30.shaded.common.collect.Maps;

public class KylinConfigExt
extends KylinConfig {
    private final Map<String, String> overrides;
    final KylinConfig base;
    private final transient StrSubstitutor strSubstitutor;

    public static KylinConfigExt createInstance(KylinConfig kylinConfig, Map<String, String> overrides) {
        if (kylinConfig instanceof KylinConfigExt) {
            return new KylinConfigExt((KylinConfigExt)kylinConfig, overrides);
        }
        return new KylinConfigExt(kylinConfig, overrides);
    }

    private KylinConfigExt(KylinConfig base, Map<String, String> overrides) {
        super(base.getRawAllProperties(), true);
        if (base.getClass() != KylinConfig.class) {
            throw new IllegalArgumentException();
        }
        this.base = base;
        this.overrides = BCC.check(overrides);
        this.strSubstitutor = new StrSubstitutor(new CompositeMapView(this.properties, STATIC_SYSTEM_ENV, this.overrides));
    }

    private KylinConfigExt(KylinConfigExt ext, Map<String, String> overrides) {
        this(ext.base, overrides);
    }

    @Override
    public String getOptional(String prop, String dft) {
        String value = this.overrides.get(prop);
        if (value != null) {
            return this.getSubstitutor().replace(value);
        }
        return super.getOptional(prop, dft);
    }

    @Override
    protected Properties getAllProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)super.getAllProperties());
        result.putAll(this.overrides);
        return result;
    }

    @Override
    public Map<String, String> getReadonlyProperties() {
        HashMap config = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.overrides.entrySet()) {
            config.put(entry.getKey(), this.strSubstitutor.replace(entry.getValue()));
        }
        return config;
    }

    @Override
    protected StrSubstitutor getSubstitutor() {
        return this.strSubstitutor;
    }

    public Map<String, String> getExtendedOverrides() {
        return this.overrides;
    }

    @Override
    public KylinConfig base() {
        return this.base;
    }
}

