/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.exception;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.util.FileUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionResolve
implements Serializable {
    public static final Logger logger = LoggerFactory.getLogger(ExceptionResolve.class);
    private static final String EN_EXCEPTION_RESOLVE_FILE = "job_exception_resolve_en.properties";
    private static final String ZH_EXCEPTION_RESOLVE_FILE = "job_exception_resolve_zh.properties";
    private static final ImmutableMap<String, String> enMap;
    private static final ImmutableMap<String, String> zhMap;
    private static final ThreadLocal<ImmutableMap<String, String>> frontMap;
    private final String keCode;

    public ExceptionResolve(String keCode) {
        this.keCode = keCode;
    }

    public static void setLang(String lang) {
        if ("cn".equals(lang)) {
            frontMap.set(zhMap);
        } else {
            frontMap.set(enMap);
        }
    }

    private static ImmutableMap<String, String> getMap() {
        ImmutableMap<String, String> res = frontMap.get();
        return res == null ? enMap : res;
    }

    public static String getResolve(String keCode) {
        ImmutableMap<String, String> res = ExceptionResolve.getMap();
        return (String)res.getOrDefault((Object)keCode, (Object)"unknown");
    }

    public String getResolve() {
        ImmutableMap<String, String> res = ExceptionResolve.getMap();
        return (String)res.getOrDefault((Object)this.keCode, (Object)"unknown");
    }

    public String getCodeString() {
        return this.keCode;
    }

    static {
        frontMap = new ThreadLocal();
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(EN_EXCEPTION_RESOLVE_FILE);
            Preconditions.checkNotNull((Object)resource);
            logger.info("loading resolve enMap {}", (Object)resource.getPath());
            enMap = ImmutableMap.copyOf(new ConcurrentHashMap<String, String>(FileUtils.readFromPropertiesFile(resource.openStream())));
            logger.info("loading resolve enMap successful");
            resource = Thread.currentThread().getContextClassLoader().getResource(ZH_EXCEPTION_RESOLVE_FILE);
            Preconditions.checkNotNull((Object)resource);
            logger.info("loading resolve zhMap {}", (Object)resource.getPath());
            zhMap = ImmutableMap.copyOf(new ConcurrentHashMap<String, String>(FileUtils.readFromPropertiesFile(resource.openStream())));
            logger.info("loading resolve zhMap successful");
            frontMap.set(enMap);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

