/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.metadata.PersistException;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class JdbcUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcUtil.class);
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtil.class);
    private static final ThreadLocal txThreadLocal = new ThreadLocal();

    public static <T> T withTxAndRetry(DataSourceTransactionManager transactionManager, Callback<T> consumer) {
        return JdbcUtil.withTxAndRetry(transactionManager, consumer, 4, 3);
    }

    public static <T> T withTxAndRetry(DataSourceTransactionManager transactionManager, Callback<T> consumer, int retryLimit) {
        return JdbcUtil.withTxAndRetry(transactionManager, consumer, 4, retryLimit);
    }

    public static boolean isInExistingTx() {
        return txThreadLocal.get() != null;
    }

    public static <T> T withTxAndRetry(DataSourceTransactionManager transactionManager, Callback<T> consumer, int isolationLevel, int retryLimit) {
        boolean inExistingTx = false;
        int retryCount = 0;
        try {
            inExistingTx = JdbcUtil.isInExistingTx();
            if (!inExistingTx) {
                txThreadLocal.set(new Object());
            }
            while (true) {
                T t;
                try {
                    t = JdbcUtil.withTransaction(transactionManager, consumer, isolationLevel);
                }
                catch (RuntimeException runtimeException) {
                    String exceptionClassName = runtimeException.getClass().getName();
                    String message = runtimeException.getMessage();
                    if (inExistingTx) {
                        logger.warn("failed on = {}, message = {}, and inExistingTx, will throw", (Object)exceptionClassName, (Object)message);
                        throw runtimeException;
                    }
                    if (retryCount++ < retryLimit) {
                        logger.warn("failed on = {}, message = {}, retryCount = {}, will retry", new Object[]{exceptionClassName, message, retryCount - 1});
                        continue;
                    }
                    logger.warn("failed on = {}, message = {}, and touch retry-limit, will throw", (Object)exceptionClassName, (Object)message);
                    throw runtimeException;
                }
                return t;
            }
        }
        finally {
            if (!inExistingTx) {
                txThreadLocal.remove();
            }
        }
    }

    public static <T> T withTransactionTimeout(DataSourceTransactionManager transactionManager, Callback<T> consumer, int timeout) {
        return JdbcUtil.withTransaction(transactionManager, consumer, 4, null, timeout);
    }

    public static <T> T withTransaction(DataSourceTransactionManager transactionManager, Callback<T> consumer) {
        return JdbcUtil.withTransaction(transactionManager, consumer, 4);
    }

    public static <T> T withTransaction(DataSourceTransactionManager transactionManager, Callback<T> consumer, int isolationLevel) {
        return JdbcUtil.withTransaction(transactionManager, consumer, isolationLevel, null, -1);
    }

    public static <T> T withTransaction(DataSourceTransactionManager transactionManager, Callback<T> consumer, int isolationLevel, Callback<T> beforeCommit, int timeout) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setIsolationLevel(isolationLevel);
        definition.setTimeout(timeout);
        TransactionStatus status = transactionManager.getTransaction((TransactionDefinition)definition);
        try {
            T result = consumer.handle();
            if (beforeCommit != null) {
                beforeCommit.handle();
            }
            transactionManager.commit(status);
            return result;
        }
        catch (Exception e) {
            transactionManager.rollback(status);
            if (e instanceof DataIntegrityViolationException) {
                consumer.onError();
            }
            if (Objects.nonNull(e.getMessage()) && e.getMessage().contains("max_allowed_packet")) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EXCEED_MAX_ALLOWED_PACKET, MsgPicker.getMsg().getExceedMaxAllowedPacket());
            }
            throw new PersistException("persist messages failed", e);
        }
    }

    public static boolean isTableExists(Connection conn, String table) throws SQLException {
        return JdbcUtil.isAnyTableExists(conn, true, table, table.toUpperCase(Locale.ROOT), table.toLowerCase(Locale.ROOT));
    }

    public static boolean isTableExists(Connection conn, String table, boolean autoReleaseConnection) throws SQLException {
        return JdbcUtil.isAnyTableExists(conn, autoReleaseConnection, table, table.toUpperCase(Locale.ROOT), table.toLowerCase(Locale.ROOT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAnyTableExists(Connection conn, boolean autoReleaseConnection, String ... tables) throws SQLException {
        try {
            for (String table : tables) {
                ResultSet resultSet = conn.getMetaData().getTables(conn.getCatalog(), null, table, null);
                if (!resultSet.next()) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("Fail to know if table {} exists", (Object)tables, (Object)e);
        }
        finally {
            if (!conn.isClosed() && autoReleaseConnection) {
                conn.close();
            }
        }
        return false;
    }

    public static boolean isPrimaryKeyExists(Connection conn, String table) throws SQLException {
        return JdbcUtil.isPrimaryKeyExists(conn, table, table.toUpperCase(Locale.ROOT), table.toLowerCase(Locale.ROOT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPrimaryKeyExists(Connection conn, String ... tables) throws SQLException {
        try {
            for (String table : tables) {
                try {
                    ResultSet resultSet = conn.getMetaData().getPrimaryKeys(conn.getCatalog(), conn.getSchema(), table);
                    if (!resultSet.next()) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    logger.warn("get primary key from table {} failed", (Object)table, (Object)e);
                }
            }
        }
        finally {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        return false;
    }

    public static boolean isIndexExists(Connection conn, String table, String index) throws SQLException {
        return JdbcUtil.isIndexExists(conn, index, true, table, table.toUpperCase(Locale.ROOT), table.toLowerCase(Locale.ROOT));
    }

    public static boolean isIndexExists(Connection conn, String table, String index, boolean autoReleaseConnection) throws SQLException {
        return JdbcUtil.isIndexExists(conn, index, autoReleaseConnection, table, table.toUpperCase(Locale.ROOT), table.toLowerCase(Locale.ROOT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isIndexExists(Connection conn, String index, boolean autoReleaseConnection, String ... tables) throws SQLException {
        try {
            for (String table : tables) {
                ResultSet resultSet = conn.getMetaData().getIndexInfo(null, null, table, false, false);
                while (resultSet.next()) {
                    String indexName = resultSet.getString("INDEX_NAME");
                    if (!Objects.equals(indexName, index)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            logger.error("Fail to know if table {} index {} exists", new Object[]{tables, index, e});
        }
        finally {
            if (!conn.isClosed() && autoReleaseConnection) {
                conn.close();
            }
        }
        return false;
    }

    public static boolean isColumnExists(Connection conn, String table, String column) throws SQLException {
        return JdbcUtil.isColumnExists(conn, column, table, table.toUpperCase(Locale.ROOT), table.toLowerCase(Locale.ROOT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isColumnExists(Connection conn, String column, String ... tables) throws SQLException {
        try {
            for (String table : tables) {
                ResultSet resultSet = conn.getMetaData().getColumns(null, null, table, null);
                while (resultSet.next()) {
                    String columnName = resultSet.getString("COLUMN_NAME");
                    if (!StringUtils.equalsIgnoreCase((CharSequence)columnName, (CharSequence)column)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            logger.error("Fail to know if table {} column {} exists", new Object[]{tables, column, e});
        }
        finally {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        return false;
    }

    public static Properties datasourceParameters(StorageURL url) {
        return KylinConfig.getInstanceFromEnv().isUTEnv() ? JdbcUtil.datasourceParametersForUT(url) : JdbcUtil.datasourceParametersForProd(url);
    }

    public static Properties datasourceParametersForProd(StorageURL url) {
        Properties props = new Properties();
        props.put("driverClassName", "org.postgresql.Driver");
        props.put("url", "jdbc:postgresql://sandbox:5432/kylin");
        props.put("username", "postgres");
        props.put("maxTotal", "50");
        props.putAll(url.getAllParameters());
        String password = props.getProperty("password", "");
        if (EncryptUtil.isEncrypted(password)) {
            password = EncryptUtil.decryptPassInKylin(password);
        }
        props.put("password", password);
        return props;
    }

    public static Properties datasourceParametersForUT(StorageURL url) {
        Properties props = new Properties();
        props.put("driverClassName", "org.h2.Driver");
        props.put("url", "jdbc:h2:mem:db_default;DB_CLOSE_DELAY=-1;MODE=MySQL;DEFAULT_LOCK_TIMEOUT=10000");
        props.put("username", "sa");
        props.put("password", "");
        props.put("maxTotal", "50");
        props.putAll(url.getAllParameters());
        return props;
    }

    public static Properties getProperties(BasicDataSource dataSource) throws IOException {
        String fileName;
        switch (dataSource.getDriverClassName()) {
            case "org.postgresql.Driver": {
                fileName = "metadata-jdbc-postgresql.properties";
                break;
            }
            case "com.mysql.jdbc.Driver": {
                fileName = "metadata-jdbc-mysql.properties";
                break;
            }
            case "org.h2.Driver": {
                fileName = "metadata-jdbc-h2.properties";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported jdbc driver");
            }
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        Properties properties = new Properties();
        properties.load(is);
        return properties;
    }

    @VisibleForTesting
    public static JdbcTemplate getJdbcTemplate(KylinConfig kylinConfig) throws Exception {
        StorageURL url = kylinConfig.getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters(url);
        BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)props);
        return new JdbcTemplate((DataSource)dataSource);
    }

    public static <T> T retry(Callback<T> func) throws Exception {
        try {
            return func.handle();
        }
        catch (Exception e) {
            log.error("occur exception, retry", (Throwable)e);
            return func.handle();
        }
    }

    public static interface Callback<T> {
        public T handle() throws Exception;

        default public void onError() {
        }
    }
}

