/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata.mapper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.metadata.MetadataMapperFactory;
import org.apache.kylin.common.persistence.metadata.jdbc.SqlWithRecordLockProviderAdapter;
import org.apache.kylin.common.persistence.metadata.mapper.BasicSqlTable;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSLCompleter;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.MultiRowInsertStatementProvider;
import org.mybatis.dynamic.sql.select.SelectDSLCompleter;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.update.UpdateDSL;
import org.mybatis.dynamic.sql.update.UpdateDSLCompleter;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.util.SqlProviderAdapter;
import org.mybatis.dynamic.sql.util.mybatis3.CommonCountMapper;
import org.mybatis.dynamic.sql.util.mybatis3.CommonDeleteMapper;
import org.mybatis.dynamic.sql.util.mybatis3.CommonUpdateMapper;
import org.mybatis.dynamic.sql.util.mybatis3.MyBatis3Utils;

public interface BasicMapper<T extends RawResource>
extends CommonCountMapper,
CommonDeleteMapper,
CommonUpdateMapper {
    public static final Map<String, Map<String, BasicColumn>> SQL_FILED_CACHE = new ConcurrentHashMap<String, Map<String, BasicColumn>>();

    default public boolean needProjectFiled() {
        return true;
    }

    public <T2 extends BasicSqlTable<T2>> T2 getSqlTable();

    default public BasicColumn[] getSelectList() {
        return this.getSelectListWithAdditions(new BasicColumn[0]);
    }

    default public BasicColumn[] getSelectListWithAdditions(BasicColumn ... additions) {
        List<BasicColumn> generalColumns = ((BasicSqlTable)((Object)this.getSqlTable())).getGeneralColumns();
        if (this.needProjectFiled()) {
            generalColumns.add((BasicColumn)((BasicSqlTable)((Object)this.getSqlTable())).project);
        }
        generalColumns.addAll(Arrays.asList(additions));
        return generalColumns.toArray(new BasicColumn[0]);
    }

    default public Map<String, BasicColumn> getSelectColumnMap() {
        HashMap sqlFieldHelper;
        BasicColumn[] selectList = this.getSelectList();
        String tableName = this.getSqlTable().tableNameAtRuntime();
        if (selectList.length > 0 && !SQL_FILED_CACHE.containsKey(tableName)) {
            sqlFieldHelper = Maps.newHashMap();
            for (BasicColumn col : selectList) {
                sqlFieldHelper.put(MetadataMapperFactory.snakeCaseToCamelCase(((SqlColumn)col).name(), false), col);
            }
            if (!SQL_FILED_CACHE.containsKey(tableName)) {
                SQL_FILED_CACHE.put(tableName, sqlFieldHelper);
            }
        } else {
            sqlFieldHelper = SQL_FILED_CACHE.get(tableName);
        }
        return sqlFieldHelper;
    }

    default public BasicColumn getSqlColumn(String fieldName) {
        return this.getSelectColumnMap().get(fieldName);
    }

    default public int update(UpdateDSLCompleter completer) {
        return MyBatis3Utils.update(arg_0 -> ((BasicMapper)this).update(arg_0), this.getSqlTable(), (UpdateDSLCompleter)completer);
    }

    default public int updateByPrimaryKeyAndMvcc(RawResource record) {
        return MyBatis3Utils.update(arg_0 -> ((BasicMapper)this).update(arg_0), this.getSqlTable(), c -> (UpdateDSL.UpdateWhereBuilder)((UpdateDSL.UpdateWhereBuilder)this.updateAllColumns(record, (UpdateDSL<UpdateModel>)c).where((BindableColumn)((SqlColumn)this.getSqlColumn("metaKey")), (VisitableCondition)SqlBuilder.isEqualTo((Object)record.getMetaKey()), new AndOrCriteriaGroup[0])).and(((BasicSqlTable)((Object)((Object)this.getSqlTable()))).getMvcc(), (VisitableCondition)SqlBuilder.isEqualTo((Object)(record.getMvcc() - 1L)), new AndOrCriteriaGroup[0]));
    }

    default public UpdateDSL<UpdateModel> updateAllColumns(T record, UpdateDSL<UpdateModel> dsl) {
        Object sqlTable = this.getSqlTable();
        dsl = dsl.set(((BasicSqlTable)((Object)sqlTable)).uuid).equalTo((Object)((RawResource)record).getUuid()).set(((BasicSqlTable)((Object)sqlTable)).metaKey).equalTo((Object)((RawResource)record).getMetaKey()).set(((BasicSqlTable)((Object)sqlTable)).mvcc).equalTo((Object)((RawResource)record).getMvcc()).set(((BasicSqlTable)((Object)sqlTable)).ts).equalTo((Object)((RawResource)record).getTs()).set(((BasicSqlTable)((Object)sqlTable)).reservedFiled1).equalTo((Object)((RawResource)record).getReservedFiled1()).set(((BasicSqlTable)((Object)sqlTable)).content).equalTo((Object)((RawResource)record).getContent()).set(((BasicSqlTable)((Object)sqlTable)).reservedFiled2).equalTo((Object)((RawResource)record).getReservedFiled2()).set(((BasicSqlTable)((Object)sqlTable)).reservedFiled3).equalTo((Object)((RawResource)record).getReservedFiled3());
        if (this.needProjectFiled()) {
            dsl = dsl.set(((BasicSqlTable)((Object)sqlTable)).project).equalTo((Object)((RawResource)record).getProject());
        }
        return dsl;
    }

    default public int insertOne(RawResource record) {
        return this.insert(record);
    }

    default public int delete(DeleteDSLCompleter completer) {
        return MyBatis3Utils.deleteFrom(arg_0 -> ((BasicMapper)this).delete(arg_0), this.getSqlTable(), (DeleteDSLCompleter)completer);
    }

    default public Optional<T> selectOneWithColumnsAndRecordLock(SelectDSLCompleter completer, BasicColumn[] selectCols) {
        return (Optional)MyBatis3Utils.selectOne(this::selectOneWithRecordLock, (BasicColumn[])selectCols, this.getSqlTable(), (SelectDSLCompleter)completer);
    }

    public List<T> selectMany(SelectStatementProvider var1);

    public List<T> selectManyWithRecordLock(SelectStatementProvider var1);

    @InsertProvider(type=SqlProviderAdapter.class, method="insert")
    public int insert(InsertStatementProvider<T> var1);

    public Optional<T> selectOne(SelectStatementProvider var1);

    @SelectProvider(type=SqlWithRecordLockProviderAdapter.class, method="select")
    public Optional<T> selectOneWithRecordLock(SelectStatementProvider var1);

    default public List<T> select(SelectDSLCompleter completer) {
        return MyBatis3Utils.selectList(this::selectMany, (BasicColumn[])this.getSelectList(), this.getSqlTable(), (SelectDSLCompleter)completer);
    }

    default public int insert(T record) {
        return MyBatis3Utils.insert(this::insert, record, this.getSqlTable(), c -> {
            this.getSelectColumnMap().forEach((k, v) -> {
                if (k.equals("id")) {
                    return;
                }
                c.map((SqlColumn)v).toProperty(k);
            });
            return c;
        });
    }

    @InsertProvider(type=SqlProviderAdapter.class, method="insertMultiple")
    public int insertMultiple(MultiRowInsertStatementProvider<T> var1);

    default public int insertMultiple(Collection<T> records) {
        return MyBatis3Utils.insertMultiple(this::insertMultiple, records, this.getSqlTable(), c -> {
            this.getSelectColumnMap().forEach((k, v) -> {
                if (k.equals("id")) {
                    return;
                }
                c.map((SqlColumn)v).toProperty(k);
            });
            return c;
        });
    }
}

