/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.transaction;

import java.sql.SQLTransactionRollbackException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeSystem;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.persistence.InMemResourceStore;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.TombRawResource;
import org.apache.kylin.common.persistence.TransparentResourceStore;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.event.EndUnit;
import org.apache.kylin.common.persistence.event.Event;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.event.ResourceDeleteEvent;
import org.apache.kylin.common.persistence.event.ResourceRelatedEvent;
import org.apache.kylin.common.persistence.event.StartUnit;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.resources.SystemRawResource;
import org.apache.kylin.common.persistence.transaction.AuditLogBroadcastEventNotifier;
import org.apache.kylin.common.persistence.transaction.QuitTxnRightNow;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkContext;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;

public class UnitOfWork {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnitOfWork.class);
    public static final String GLOBAL_UNIT = "_global";
    public static final String THREAD_NAME_PREFIX = "Transaction-Thread";
    public static final long DEFAULT_EPOCH_ID = -1L;
    public static final int DEFAULT_MAX_RETRY = 3;
    private static EventBusFactory factory;
    static ThreadLocal<Boolean> replaying;
    private static ThreadLocal<UnitOfWorkContext> threadLocals;

    private static EventBusFactory getFactory() {
        if (factory == null) {
            factory = EventBusFactory.getInstance();
        }
        return factory;
    }

    public static <T> T doInTransactionWithRetry(Callback<T> f, String unitName) {
        return UnitOfWork.doInTransactionWithRetry(f, unitName, 3);
    }

    public static <T> T doInTransactionWithRetry(Callback<T> f, String unitName, int maxRetry) {
        return UnitOfWork.doInTransactionWithRetry(UnitOfWorkParams.builder().processor(f).unitName(unitName).maxRetry(maxRetry).build());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T doInTransactionWithRetry(UnitOfWorkParams<T> params) {
        Pair<T, Boolean> ret;
        int retry;
        SetThreadName ignore = new SetThreadName(THREAD_NAME_PREFIX, new Object[0]);
        Throwable throwable = null;
        try {
            Callback<T> f = params.getProcessor();
            if (UnitOfWork.isAlreadyInTransaction()) {
                UnitOfWorkContext unitOfWork = UnitOfWork.get();
                unitOfWork.checkReentrant(params);
                try {
                    UnitOfWork.checkEpoch(params);
                    f.preProcess();
                    T t = f.process();
                    return t;
                }
                catch (Throwable throwable2) {
                    f.onProcessError(throwable2);
                    throw new TransactionException("transaction failed due to inconsistent state", throwable2);
                }
            }
            retry = 0;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        String traceId = RandomUtil.randomUUIDStr();
        if (params.isRetryMoreTimeForDeadLockException()) {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            params.setRetryUntil(System.currentTimeMillis() + config.getMaxSecondsForDeadLockRetry() * 1000L);
        }
        do {
            if (retry++ >= params.getMaxRetry()) throw new IllegalStateException("Unexpected doInTransactionWithRetry end");
        } while (!(ret = UnitOfWork.doTransaction(params, retry, traceId)).getSecond().booleanValue());
        T t = ret.getFirst();
        return t;
        finally {
            if (ignore != null) {
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    ignore.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> Pair<T, Boolean> doTransaction(UnitOfWorkParams<T> params, int retry, String traceId) {
        Pair<Object, Boolean> result = Pair.newPair(null, false);
        UnitOfWorkContext context = null;
        try {
            try (SetLogCategory ignored = new SetLogCategory("metadata");){
                if (retry != 1) {
                    log.debug("UnitOfWork {} in project {} is retrying for {}th time", new Object[]{traceId, params.getUnitName(), retry});
                } else {
                    log.debug("UnitOfWork {} started on project {}", (Object)traceId, (Object)params.getUnitName());
                }
            }
            long startTime = System.currentTimeMillis();
            params.getProcessor().preProcess();
            context = UnitOfWork.startTransaction(params);
            long startTransactionTime = System.currentTimeMillis();
            long waitForLockTime = startTransactionTime - startTime;
            if (waitForLockTime > 3000L) {
                try (SetLogCategory ignored = new SetLogCategory("metadata");){
                    log.warn("UnitOfWork {} takes too long time {}ms to start", (Object)traceId, (Object)waitForLockTime);
                }
            }
            T ret = params.getProcessor().process();
            UnitOfWork.endTransaction(traceId, params);
            long duration = System.currentTimeMillis() - startTransactionTime;
            UnitOfWork.logIfLongTransaction(duration, traceId);
            result = Pair.newPair(ret, true);
        }
        catch (Throwable throwable) {
            UnitOfWork.handleError(throwable, params, retry, traceId);
        }
        finally {
            if (UnitOfWork.isAlreadyInTransaction()) {
                try (SetLogCategory ignored = new SetLogCategory("metadata");){
                    UnitOfWorkContext unitOfWork = UnitOfWork.get();
                    unitOfWork.cleanResource();
                }
                catch (IllegalStateException e) {
                    log.warn(e.getMessage());
                }
                catch (Exception e) {
                    log.error("Failed to close UnitOfWork", (Throwable)e);
                }
                threadLocals.remove();
            }
        }
        if (result.getSecond().booleanValue() && context != null) {
            context.onUnitFinished();
        }
        return result;
    }

    private static void logIfLongTransaction(long duration, String traceId) {
        try (SetLogCategory ignored = new SetLogCategory("metadata");){
            if (duration > 3000L) {
                log.warn("UnitOfWork {} takes too long time {}ms to complete", (Object)traceId, (Object)duration);
                if (duration > 10000L) {
                    log.warn("current stack: ", new Throwable());
                }
            } else {
                log.debug("UnitOfWork {} takes {}ms to complete", (Object)traceId, (Object)duration);
            }
        }
    }

    static <T> UnitOfWorkContext startTransaction(UnitOfWorkParams<T> params) throws Exception {
        String unitName = params.getUnitName();
        UnitOfWork.checkEpoch(params);
        UnitOfWorkContext unitOfWork = new UnitOfWorkContext(unitName);
        unitOfWork.setParams(params);
        threadLocals.set(unitOfWork);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStore underlying = ResourceStore.getKylinMetaStore(config);
        MetadataStore metadataStore = underlying.getMetadataStore();
        KylinConfig configCopy = KylinConfig.createKylinConfig(config);
        TransparentResourceStore rs = new TransparentResourceStore((InMemResourceStore)underlying, configCopy);
        ResourceStore.setRS(configCopy, rs);
        unitOfWork.setLocalConfig(KylinConfig.setAndUnsetThreadLocalConfig(configCopy));
        try (SetLogCategory ignored = new SetLogCategory("metadata");){
            log.trace("Transparent RS {} now takes place for main RS {}", (Object)rs, (Object)underlying);
        }
        TransactionStatus status = metadataStore.getTransaction();
        assert (status != null);
        unitOfWork.setTransactionStatus(status);
        return unitOfWork;
    }

    private static <T> void checkEpoch(UnitOfWorkParams<T> params) throws Exception {
        Callback<T> checker = params.getEpochChecker();
        if (checker != null && !params.isReadonly()) {
            checker.process();
        }
    }

    public static UnitOfWorkContext get() {
        UnitOfWorkContext temp = threadLocals.get();
        Preconditions.checkNotNull((Object)temp, (Object)"current thread is not accompanied by a UnitOfWork");
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void endTransaction(String traceId, UnitOfWorkParams<T> params) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        UnitOfWorkContext work = UnitOfWork.get();
        TransparentResourceStore transparentRS = (TransparentResourceStore)ResourceStore.getKylinMetaStore(config);
        List<RawResource> data = transparentRS.getResources();
        Set<String> copyForWriteResources = UnitOfWork.get().getCopyForWriteItems();
        List<Event> eventList = data.stream().map(x -> {
            String resPath = x.generateKeyWithType();
            if (x.getContent() != null && !(x instanceof SystemRawResource) && !copyForWriteResources.contains(resPath)) {
                throw new IllegalStateException("Transaction try to modify a resource without copyForWrite: " + x.getMetaKey());
            }
            if (x instanceof TombRawResource) {
                return new ResourceDeleteEvent(resPath);
            }
            return new ResourceCreateOrUpdateEvent(resPath, (RawResource)x);
        }).collect(Collectors.toList());
        UnitMessages unitMessages = null;
        long entitiesSize = 0L;
        KylinConfig originConfig = work.getOriginConfig();
        boolean isUT = config.isUTEnv();
        MetadataStore metadataStore = ResourceStore.getKylinMetaStore(originConfig).getMetadataStore();
        try {
            Consumer<ResourceRelatedEvent> writeInterceptor = params.getWriteInterceptor();
            unitMessages = UnitOfWork.packageEvents(eventList, traceId, writeInterceptor);
            entitiesSize = unitMessages.getMessages().stream().filter(event -> event instanceof ResourceRelatedEvent).count();
            try (SetLogCategory ignored = new SetLogCategory("metadata");){
                log.debug("transaction {} updates {} metadata items", (Object)traceId, (Object)entitiesSize);
            }
            if (!UnitOfWork.get().getParams().isSkipAuditLog()) {
                metadataStore.getAuditLogStore().save(unitMessages);
            }
            UnitOfWork.get().onUnitUpdated();
            transparentRS.getMetadataStore().commit(threadLocals.get().getTransactionStatus());
            threadLocals.get().setTransactionStatus(null);
        }
        finally {
            work.cleanResource();
        }
        if (!(entitiesSize == 0L || params.isReadonly() || params.isSkipAuditLog() || config.isUTEnv())) {
            UnitOfWork.getFactory().postAsync(new AuditLogBroadcastEventNotifier());
        }
        long startTime = System.currentTimeMillis();
        if (UnitOfWork.get().isSkipReplay()) {
            return;
        }
        try (SetLogCategory ignored = new SetLogCategory("metadata");){
            transparentRS.getAuditLogStore().catchupWithMaxTimeout();
            long endTime = System.currentTimeMillis();
            if (endTime - startTime > 1500L) {
                log.warn("UnitOfWork {} takes too long time {}ms to catchup audit log", (Object)traceId, (Object)(endTime - startTime));
            }
        }
    }

    private static void handleError(Throwable throwable, UnitOfWorkParams<?> params, int retry, String traceId) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        TransactionStatus status = threadLocals.get().getTransactionStatus();
        if (status != null) {
            ResourceStore.getKylinMetaStore(config).getMetadataStore().rollback(status);
            threadLocals.get().setTransactionStatus(null);
        }
        if (throwable instanceof KylinException && Objects.nonNull(((KylinException)throwable).getErrorCodeProducer()) && ((KylinException)throwable).getErrorCodeProducer().getErrorCode().equals(ErrorCodeSystem.MAINTENANCE_MODE_WRITE_FAILED.getErrorCode())) {
            retry = params.getMaxRetry();
        }
        if (throwable instanceof SQLTransactionRollbackException) {
            log.debug("DeadLock found in this transaction, will retry");
            if (params.isRetryMoreTimeForDeadLockException() && System.currentTimeMillis() < params.getRetryUntil()) {
                params.setMaxRetry(params.getMaxRetry() + 1);
            }
        }
        if (throwable instanceof QuitTxnRightNow) {
            retry = params.getMaxRetry();
        }
        if (retry >= params.getMaxRetry()) {
            params.getProcessor().onProcessError(throwable);
            throw new TransactionException("exhausted max retry times, transaction failed due to inconsistent state, traceId:" + traceId, throwable);
        }
        if (retry == 1) {
            try (SetLogCategory ignored = new SetLogCategory("metadata");){
                log.warn("transaction failed at first time, traceId:" + traceId, throwable);
            }
        }
    }

    private static UnitMessages packageEvents(List<Event> events, String uuid, Consumer<ResourceRelatedEvent> writeInterceptor) {
        for (Event e2 : events) {
            if (!(e2 instanceof ResourceRelatedEvent)) continue;
            ResourceRelatedEvent event = (ResourceRelatedEvent)e2;
            if (writeInterceptor == null) continue;
            writeInterceptor.accept(event);
        }
        events.add(0, new StartUnit(uuid));
        events.add(new EndUnit(uuid));
        events.forEach(e -> e.setKey(UnitOfWork.get().getProject()));
        return new UnitMessages(events);
    }

    public static boolean isAlreadyInTransaction() {
        return threadLocals.get() != null;
    }

    public static void doAfterUpdate(UnitOfWorkContext.UnitTask task) {
        if (UnitOfWork.isAlreadyInTransaction()) {
            UnitOfWork.get().doAfterUpdate(task);
            return;
        }
        try {
            task.run();
        }
        catch (KylinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Execute 'doAfterUpdate' failed.", e);
        }
    }

    public static boolean isReplaying() {
        return Objects.equals(true, replaying.get());
    }

    public static boolean isReadonly() {
        return UnitOfWork.get().isReadonly();
    }

    @Generated
    private UnitOfWork() {
    }

    static {
        replaying = new ThreadLocal();
        threadLocals = new ThreadLocal();
    }

    public static interface Callback<T> {
        default public void preProcess() {
        }

        public T process() throws Exception;

        default public void onProcessError(Throwable throwable) {
        }
    }
}

