/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Arrays;
import java.util.LinkedList;
import lombok.Generated;

public class TailBuilder {
    static final int ENTRY_SIZE = 1024;
    private LinkedList<char[]> data = new LinkedList();
    private final int maxCapacity;
    private int writableSize = 0;
    private int length = 0;

    public int length() {
        return Math.min(this.length, this.maxCapacity);
    }

    public TailBuilder(int maxCapacity) {
        if (maxCapacity < 0) {
            throw new IllegalArgumentException("maxCapacity must >= 0");
        }
        this.maxCapacity = maxCapacity;
    }

    public TailBuilder append(CharSequence csq) {
        if (this.maxCapacity == 0) {
            return this;
        }
        if (csq == null || csq.length() == 0) {
            return this;
        }
        if (csq.length() > this.maxCapacity) {
            csq = csq.subSequence(csq.length() - this.maxCapacity, csq.length());
        }
        int size2Append = csq.length();
        char[] charArray = csq.toString().toCharArray();
        while (size2Append > 0) {
            int copySize = Math.min(this.writableSize, size2Append);
            System.arraycopy(charArray, charArray.length - size2Append, this.getWriteEntry(), 1024 - this.writableSize, copySize);
            this.writableSize -= copySize;
            size2Append -= copySize;
            this.length += copySize;
        }
        return this;
    }

    private char[] getWriteEntry() {
        this.ensureWriteEntry();
        return this.data.getLast();
    }

    public TailBuilder append(char c) {
        if (this.maxCapacity == 0) {
            return this;
        }
        this.getWriteEntry()[1024 - this.writableSize] = c;
        --this.writableSize;
        ++this.length;
        return this;
    }

    private void ensureWriteEntry() {
        if (this.writableSize > 0) {
            return;
        }
        char[] allocated = null;
        if (1024 * (this.data.size() - 1) >= this.maxCapacity) {
            allocated = this.data.removeFirst();
            Arrays.fill(allocated, '\u0000');
            this.length -= 1024;
        }
        if (allocated == null) {
            allocated = new char[1024];
        }
        this.data.add(allocated);
        this.writableSize = 1024;
    }

    public String toString() {
        int totalSize = Math.min(this.length, this.maxCapacity);
        char[] result = new char[totalSize];
        int skipSize = Math.max(0, this.length - this.maxCapacity);
        int pos = 0;
        for (int i = 0; i < this.data.size() - 1; ++i) {
            if (skipSize >= 1024) {
                skipSize -= 1024;
                continue;
            }
            char[] src = this.data.get(i);
            System.arraycopy(src, skipSize, result, pos, 1024 - skipSize);
            pos += 1024 - skipSize;
            skipSize = 0;
        }
        System.arraycopy(this.getWriteEntry(), skipSize, result, pos, 1024 - this.writableSize - skipSize);
        return new String(result);
    }

    @Generated
    public int getMaxCapacity() {
        return this.maxCapacity;
    }
}

