/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.loader;

import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.kylin.loader.ParserClassLoader;
import org.apache.kylin.loader.utils.ClassLoaderUtils;

public class AddToClassPathAction
implements PrivilegedAction<ParserClassLoader> {
    private final ClassLoader parentLoader;
    private final Collection<String> newPaths;
    private final boolean forceNewClassLoader;

    public AddToClassPathAction(ClassLoader parentLoader, Collection<String> newPaths, boolean forceNewClassLoader) {
        this.parentLoader = parentLoader;
        this.newPaths = newPaths != null ? newPaths : Collections.emptyList();
        this.forceNewClassLoader = forceNewClassLoader;
        if (Objects.isNull(parentLoader)) {
            throw new IllegalArgumentException("ParserClassLoader is not designed to be a bootstrap class loader!");
        }
    }

    public AddToClassPathAction(ClassLoader parentLoader, Collection<String> newPaths) {
        this(parentLoader, newPaths, false);
    }

    @Override
    public ParserClassLoader run() {
        if (this.useExistingClassLoader()) {
            ParserClassLoader parserClassLoader = (ParserClassLoader)this.parentLoader;
            for (String path : this.newPaths) {
                parserClassLoader.addURL(ClassLoaderUtils.urlFromPathString(path));
            }
            return parserClassLoader;
        }
        return this.createParserClassLoader();
    }

    private boolean useExistingClassLoader() {
        if (!this.forceNewClassLoader && this.parentLoader instanceof ParserClassLoader) {
            ParserClassLoader parserClassLoader = (ParserClassLoader)this.parentLoader;
            return !parserClassLoader.isClosed();
        }
        return false;
    }

    private ParserClassLoader createParserClassLoader() {
        return new ParserClassLoader((URL[])this.newPaths.stream().map(ClassLoaderUtils::urlFromPathString).toArray(URL[]::new), this.parentLoader);
    }
}

