/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.util.NameMap;
import org.apache.calcite.util.NameMultimap;
import org.apache.calcite.util.NameSet;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.guava30.shaded.common.cache.CacheLoader;
import org.apache.kylin.guava30.shaded.common.cache.LoadingCache;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSortedMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSortedSet;
import org.checkerframework.checker.nullness.qual.Nullable;

class CachingCalciteSchema
extends CalciteSchema {
    private final Cached<SubSchemaCache> implicitSubSchemaCache = new AbstractCached<SubSchemaCache>(){

        @Override
        public SubSchemaCache build() {
            return new SubSchemaCache(CachingCalciteSchema.this, CachingCalciteSchema.this.schema.getSubSchemaNames());
        }
    };
    private final Cached<NameSet> implicitTableCache = new AbstractCached<NameSet>(){

        @Override
        public NameSet build() {
            return NameSet.immutableCopyOf(CachingCalciteSchema.this.schema.getTableNames());
        }
    };
    private final Cached<NameSet> implicitFunctionCache = new AbstractCached<NameSet>(){

        @Override
        public NameSet build() {
            return NameSet.immutableCopyOf(CachingCalciteSchema.this.schema.getFunctionNames());
        }
    };
    private final Cached<NameSet> implicitTypeCache = new AbstractCached<NameSet>(){

        @Override
        public NameSet build() {
            return NameSet.immutableCopyOf(CachingCalciteSchema.this.schema.getTypeNames());
        }
    };
    private boolean cache = true;

    CachingCalciteSchema(@Nullable CalciteSchema parent, Schema schema, String name) {
        this(parent, schema, name, null, null, null, null, null, null, null, null);
    }

    private CachingCalciteSchema(@Nullable CalciteSchema parent, Schema schema, String name, @Nullable NameMap<CalciteSchema> subSchemaMap, @Nullable NameMap<CalciteSchema.TableEntry> tableMap, @Nullable NameMap<CalciteSchema.LatticeEntry> latticeMap, @Nullable NameMap<CalciteSchema.TypeEntry> typeMap, @Nullable NameMultimap<CalciteSchema.FunctionEntry> functionMap, @Nullable NameSet functionNames, @Nullable NameMap<CalciteSchema.FunctionEntry> nullaryFunctionMap, @Nullable List<? extends List<String>> path) {
        super(parent, schema, name, subSchemaMap, tableMap, latticeMap, typeMap, functionMap, functionNames, nullaryFunctionMap, path);
    }

    @Override
    public void setCache(boolean cache) {
        if (cache == this.cache) {
            return;
        }
        long now = System.currentTimeMillis();
        this.implicitSubSchemaCache.enable(now, cache);
        this.implicitTableCache.enable(now, cache);
        this.implicitFunctionCache.enable(now, cache);
        this.cache = cache;
    }

    @Override
    protected boolean isCacheEnabled() {
        return this.cache;
    }

    @Override
    protected @Nullable CalciteSchema getImplicitSubSchema(String schemaName, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        Iterator<String> iterator = subSchemaCache.names.range(schemaName, caseSensitive).iterator();
        if (iterator.hasNext()) {
            String schemaName2 = iterator.next();
            return (CalciteSchema)subSchemaCache.cache.getUnchecked((Object)schemaName2);
        }
        return null;
    }

    @Override
    public CalciteSchema add(String name, Schema schema) {
        CachingCalciteSchema calciteSchema = new CachingCalciteSchema(this, schema, name);
        this.subSchemaMap.put(name, calciteSchema);
        return calciteSchema;
    }

    @Override
    protected @Nullable CalciteSchema.TableEntry getImplicitTable(String tableName, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        NameSet implicitTableNames = this.implicitTableCache.get(now);
        for (String tableName2 : implicitTableNames.range(tableName, caseSensitive)) {
            Table table = this.schema.getTable(tableName2);
            if (table == null) continue;
            return this.tableEntry(tableName2, table);
        }
        return null;
    }

    @Override
    protected @Nullable CalciteSchema.TypeEntry getImplicitType(String name, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        NameSet implicitTypeNames = this.implicitTypeCache.get(now);
        for (String typeName : implicitTypeNames.range(name, caseSensitive)) {
            RelProtoDataType type = this.schema.getType(typeName);
            if (type == null) continue;
            return this.typeEntry(name, type);
        }
        return null;
    }

    @Override
    protected void addImplicitSubSchemaToBuilder(ImmutableSortedMap.Builder<String, CalciteSchema> builder) {
        ImmutableSortedMap explicitSubSchemas = builder.build();
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        for (String name : subSchemaCache.names.iterable()) {
            if (explicitSubSchemas.containsKey((Object)name)) continue;
            builder.put((Object)name, subSchemaCache.cache.getUnchecked((Object)name));
        }
    }

    @Override
    protected void addImplicitTableToBuilder(ImmutableSortedSet.Builder<String> builder) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitTableCache.get(now);
        builder.addAll(set.iterable());
    }

    @Override
    protected void addImplicitFunctionsToBuilder(ImmutableList.Builder<Function> builder, String name, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        for (String name2 : set.range(name, caseSensitive)) {
            Collection<Function> functions = this.schema.getFunctions(name2);
            if (functions == null) continue;
            builder.addAll(functions);
        }
    }

    @Override
    protected void addImplicitFuncNamesToBuilder(ImmutableSortedSet.Builder<String> builder) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        builder.addAll(set.iterable());
    }

    @Override
    protected void addImplicitTypeNamesToBuilder(ImmutableSortedSet.Builder<String> builder) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitTypeCache.get(now);
        builder.addAll(set.iterable());
    }

    @Override
    protected void addImplicitTablesBasedOnNullaryFunctionsToBuilder(ImmutableSortedMap.Builder<String, Table> builder) {
        ImmutableSortedMap explicitTables = builder.build();
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        for (String s : set.iterable()) {
            if (explicitTables.containsKey((Object)s)) continue;
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply((List<? extends Object>)ImmutableList.of());
                builder.put((Object)s, (Object)table);
            }
        }
    }

    @Override
    protected @Nullable CalciteSchema.TableEntry getImplicitTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        for (String s : set.range(tableName, caseSensitive)) {
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply((List<? extends Object>)ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
        }
        return null;
    }

    @Override
    protected CalciteSchema snapshot(@Nullable CalciteSchema parent, SchemaVersion version) {
        CachingCalciteSchema snapshot = new CachingCalciteSchema(parent, this.schema.snapshot(version), this.name, null, this.tableMap, this.latticeMap, this.typeMap, this.functionMap, this.functionNames, this.nullaryFunctionMap, this.getPath());
        for (CalciteSchema subSchema : this.subSchemaMap.map().values()) {
            CalciteSchema subSchemaSnapshot = subSchema.snapshot(snapshot, version);
            snapshot.subSchemaMap.put(subSchema.name, subSchemaSnapshot);
        }
        return snapshot;
    }

    @Override
    public boolean removeTable(String name) {
        if (this.cache) {
            long now = System.nanoTime();
            this.implicitTableCache.enable(now, false);
            this.implicitTableCache.enable(now, true);
        }
        return super.removeTable(name);
    }

    @Override
    public boolean removeFunction(String name) {
        if (this.cache) {
            long now = System.nanoTime();
            this.implicitFunctionCache.enable(now, false);
            this.implicitFunctionCache.enable(now, true);
        }
        return super.removeFunction(name);
    }

    private static class SubSchemaCache {
        final NameSet names;
        final LoadingCache<String, CalciteSchema> cache;

        private SubSchemaCache(final CalciteSchema calciteSchema, Set<String> names) {
            this.names = NameSet.immutableCopyOf(names);
            this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, CalciteSchema>(){

                public CalciteSchema load(String schemaName) {
                    Schema subSchema = calciteSchema.schema.getSubSchema(schemaName);
                    if (subSchema == null) {
                        throw new RuntimeException("sub-schema " + schemaName + " not found");
                    }
                    return new CachingCalciteSchema(calciteSchema, subSchema, schemaName);
                }
            });
        }
    }

    private abstract class AbstractCached<T>
    implements Cached<T> {
        @Nullable T t;
        boolean built = false;

        private AbstractCached() {
        }

        @Override
        public T get(long now) {
            if (!CachingCalciteSchema.this.cache) {
                return this.build();
            }
            if (!this.built) {
                this.t = this.build();
            }
            this.built = true;
            return (T)Nullness.castNonNull(this.t);
        }

        @Override
        public void enable(long now, boolean enabled) {
            if (!enabled) {
                this.t = null;
            }
            this.built = false;
        }
    }

    private static interface Cached<T> {
        public T get(long var1);

        public T build();

        public void enable(long var1, boolean var3);
    }
}

