/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TableFunctionScan
extends AbstractRelNode {
    private final RexNode rexCall;
    private final @Nullable Type elementType;
    private ImmutableList<RelNode> inputs;
    protected final @Nullable ImmutableSet<RelColumnMapping> columnMappings;

    protected TableFunctionScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, RexNode rexCall, @Nullable Type elementType, RelDataType rowType, @Nullable Set<RelColumnMapping> columnMappings) {
        super(cluster, traitSet);
        this.rexCall = rexCall;
        this.elementType = elementType;
        this.rowType = rowType;
        this.inputs = ImmutableList.copyOf(inputs);
        this.columnMappings = columnMappings == null ? null : ImmutableSet.copyOf(columnMappings);
    }

    protected TableFunctionScan(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInputs(), Objects.requireNonNull(input.getExpression("invocation"), "invocation"), (Type)input.get("elementType"), input.getRowType("rowType"), (Set<RelColumnMapping>)ImmutableSet.of());
    }

    @Override
    public final TableFunctionScan copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, inputs, this.rexCall, this.elementType, this.getRowType(), (Set<RelColumnMapping>)this.columnMappings);
    }

    public abstract TableFunctionScan copy(RelTraitSet var1, List<RelNode> var2, RexNode var3, @Nullable Type var4, RelDataType var5, @Nullable Set<RelColumnMapping> var6);

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode rexCall = shuttle.apply(this.rexCall);
        if (rexCall == this.rexCall) {
            return this;
        }
        return this.copy(this.traitSet, (List<RelNode>)this.inputs, rexCall, this.elementType, this.getRowType(), (Set<RelColumnMapping>)this.columnMappings);
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>((Collection<RelNode>)this.inputs);
        newInputs.set(ordinalInParent, p);
        this.inputs = ImmutableList.copyOf(newInputs);
        this.recomputeDigest();
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        if (this.inputs.size() == 0) {
            return super.estimateRowCount(mq);
        }
        double nRows = 0.0;
        for (RelNode input : this.inputs) {
            Double d = mq.getRowCount(input);
            if (d == null) continue;
            nRows += d.doubleValue();
        }
        return nRows;
    }

    public RexNode getCall() {
        return this.rexCall;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        pw.item("invocation", this.rexCall).item("rowType", this.rowType);
        if (this.elementType != null) {
            pw.item("elementType", this.elementType);
        }
        return pw;
    }

    public @Nullable Set<RelColumnMapping> getColumnMappings() {
        return this.columnMappings;
    }

    public @Nullable Type getElementType() {
        return this.elementType;
    }
}

