/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRuleConvention;
import springfox.documentation.schema.AlternateTypeRules;

public class JacksonSerializerConvention
implements AlternateTypeRuleConvention {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonSerializerConvention.class);
    private static final int IMMUTABLES_CONVENTION_ORDER = -2147479648;
    private final TypeResolver resolver;
    private final String packagePrefix;

    public JacksonSerializerConvention(TypeResolver resolver, String packagePrefix) {
        this.resolver = resolver;
        this.packagePrefix = packagePrefix;
    }

    public List<AlternateTypeRule> rules() {
        ScanResult scanResults = new ClassGraph().whitelistPackages(new String[]{this.packagePrefix}).enableAnnotationInfo().scan();
        List serialized = scanResults.getClassesWithAnnotation(JsonSerialize.class.getCanonicalName()).loadClasses();
        List deserialized = scanResults.getClassesWithAnnotation(JsonDeserialize.class.getCanonicalName()).loadClasses();
        ArrayList<AlternateTypeRule> rules = new ArrayList<AlternateTypeRule>();
        Stream.concat(serialized.stream(), deserialized.stream()).forEachOrdered(type -> this.findAlternate((Class<?>)type).ifPresent(alternative -> {
            rules.add(AlternateTypeRules.newRule((Type)this.resolver.resolve((Type)type, new Type[0]), (Type)this.resolver.resolve(alternative, new Type[0]), (int)this.getOrder()));
            rules.add(AlternateTypeRules.newRule((Type)this.resolver.resolve(ResponseEntity.class, new Type[]{type}), (Type)this.resolver.resolve(alternative, new Type[0]), (int)this.getOrder()));
        }));
        return rules;
    }

    private Optional<Type> findAlternate(Class<?> type) {
        Class<Void> deserializer;
        Class<Void> serializer = Optional.ofNullable(type.getAnnotation(JsonSerialize.class)).map(JsonSerialize::as).orElse(Void.class);
        if (serializer != (deserializer = Optional.ofNullable(type.getAnnotation(JsonDeserialize.class)).map(JsonDeserialize::as).orElse(Void.class))) {
            LOGGER.warn("The serializer {} and deserializer {} . Picking the serializer by default", (Object)serializer.getName(), (Object)deserializer.getName());
        }
        Class<Void> toUse = serializer == Void.class && deserializer == Void.class ? null : (serializer != Void.class ? serializer : deserializer);
        return Optional.ofNullable(toUse);
    }

    public int getOrder() {
        return -2147479648;
    }
}

