/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.udf.UdfDef;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.guava30.shaded.common.collect.HashMultimap;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdfRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UdfRegistry.class);
    public static final HashMultimap<String, Function> allUdfMap = UdfRegistry.genAllUdf();

    private UdfRegistry() {
    }

    private static HashMultimap<String, Function> genAllUdf() {
        HashMultimap allUdfMap = HashMultimap.create();
        HashMap udfDefinitions = new HashMap();
        KylinConfig.getInstanceFromEnv().getUDFs().forEach((udfType, udfDefClazz) -> udfDefinitions.put(udfType, new UdfDefinition(udfType.trim().toUpperCase(Locale.ROOT), udfDefClazz.trim())));
        Collections.unmodifiableCollection(udfDefinitions.values()).forEach(udfDef -> {
            try {
                Class<?> clazz = Class.forName(udfDef.getClassName());
                for (Method method : clazz.getMethods()) {
                    if (method.getDeclaringClass() == Object.class) continue;
                    ScalarFunction function = ScalarFunctionImpl.create((Method)method);
                    allUdfMap.put((Object)method.getName(), (Object)function);
                }
                UdfRegistry.registerFunctionsWithImpl(clazz);
            }
            catch (Exception e) {
                log.error("Register UDF {} fail", (Object)udfDef.getClassName(), (Object)e);
            }
        });
        HashMap udafDefinitions = new HashMap();
        for (Map.Entry entry : MeasureTypeFactory.getUDAFs().entrySet()) {
            udafDefinitions.put(entry.getKey(), new UdfDefinition(((String)entry.getKey()).trim().toUpperCase(Locale.ROOT), ((Class)entry.getValue()).getName().trim(), null));
        }
        for (UdfDefinition udfDef2 : Collections.unmodifiableCollection(udafDefinitions.values())) {
            try {
                AggregateFunctionImpl aggFunction = AggregateFunctionImpl.create(Class.forName(udfDef2.getClassName()));
                allUdfMap.put((Object)udfDef2.getName(), (Object)aggFunction);
            }
            catch (ClassNotFoundException e) {
                throw new KylinRuntimeException("UDAF class '" + udfDef2.getClassName() + "' not found");
            }
        }
        return allUdfMap;
    }

    private static void registerFunctionsWithImpl(Class<?> clazz) throws IllegalAccessException, NoSuchFieldException {
        for (Class<?> udfClass : clazz.getClasses()) {
            if (!UdfDef.class.isAssignableFrom(udfClass)) continue;
            SqlOperator udfOp = (SqlOperator)udfClass.getField("OPERATOR").get(null);
            CallImplementor udfImpl = (CallImplementor)udfClass.getField("IMPLEMENTOR").get(null);
            SqlStdOperatorTable.instance().register(udfOp);
            RexImpTable.INSTANCE.defineImplementor(udfOp, udfImpl);
        }
    }

    public static class UdfDefinition {
        String name;
        String className;
        String methodName;
        List<String> paths = null;

        public UdfDefinition(String name, String className) {
            this(name, className, "*");
        }

        public UdfDefinition(String name, String className, String methodName) {
            this.name = name;
            this.className = className;
            this.methodName = methodName;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public String getMethodName() {
            return this.methodName;
        }

        @Generated
        public List<String> getPaths() {
            return this.paths;
        }
    }
}

