/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.HashBiMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Range;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.ChooserContext;
import org.apache.kylin.metadata.cube.cuboid.IndexMatcher;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.cuboid.NLookupCandidate;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetails;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationCandidate;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.exception.UserStopQueryException;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapContextProp;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.PruningRule;
import org.apache.kylin.query.routing.QueryLayoutChooser;
import org.apache.kylin.query.routing.RealizationChooser;
import org.apache.kylin.query.util.ComputedColumnRewriter;
import org.apache.kylin.query.util.QueryAliasMatchInfo;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.kylin.query.util.RexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinTableChooserRule
extends PruningRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KylinTableChooserRule.class);

    @Override
    public void apply(Candidate candidate) {
        CapabilityResult capabilityResult;
        if (!this.isStorageMatch(candidate) || candidate.getCapability() != null) {
            return;
        }
        OlapContextProp propsBeforeRewrite = RealizationChooser.preservePropsBeforeRewrite(candidate.getCtx());
        if (!candidate.getRealization().getModel().getComputedColumnDescs().isEmpty()) {
            this.rewriteComputedColumns(candidate);
            candidate.getCtx().resetSQLDigest();
            capabilityResult = this.getCapabilityResult(candidate);
            candidate.recordRewrittenCtxProps();
        } else {
            RealizationChooser.restoreOlapContextProps(candidate.getCtx(), propsBeforeRewrite);
            candidate.getCtx().resetSQLDigest();
            capabilityResult = this.getCapabilityResult(candidate);
            candidate.recordRewrittenCtxProps();
        }
        candidate.setCapability(capabilityResult);
    }

    @Override
    public boolean isStorageMatch(Candidate candidate) {
        return candidate.getRealization().getModel().getStorageType().isV3Storage();
    }

    private void rewriteComputedColumns(Candidate candidate) {
        HashBiMap aliasMapping = HashBiMap.create(candidate.getMatchedJoinsGraphAliasMap());
        ComputedColumnRewriter.rewriteCcInnerCol(candidate.getCtx(), candidate.getRealization().getModel(), new QueryAliasMatchInfo((BiMap<String, String>)aliasMapping, null));
    }

    private CapabilityResult getCapabilityResult(Candidate candidate) {
        IRealization realization = candidate.getRealization();
        SQLDigest sqlDigest = candidate.getCtx().getSQLDigest();
        CapabilityResult capability = this.check((NDataflow)realization, candidate.getCtx(), sqlDigest);
        candidate.recordRewrittenCtxProps();
        return capability;
    }

    public CapabilityResult check(NDataflow dataflow, OlapContext olapContext, SQLDigest digest) {
        KylinTableChooserRule.logMatchingLayout(dataflow, digest);
        CapabilityResult result = new CapabilityResult();
        if (digest.isLimitPrecedesAggr()) {
            KylinTableChooserRule.logLimitPrecedesAggr(dataflow);
            result.incapableCause = CapabilityResult.IncapableCause.create((CapabilityResult.IncapableType)CapabilityResult.IncapableType.LIMIT_PRECEDE_AGGR);
            return result;
        }
        NLayoutCandidate chosenCandidate = null;
        String factTableOfQuery = digest.getFactTable();
        String modelFactTable = dataflow.getModel().getQueryCompatibleFactTable(factTableOfQuery);
        if (digest.getJoinDescs().isEmpty() && !modelFactTable.equals(factTableOfQuery)) {
            log.trace("Snapshot dataflow matching");
            chosenCandidate = KylinTableChooserRule.tryMatchLookup(dataflow, digest, result);
            if (chosenCandidate != null) {
                log.info("Matched table {} snapshot in dataflow {} ", (Object)factTableOfQuery, (Object)dataflow);
            }
        } else {
            NLayoutCandidate candidateAndInfluence = this.matchNormalDataflow(dataflow, digest, olapContext);
            if (candidateAndInfluence != null) {
                chosenCandidate = candidateAndInfluence;
                result.influences.addAll(candidateAndInfluence.getCapabilityResult().influences);
                log.info("Matched layout {} snapshot in dataflow {} ", (Object)chosenCandidate, (Object)dataflow);
            }
        }
        KylinTableChooserRule.setResult(result, dataflow, (IRealizationCandidate)chosenCandidate);
        return result;
    }

    private static void logMatchingLayout(NDataflow dataflow, SQLDigest digest) {
        log.info("Matching Layout in dataflow {}, SQL digest {}", (Object)dataflow, (Object)digest);
    }

    private static void logLimitPrecedesAggr(NDataflow dataflow) {
        log.info("Exclude NDataflow {} because there's limit preceding aggregation", (Object)dataflow);
    }

    private static void setResult(CapabilityResult result, NDataflow dataflow, IRealizationCandidate chosenCandidate) {
        if (chosenCandidate != null) {
            result.setCapable(true);
            result.setCandidate(dataflow.isStreaming(), chosenCandidate);
            result.setCost(chosenCandidate.getCost());
        } else {
            result.setCapable(false);
        }
    }

    private NLayoutCandidate matchNormalDataflow(NDataflow dataflow, SQLDigest digest, OlapContext ctx) {
        log.trace("Normal dataflow matching");
        List fragments = dataflow.listAllLayoutDetails();
        NLayoutCandidate candidateAndInfluence = this.selectLayoutCandidate(dataflow, fragments, digest, ctx);
        if (candidateAndInfluence != null) {
            log.info("Matched layout {} snapshot in dataflow {} ", (Object)candidateAndInfluence, (Object)dataflow);
            return candidateAndInfluence;
        }
        return candidateAndInfluence;
    }

    private static List<Pair<LayoutEntity, NDataLayoutDetails>> getCommonLayouts(NDataflow dataflow, List<NDataLayoutDetails> fragments) {
        return fragments.stream().filter(f -> dataflow.getIndexPlan().getLayoutEntity(Long.valueOf(f.getLayoutId())) != null).map(fragment -> Pair.newPair((Object)dataflow.getIndexPlan().getLayoutEntity(Long.valueOf(fragment.getLayoutId())), (Object)fragment)).collect(Collectors.toList());
    }

    private List<Pair<LayoutEntity, NDataLayoutDetails>> preCheckAndPruneLayouts(NDataflow dataflow, OlapContext olapContext, List<Pair<LayoutEntity, NDataLayoutDetails>> layouts) {
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)dataflow.getProject());
        if (!projectConfig.isHeterogeneousSegmentEnabled()) {
            return layouts;
        }
        PartitionDesc partitionCol = this.getPartitionDesc(dataflow, olapContext);
        if (this.isFullBuildModel(partitionCol)) {
            log.info("No partition column or partition column format is null.");
            return layouts;
        }
        RelOptCluster relOptCluster = olapContext.getFirstTableScan().getCluster();
        RexSimplify rexSimplify = new RexSimplify(relOptCluster.getRexBuilder(), RelOptPredicateList.EMPTY, true, relOptCluster.getPlanner().getExecutor());
        RexNode simplifiedFilter = rexSimplify.simplifyAnds(olapContext.getExpandedFilterConditions());
        if (simplifiedFilter.isAlwaysFalse()) {
            log.info("SQL filter condition is always false, pruning all layouts");
            olapContext.getStorageContext().setFilterCondAlwaysFalse(true);
            return Lists.newArrayList();
        }
        TblColRef partition = partitionCol.getPartitionDateColumnRef();
        if (simplifiedFilter.isAlwaysTrue()) {
            log.info("SQL filter condition is always true, pruning no layout");
            return layouts;
        }
        return this.pruneLayouts(dataflow, olapContext, rexSimplify, partition, simplifiedFilter, layouts);
    }

    private List<Pair<LayoutEntity, NDataLayoutDetails>> pruneLayouts(NDataflow dataflow, OlapContext olapContext, RexSimplify rexSimplify, TblColRef partitionColRef, RexNode simplifiedFilter, List<Pair<LayoutEntity, NDataLayoutDetails>> layouts) {
        if (CollectionUtils.isEmpty(olapContext.getExpandedFilterConditions()) || CollectionUtils.isEmpty(olapContext.getFilterColumns())) {
            log.info("There is no filter for pruning layouts.");
            return layouts;
        }
        RexInputRef partitionColInputRef = olapContext.getFilterColumns().contains(partitionColRef) ? RexUtils.transformColumn2RexInputRef(partitionColRef, olapContext.getAllTableScans()) : null;
        String partitionDateFormat = this.getPartitionDesc(dataflow, olapContext).getPartitionDateFormat();
        ArrayList<Pair<LayoutEntity, NDataLayoutDetails>> choosedLayouts = new ArrayList<Pair<LayoutEntity, NDataLayoutDetails>>();
        for (Pair<LayoutEntity, NDataLayoutDetails> layoutEntity : layouts) {
            try {
                QueryInterruptChecker.checkQueryCanceledOrThreadInterrupted((String)"Interrupted during pruning layouts by filter!", (String)"pruning layouts by filter");
                NDataLayoutDetails fragment = (NDataLayoutDetails)layoutEntity.getSecond();
                fragment.getFragmentRangeSet().asRanges().forEach(range -> {
                    ArrayList<RexNode> allPredicates = new ArrayList<RexNode>();
                    allPredicates.addAll(this.collectPartitionPredicates(rexSimplify.rexBuilder, (Range<Long>)range, partitionColInputRef, partitionDateFormat, partitionColRef.getType()));
                    RelOptPredicateList predicateList = RelOptPredicateList.of((RexBuilder)rexSimplify.rexBuilder, allPredicates);
                    RexNode simplifiedWithPredicates = rexSimplify.withPredicates(predicateList).simplify(simplifiedFilter);
                    if (!simplifiedWithPredicates.isAlwaysFalse()) {
                        choosedLayouts.add(layoutEntity);
                    }
                });
            }
            catch (InterruptedException ie) {
                log.error(String.format(Locale.ROOT, "Interrupted on pruning layout from %s!", ((LayoutEntity)layoutEntity.getFirst()).toString()), (Throwable)ie);
                Thread.currentThread().interrupt();
                throw new KylinRuntimeException((Throwable)ie);
            }
            catch (KylinTimeoutException | UserStopQueryException e) {
                log.error(String.format(Locale.ROOT, "Stop pruning layout from %s!", ((LayoutEntity)layoutEntity.getFirst()).toString()), e);
                throw e;
            }
            catch (Exception ex) {
                log.warn(String.format(Locale.ROOT, "To skip the exception on pruning layout %s!", ((LayoutEntity)layoutEntity.getFirst()).toString()), (Throwable)ex);
                choosedLayouts.add(layoutEntity);
            }
        }
        log.info("Pruned out {} layouts of {}.", (Object)(layouts.size() - choosedLayouts.size()), (Object)layouts.size());
        return choosedLayouts;
    }

    private List<RexNode> collectPartitionPredicates(RexBuilder rexBuilder, Range<Long> range, RexInputRef partitionColInputRef, String dateFormat, DataType partitionColType) {
        if (partitionColInputRef == null) {
            return Collections.emptyList();
        }
        ArrayList allPredicts = Lists.newArrayList();
        long fragmentStartTs = (Long)range.lowerEndpoint();
        long fragmentEndTs = (Long)range.upperEndpoint();
        String formattedStart = DateFormat.formatToDateStr((long)fragmentStartTs, (String)dateFormat);
        String formattedEnd = DateFormat.formatToDateStr((long)fragmentEndTs, (String)dateFormat);
        String start = KylinTableChooserRule.checkAndReformatDateType(formattedStart, fragmentStartTs, partitionColType);
        String end = KylinTableChooserRule.checkAndReformatDateType(formattedEnd, fragmentEndTs, partitionColType);
        List<RexNode> rexNodes = this.transformValue2RexCall(rexBuilder, partitionColInputRef, partitionColType, start, end, false);
        allPredicts.addAll(rexNodes);
        return allPredicts;
    }

    private NLayoutCandidate selectLayoutCandidate(NDataflow dataflow, List<NDataLayoutDetails> fragments, SQLDigest sqlDigest, OlapContext ctx) {
        if (CollectionUtils.isEmpty(fragments)) {
            log.info("There is no data range to answer sql");
            return NLayoutCandidate.ofEmptyCandidate();
        }
        ChooserContext chooserContext = new ChooserContext(sqlDigest, dataflow);
        if (chooserContext.isIndexMatchersInvalid()) {
            return null;
        }
        List<Pair<LayoutEntity, NDataLayoutDetails>> commonLayouts = KylinTableChooserRule.getCommonLayouts(dataflow, fragments);
        commonLayouts = this.preCheckAndPruneLayouts(dataflow, ctx, commonLayouts);
        log.info("Matching dataflow with layout num: {}", (Object)commonLayouts.size());
        List<NLayoutCandidate> candidates = this.collectAllLayoutCandidates(chooserContext, commonLayouts);
        return QueryLayoutChooser.chooseBestLayoutCandidate(dataflow, sqlDigest, chooserContext, candidates, "selectLayoutCandidate");
    }

    public List<NLayoutCandidate> collectAllLayoutCandidates(ChooserContext chooserContext, List<Pair<LayoutEntity, NDataLayoutDetails>> dataLayouts) {
        return dataLayouts.stream().filter(pair -> this.isMatched(chooserContext, (LayoutEntity)pair.getFirst())).map(pair -> this.createCandidate(chooserContext, (Pair<LayoutEntity, NDataLayoutDetails>)pair)).collect(Collectors.toList());
    }

    private boolean isMatched(ChooserContext chooserContext, LayoutEntity layout) {
        IndexMatcher.MatchResult matchResult = chooserContext.getTableIndexMatcher().match(layout);
        if (!matchResult.isMatched()) {
            matchResult = chooserContext.getAggIndexMatcher().match(layout);
        }
        return matchResult.isMatched();
    }

    private NLayoutCandidate createCandidate(ChooserContext chooserContext, Pair<LayoutEntity, NDataLayoutDetails> pair) {
        LayoutEntity layout = (LayoutEntity)pair.getFirst();
        NLayoutCandidate candidate = new NLayoutCandidate(layout, (NDataLayoutDetails)pair.getSecond());
        IndexMatcher.MatchResult matchResult = chooserContext.getTableIndexMatcher().match(layout);
        if (!matchResult.isMatched()) {
            matchResult = chooserContext.getAggIndexMatcher().match(layout);
        }
        CapabilityResult tempResult = new CapabilityResult(matchResult);
        if (!matchResult.getNeedDerive().isEmpty()) {
            candidate.setDerivedToHostMap(matchResult.getNeedDerive());
            candidate.setDerivedLookups(candidate.getDerivedToHostMap().keySet().stream().map(i -> chooserContext.convertToRef(i).getTable()).collect(Collectors.toSet()));
        }
        long size = ((NDataLayoutDetails)pair.getSecond()).getSizeInBytes();
        candidate.setCost((double)size * ((double)tempResult.influences.size() + matchResult.getInfluenceFactor()));
        candidate.setCapabilityResult(tempResult);
        return candidate;
    }

    private static IRealizationCandidate tryMatchLookup(NDataflow dataflow, SQLDigest digest, CapabilityResult result) {
        NTableMetadataManager tableMgr = NTableMetadataManager.getInstance((KylinConfig)dataflow.getConfig(), (String)dataflow.getProject());
        if (dataflow.getLatestReadySegment() == null || StringUtils.isEmpty((CharSequence)tableMgr.getTableDesc(digest.getFactTable()).getLastSnapshotPath())) {
            log.info("Exclude NDataflow {} because snapshot of table {} does not exist", (Object)dataflow, (Object)digest.getFactTable());
            result.incapableCause = CapabilityResult.IncapableCause.create((CapabilityResult.IncapableType)CapabilityResult.IncapableType.NOT_EXIST_SNAPSHOT);
            result.setCapable(false);
            return null;
        }
        NDataModel model = KylinTableChooserRule.getModel(dataflow);
        HashSet colsOfSnapShot = Sets.newHashSet((Iterable)model.findFirstTable(digest.getFactTable()).getColumns());
        HashSet unmatchedCols = Sets.newHashSet((Iterable)digest.getAllColumns());
        unmatchedCols.removeAll(colsOfSnapShot);
        if (!unmatchedCols.isEmpty()) {
            log.info("Exclude NDataflow {} because unmatched dimensions [{}] in Snapshot", (Object)dataflow, (Object)unmatchedCols);
            result.incapableCause = CapabilityResult.IncapableCause.unmatchedDimensions((Collection)unmatchedCols);
            return null;
        }
        return new NLookupCandidate(digest.getFactTable(), NLookupCandidate.getDerivedPolicy((KylinConfig)dataflow.getConfig()));
    }

    private static NDataModel getModel(NDataflow dataflow) {
        NDataModel model = dataflow.getModel();
        if (model.isFusionModel()) {
            model = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject()).getDataModelDesc(model.getFusionId());
        }
        return model;
    }
}

