/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.MultiPartitionKeyMapping;
import org.apache.kylin.metadata.model.MultiPartitionKeyMappingImpl;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealizationCandidate;
import org.apache.kylin.query.exception.UserStopQueryException;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.PruningRule;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.kylin.query.util.RexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionPruningRule
extends PruningRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PartitionPruningRule.class);
    private static final String NEED_PUSH_DOWN = "NULL";

    @Override
    public void apply(Candidate candidate) {
        if (!this.isStorageMatch(candidate)) {
            return;
        }
        if (this.nonBatchRealizationSkipPartitionsPruning(candidate)) {
            log.info("{}({}/{}): only batch model support multi-partitions pruning.", new Object[]{this.getClass().getName(), candidate.getRealization().getProject(), candidate.getRealization().getCanonicalName()});
            return;
        }
        if (this.noQueryableSegmentsCanAnswer(candidate)) {
            log.debug("{}({}/{}): no queryable(READY|WARNING) segments can answer", new Object[]{this.getClass().getName(), candidate.getRealization().getProject(), candidate.getRealization().getCanonicalName()});
            return;
        }
        if (this.noMultiPartitionColumnsExist(candidate)) {
            log.debug("{}({}/{}): there is no multi-partition columns.", new Object[]{this.getClass().getName(), candidate.getRealization().getProject(), candidate.getRealization().getCanonicalName()});
            return;
        }
        NDataModel model = candidate.getRealization().getModel();
        Map<String, List<Long>> matchedPartitions = this.matchPartitions(candidate);
        if (this.needPushDown(matchedPartitions)) {
            log.debug("{}({}/{}): cannot match multi-partitions of segments.", new Object[]{this.getClass().getName(), candidate.getRealization().getProject(), candidate.getRealization().getCanonicalName()});
            CapabilityResult capability = new CapabilityResult();
            capability.setCapable(false);
            candidate.setCapability(capability);
            return;
        }
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject()).getDataflow(model.getId());
        boolean allPartitionsEmpty = matchedPartitions.entrySet().stream().allMatch(entry -> {
            NDataSegment segment = dataflow.getSegment((String)entry.getKey());
            List partitionIds = (List)entry.getValue();
            return CollectionUtils.isNotEmpty((Collection)segment.getMultiPartitionIds()) && CollectionUtils.isEmpty((Collection)partitionIds);
        });
        if (allPartitionsEmpty) {
            log.info("there is no sub-partitions to answer sql");
            CapabilityResult capability = new CapabilityResult();
            capability.setCapable(true);
            capability.setSelectedCandidate((IRealizationCandidate)NLayoutCandidate.ofEmptyCandidate());
            candidate.setCapability(capability);
            return;
        }
        candidate.setPrunedPartitions(matchedPartitions);
    }

    @Override
    public boolean isStorageMatch(Candidate candidate) {
        return candidate.getRealization().getModel().getStorageType().isV1Storage();
    }

    private boolean needPushDown(Map<String, List<Long>> matchedPartitions) {
        return matchedPartitions.size() == 1 && matchedPartitions.containsKey(NEED_PUSH_DOWN);
    }

    private boolean noMultiPartitionColumnsExist(Candidate candidate) {
        NDataModel model = candidate.getRealization().getModel();
        MultiPartitionDesc multiPartitionDesc = model.getMultiPartitionDesc();
        return multiPartitionDesc == null || CollectionUtils.isEmpty((Collection)multiPartitionDesc.getColumns());
    }

    private boolean noQueryableSegmentsCanAnswer(Candidate candidate) {
        return CollectionUtils.isEmpty((Collection)candidate.getQueryableSeg().getBatchSegments());
    }

    private boolean nonBatchRealizationSkipPartitionsPruning(Candidate candidate) {
        return CollectionUtils.isNotEmpty((Collection)candidate.getQueryableSeg().getStreamingSegments());
    }

    private Map<String, List<Long>> matchPartitions(Candidate candidate) {
        NDataModel model = candidate.getRealization().getModel();
        OlapContext olapContext = candidate.getCtx();
        Map<String, List<Long>> segPartitionMap = candidate.getQueryableSeg().getBatchSegments().stream().collect(Collectors.toMap(RootPersistentEntity::getId, NDataSegment::getMultiPartitionIds));
        if (this.filtersContainPartOfMultiPartitionKeyMappingCols(model, olapContext.getFilterColumns())) {
            return segPartitionMap;
        }
        RelOptCluster relOptCluster = olapContext.getFirstTableScan().getCluster();
        RexBuilder rexBuilder = relOptCluster.getRexBuilder();
        RexSimplify rexSimplify = new RexSimplify(relOptCluster.getRexBuilder(), RelOptPredicateList.EMPTY, true, relOptCluster.getPlanner().getExecutor());
        RexNode simplifiedFilters = rexSimplify.simplifyAnds(olapContext.getExpandedFilterConditions());
        if (simplifiedFilters.isAlwaysFalse()) {
            log.info("The SQL filter condition is always false, and all partitions are filtered out.");
            return Maps.newHashMap();
        }
        if (simplifiedFilters.isAlwaysTrue()) {
            log.info("The SQL filter condition is always true, and all partitions are reserved.");
            return segPartitionMap;
        }
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject()).getDataflow(model.getId());
        LinkedList partitionColRefs = model.getMultiPartitionDesc().getColumnRefs();
        for (MultiPartitionDesc.PartitionInfo partition : model.getMultiPartitionDesc().getPartitions()) {
            try {
                QueryInterruptChecker.checkQueryCanceledOrThreadInterrupted((String)"Interrupted during pruning partitions!", (String)"pruning partitions");
                RexNode partitionRex = this.partitionToRexCall(partitionColRefs, partition.getValues(), rexBuilder, olapContext.getAllTableScans());
                RexNode mappingColRex = this.multiPartitionKeyMappingToRex(rexBuilder, partition.getValues(), (MultiPartitionKeyMapping)model.getMultiPartitionKeyMapping(), olapContext.getAllTableScans());
                ArrayList nodes = Lists.newArrayList((Object[])new RexNode[]{simplifiedFilters, partitionRex, mappingColRex});
                RexNode simplifyAnds = rexSimplify.simplifyAnds((Iterable)nodes);
                RelOptPredicateList predicate = RelOptPredicateList.of((RexBuilder)rexBuilder, (Iterable)Lists.newArrayList((Object[])new RexNode[]{partitionRex, mappingColRex}));
                RexNode simplifiedWithPredicate = rexSimplify.withPredicates(predicate).simplify(simplifiedFilters);
                if (simplifyAnds.isAlwaysFalse() || simplifiedWithPredicate.isAlwaysFalse()) {
                    segPartitionMap.forEach((dataSegment, partitionIds) -> partitionIds.remove(partition.getId()));
                    continue;
                }
            }
            catch (InterruptedException ie) {
                log.error(String.format(Locale.ROOT, "Interrupted on pruning partitions from %s!", partition.toString()), (Throwable)ie);
                Thread.currentThread().interrupt();
                throw new KylinRuntimeException((Throwable)ie);
            }
            catch (KylinTimeoutException | UserStopQueryException e) {
                log.error(String.format(Locale.ROOT, "Stop pruning partitions from %s!", partition.toString()), e);
                throw e;
            }
            catch (Exception ex) {
                log.warn("Multi-partition pruning error: ", (Throwable)ex);
            }
            for (Map.Entry<String, List<Long>> entry : segPartitionMap.entrySet()) {
                List<Long> partitionIds2 = entry.getValue();
                if (partitionIds2.contains(partition.getId())) continue;
                NDataSegment segment = dataflow.getSegment(entry.getKey());
                log.info("segment {} does not have partition {}", (Object)segment.displayIdName(), (Object)partition.getId());
                return ImmutableMap.of((Object)NEED_PUSH_DOWN, (Object)Lists.newArrayList());
            }
        }
        return segPartitionMap;
    }

    private RexNode partitionToRexCall(List<TblColRef> partitionCols, String[] partitionValues, RexBuilder rexBuilder, Set<OlapTableScan> tableScans) {
        return this.transformColumns2RexCall(partitionCols, Collections.singletonList(Lists.newArrayList((Object[])partitionValues)), rexBuilder, tableScans);
    }

    private RexNode multiPartitionKeyMappingToRex(RexBuilder rexBuilder, String[] partitionValues, MultiPartitionKeyMapping multiPartitionKeyMapping, Set<OlapTableScan> tableScans) {
        if (multiPartitionKeyMapping == null) {
            return rexBuilder.makeLiteral(true);
        }
        List mappedColumns = multiPartitionKeyMapping.getAliasColumns();
        Collection mappedValues = multiPartitionKeyMapping.getAliasValue((List)Lists.newArrayList((Object[])partitionValues));
        if (CollectionUtils.isEmpty((Collection)mappedColumns) || CollectionUtils.isEmpty((Collection)mappedValues)) {
            return rexBuilder.makeLiteral(true);
        }
        return this.transformColumns2RexCall(mappedColumns, mappedValues, rexBuilder, tableScans);
    }

    private RexNode transformColumns2RexCall(List<TblColRef> columns, Collection<List<String>> values, RexBuilder rexBuilder, Set<OlapTableScan> tableScans) {
        ArrayList orRexCalls = Lists.newArrayList();
        for (List<String> columnValue : values) {
            int size = columns.size();
            ArrayList equalRexCalls = Lists.newArrayList();
            for (int i = 0; i < size; ++i) {
                String value = columnValue.get(i);
                TblColRef columnRef = columns.get(i);
                RexInputRef columnRexInputRef = RexUtils.transformColumn2RexInputRef(columnRef, tableScans);
                RexNode valueLiteral = RexUtils.transformValue2RexLiteral(rexBuilder, value, columnRef.getType());
                RexNode equalRexCall = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, (List)Lists.newArrayList((Object[])new RexNode[]{columnRexInputRef, valueLiteral}));
                equalRexCalls.add(equalRexCall);
            }
            RexNode andRexCall = equalRexCalls.size() == 1 ? (RexNode)equalRexCalls.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, (List)equalRexCalls);
            orRexCalls.add(andRexCall);
        }
        return orRexCalls.size() == 1 ? (RexNode)orRexCalls.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, (List)orRexCalls);
    }

    private boolean filtersContainPartOfMultiPartitionKeyMappingCols(NDataModel model, Set<TblColRef> filterCols) {
        Set aliasColumnIdentities;
        if (filterCols.containsAll(model.getMultiPartitionDesc().getColumnRefs())) {
            return false;
        }
        if (model.isEmptyMultiPartitionKeyMapping()) {
            return true;
        }
        MultiPartitionKeyMappingImpl mapping = model.getMultiPartitionKeyMapping();
        Set filterColumnIdentities = filterCols.stream().map(TblColRef::getCanonicalName).collect(Collectors.toSet());
        return !filterColumnIdentities.containsAll(aliasColumnIdentities = mapping.getAliasColumns().stream().map(TblColRef::getCanonicalName).collect(Collectors.toSet()));
    }
}

