/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.query.util.AbstractSqlVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithToSubQueryTransformer
implements IQueryTransformer {
    private static final Logger logger = LoggerFactory.getLogger(WithToSubQueryTransformer.class);

    @Override
    public String transform(String originSql, String project, String defaultSchema) {
        KylinConfigExt kylinConfig = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).getConfig();
        if (!kylinConfig.enableReplaceDynamicParams()) {
            return originSql;
        }
        try {
            SqlWithMatcher matcher = new SqlWithMatcher(originSql);
            SqlNode sqlNode = this.getSqlNode(originSql);
            sqlNode.accept((SqlVisitor)matcher);
            if (matcher.isHasSqlWith()) {
                return this.transformSqlWith(originSql, matcher.sqlWithPositions);
            }
            return originSql;
        }
        catch (Exception e) {
            logger.error("Something unexpected while transform with to SubQuery, return original query", (Throwable)e);
            return originSql;
        }
    }

    private String transformSqlWith(String originSql, Map<Pair<Integer, Integer>, SqlWith> sqlWithPositions) throws SqlParseException {
        SqlNode sqlNode = this.getSqlNode(originSql);
        Map<String, String> aliasToSubQueryMap = this.parseSqlWithTableAliasMap(sqlWithPositions);
        String replacedSql = this.replaceTableAliasToSubQueryInSql(originSql, sqlNode, aliasToSubQueryMap);
        String correctSql = this.subSqlWithListInReplacedSql(replacedSql);
        return this.normSql(this.getSqlNode(correctSql).toString());
    }

    private Map<String, String> parseSqlWithTableAliasMap(Map<Pair<Integer, Integer>, SqlWith> sqlWithPositions) throws SqlParseException {
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        TreeSet<Pair> sortedPositions = new TreeSet<Pair>(Comparator.comparingInt(Pair::getFirst));
        sortedPositions.addAll(sqlWithPositions.keySet());
        for (Pair pos : sortedPositions) {
            SqlWith sqlWith = sqlWithPositions.get(pos);
            this.parseSqlWithAliasMapImpl(sqlWith, aliasMap);
        }
        return aliasMap;
    }

    private void parseSqlWithAliasMapImpl(SqlWith sqlWith, Map<String, String> aliasMap) throws SqlParseException {
        List withList = sqlWith.withList.getList();
        for (SqlNode withNode : withList) {
            SqlWithItem with = (SqlWithItem)withNode;
            String alias = with.name.toString();
            String subQuery = this.processSqlWithQueryItemIfNeeded(with.query.toString(), aliasMap);
            aliasMap.put(alias, subQuery);
        }
    }

    private String processSqlWithQueryItemIfNeeded(String query, Map<String, String> aliasMap) throws SqlParseException {
        SqlNode sqlNode = this.getSqlNode(this.normSql(query));
        return this.replaceTableAliasToSubQueryInSql(this.normSql(query), sqlNode, aliasMap);
    }

    private String replaceTableAliasToSubQueryInSql(String sql, SqlNode sqlNode, Map<String, String> aliasToSubQueryMap) {
        SqlWithAliasPositionFinder positionFinder = new SqlWithAliasPositionFinder(aliasToSubQueryMap, sql);
        sqlNode.accept((SqlVisitor)positionFinder);
        Map<Pair<Integer, Integer>, SqlIdentifier> positions = positionFinder.getPositions();
        TreeSet<Pair<Integer, Integer>> sortedPositions = new TreeSet<Pair<Integer, Integer>>((o1, o2) -> (Integer)o2.getFirst() - (Integer)o1.getFirst());
        sortedPositions.addAll(positions.keySet());
        for (Pair pair : sortedPositions) {
            SqlIdentifier sqlIdentifier = positions.get(pair);
            String queryToReplace = aliasToSubQueryMap.get(sqlIdentifier.toString());
            sql = this.replace(sql, (Integer)pair.getFirst(), (Integer)pair.getSecond(), queryToReplace, sqlIdentifier.toString());
        }
        return this.normSql(sql);
    }

    private String replace(String sql, int start, int end, String query, String aliasName) {
        String newSql = sql.substring(0, start - 1) + "\n(" + query + ") as " + aliasName + "\n" + sql.substring(end);
        return this.normSql(newSql);
    }

    private String subSqlWithListInReplacedSql(String sql) throws SqlParseException {
        SqlWithMatcher matcher = new SqlWithMatcher(sql);
        SqlNode sqlNode = this.getSqlNode(sql);
        sqlNode.accept((SqlVisitor)matcher);
        Set<Pair<Integer, Integer>> positionsSet = matcher.getSqlWithListPositions();
        ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>(positionsSet);
        positions.sort((o1, o2) -> (Integer)o2.getFirst() - (Integer)o1.getFirst());
        for (Pair pair : positions) {
            sql = this.subSqlWithInSql(sql, (Integer)pair.getFirst(), (Integer)pair.getSecond());
        }
        return sql;
    }

    private String subSqlWithInSql(String sql, int start, int end) {
        String newSql = sql.substring(0, start) + sql.substring(end);
        return this.normSql(newSql);
    }

    private SqlNode getSqlNode(String sql) throws SqlParseException {
        return CalciteParser.parse((String)sql);
    }

    private String normSql(String sql) {
        return sql.replace("`", "");
    }

    static class SqlWithAliasPositionFinder
    extends AbstractSqlVisitor {
        Map<String, String> aliasToSubQueryMap;
        private Map<Pair<Integer, Integer>, SqlIdentifier> positions = new LinkedHashMap<Pair<Integer, Integer>, SqlIdentifier>();

        public SqlWithAliasPositionFinder(Map<String, String> aliasToSubQueryMap, String originSql) {
            super(originSql);
            this.aliasToSubQueryMap = aliasToSubQueryMap;
        }

        @Override
        public void visitInSqlFrom(SqlNode from) {
            if (from instanceof SqlWith) {
                this.sqlWithFound((SqlWith)from);
            } else if (SqlWithAliasPositionFinder.isAs(from)) {
                this.visitInAsNode((SqlBasicCall)from);
            } else if (from instanceof SqlJoin) {
                SqlJoin join = (SqlJoin)from;
                this.visitInSqlJoin(join);
            } else if (from instanceof SqlIdentifier) {
                SqlIdentifier ide = (SqlIdentifier)from;
                this.parseSqlIdentifierPosition(ide);
            } else {
                from.accept((SqlVisitor)this);
            }
        }

        @Override
        public void visitInSqlNode(SqlNode node) {
            if (node == null) {
                return;
            }
            if (node instanceof SqlIdentifier) {
                this.parseSqlIdentifierPosition((SqlIdentifier)node);
            } else if (node instanceof SqlWith) {
                this.sqlWithFound((SqlWith)node);
            } else if (node instanceof SqlNodeList) {
                this.visitInSqlNodeList((SqlNodeList)node);
            } else if (node instanceof SqlCase) {
                this.visitInSqlCase((SqlCase)node);
            } else if (SqlWithAliasPositionFinder.isSqlBasicCall(node)) {
                this.visitInSqlBasicCall((SqlBasicCall)node);
            } else {
                node.accept((SqlVisitor)this);
            }
        }

        private void parseSqlIdentifierPosition(SqlIdentifier identifier) {
            if (this.aliasToSubQueryMap.containsKey(identifier.toString())) {
                Pair pos = CalciteParser.getReplacePos((SqlNode)identifier, (String)this.originSql);
                this.positions.put((Pair<Integer, Integer>)pos, identifier);
            }
        }

        public Map<Pair<Integer, Integer>, SqlIdentifier> getPositions() {
            return this.positions;
        }
    }

    static class SqlWithMatcher
    extends AbstractSqlVisitor {
        private boolean hasSqlWith = false;
        private Set<Pair<Integer, Integer>> sqlWithListPositions = new LinkedHashSet<Pair<Integer, Integer>>();
        private Set<Pair<Integer, Integer>> questionMarkPositions = new LinkedHashSet<Pair<Integer, Integer>>();
        private Map<Pair<Integer, Integer>, SqlWith> sqlWithPositions = new HashMap<Pair<Integer, Integer>, SqlWith>();

        public SqlWithMatcher(String originSql) {
            super(originSql);
        }

        @Override
        public void questionMarkFound(SqlDynamicParam questionMark) {
            Pair pos = CalciteParser.getReplacePos((SqlNode)questionMark, (String)this.originSql);
            this.questionMarkPositions.add((Pair<Integer, Integer>)pos);
        }

        @Override
        public void sqlWithFound(SqlWith sqlWith) {
            Pair withPos = CalciteParser.getReplacePos((SqlNode)sqlWith, (String)this.originSql);
            this.sqlWithPositions.put((Pair<Integer, Integer>)withPos, sqlWith);
            Pair withListPos = CalciteParser.getReplacePos((SqlNode)sqlWith.withList, (String)this.originSql);
            Pair bodyPos = CalciteParser.getReplacePos((SqlNode)sqlWith.body, (String)this.originSql);
            this.sqlWithListPositions.add((Pair<Integer, Integer>)new Pair(withListPos.getFirst(), bodyPos.getFirst()));
            this.visitInSqlWithList(sqlWith.withList);
            this.hasSqlWith = true;
            SqlNode sqlWithQuery = sqlWith.body;
            sqlWithQuery.accept((SqlVisitor)this);
        }

        public boolean isHasSqlWith() {
            return this.hasSqlWith;
        }

        public Set<Pair<Integer, Integer>> getSqlWithListPositions() {
            return this.sqlWithListPositions;
        }
    }
}

