/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.GRPCAction;
import io.fabric8.kubernetes.api.model.GRPCActionFluent;
import io.fabric8.kubernetes.api.model.GRPCActionFluentImpl;
import java.util.Objects;

public class GRPCActionBuilder
extends GRPCActionFluentImpl<GRPCActionBuilder>
implements VisitableBuilder<GRPCAction, GRPCActionBuilder> {
    GRPCActionFluent<?> fluent;
    Boolean validationEnabled;

    public GRPCActionBuilder() {
        this(false);
    }

    public GRPCActionBuilder(Boolean validationEnabled) {
        this(new GRPCAction(), validationEnabled);
    }

    public GRPCActionBuilder(GRPCActionFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public GRPCActionBuilder(GRPCActionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new GRPCAction(), validationEnabled);
    }

    public GRPCActionBuilder(GRPCActionFluent<?> fluent, GRPCAction instance) {
        this(fluent, instance, false);
    }

    public GRPCActionBuilder(GRPCActionFluent<?> fluent, GRPCAction instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPort(instance.getPort());
        fluent.withService(instance.getService());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public GRPCActionBuilder(GRPCAction instance) {
        this(instance, (Boolean)false);
    }

    public GRPCActionBuilder(GRPCAction instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPort(instance.getPort());
        this.withService(instance.getService());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public GRPCAction build() {
        GRPCAction buildable = new GRPCAction(this.fluent.getPort(), this.fluent.getService());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GRPCActionBuilder that = (GRPCActionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

