/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.ConditionBuilder;
import io.fabric8.kubernetes.api.model.ConditionFluentImpl;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceStatus;
import io.fabric8.kubernetes.api.model.ServiceStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceStatusFluentImpl<A extends ServiceStatusFluent<A>>
extends BaseFluent<A>
implements ServiceStatusFluent<A> {
    private List<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
    private LoadBalancerStatusBuilder loadBalancer;
    private Map<String, Object> additionalProperties;

    public ServiceStatusFluentImpl() {
    }

    public ServiceStatusFluentImpl(ServiceStatus instance) {
        this.withConditions(instance.getConditions());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Condition> getConditions() {
        return ServiceStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<Condition> buildConditions() {
        return ServiceStatusFluentImpl.build(this.conditions);
    }

    @Override
    public Condition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<ConditionBuilder>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public ServiceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ServiceStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ServiceStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ServiceStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ServiceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ServiceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ServiceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public LoadBalancerStatus getLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    @Override
    public LoadBalancerStatus buildLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    @Override
    public A withLoadBalancer(LoadBalancerStatus loadBalancer) {
        this._visitables.get("loadBalancer").remove(this.loadBalancer);
        if (loadBalancer != null) {
            this.loadBalancer = new LoadBalancerStatusBuilder(loadBalancer);
            this._visitables.get("loadBalancer").add(this.loadBalancer);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    @Override
    public ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNestedImpl();
    }

    @Override
    public ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStatus item) {
        return new LoadBalancerNestedImpl(item);
    }

    @Override
    public ServiceStatusFluent.LoadBalancerNested<A> editLoadBalancer() {
        return this.withNewLoadBalancerLike(this.getLoadBalancer());
    }

    @Override
    public ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancer() {
        return this.withNewLoadBalancerLike(this.getLoadBalancer() != null ? this.getLoadBalancer() : new LoadBalancerStatusBuilder().build());
    }

    @Override
    public ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerStatus item) {
        return this.withNewLoadBalancerLike(this.getLoadBalancer() != null ? this.getLoadBalancer() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceStatusFluentImpl that = (ServiceStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.loadBalancer, this.additionalProperties, super.hashCode());
    }

    public class LoadBalancerNestedImpl<N>
    extends LoadBalancerStatusFluentImpl<ServiceStatusFluent.LoadBalancerNested<N>>
    implements ServiceStatusFluent.LoadBalancerNested<N>,
    Nested<N> {
        LoadBalancerStatusBuilder builder;

        LoadBalancerNestedImpl(LoadBalancerStatus item) {
            this.builder = new LoadBalancerStatusBuilder(this, item);
        }

        LoadBalancerNestedImpl() {
            this.builder = new LoadBalancerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceStatusFluentImpl.this.withLoadBalancer(this.builder.build());
        }

        @Override
        public N endLoadBalancer() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends ConditionFluentImpl<ServiceStatusFluent.ConditionsNested<N>>
    implements ServiceStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

