/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import org.apache.gluten.memory.SimpleMemoryUsageRecorder;
import org.apache.gluten.memory.memtarget.KnownNameAndStats;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetUtil;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.gluten.proto.MemoryUsageStats;

public class NoopMemoryTarget
implements MemoryTarget,
KnownNameAndStats {
    private final SimpleMemoryUsageRecorder recorder = new SimpleMemoryUsageRecorder();
    private final String name = MemoryTargetUtil.toUniqueName("Noop");

    @Override
    public long borrow(long size) {
        this.recorder.inc(size);
        return size;
    }

    @Override
    public long repay(long size) {
        this.recorder.inc(-size);
        return size;
    }

    @Override
    public long usedBytes() {
        return this.recorder.current();
    }

    @Override
    public <T> T accept(MemoryTargetVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public MemoryUsageStats stats() {
        return this.recorder.toStats();
    }
}

