/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.mask;

import org.apache.calcite.rel.RelNode;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.query.mask.CompositeQueryResultMasks;
import org.apache.kylin.query.mask.QueryDependentColumnMask;
import org.apache.kylin.query.mask.QueryResultMask;
import org.apache.kylin.query.mask.QuerySensitiveDataMask;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public final class QueryResultMasks {
    public static final ThreadLocal<QueryResultMask> THREAD_LOCAL = new ThreadLocal();

    private QueryResultMasks() {
    }

    public static void init(String project, KylinConfig kylinConfig) {
        THREAD_LOCAL.set(new CompositeQueryResultMasks(new QueryDependentColumnMask(project, kylinConfig), new QuerySensitiveDataMask(project, kylinConfig)));
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    public static Dataset<Row> maskResult(Dataset<Row> df) {
        if (THREAD_LOCAL.get() == null) {
            return df;
        }
        return THREAD_LOCAL.get().doMaskResult(df);
    }

    public static void setRootRelNode(RelNode relNode) {
        if (THREAD_LOCAL.get() != null) {
            THREAD_LOCAL.get().doSetRootRelNode(relNode);
        }
    }
}

