/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.pushdown;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.query.StructField;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.query.pushdown.PushdownResponse;
import org.apache.kylin.query.pushdown.SparkSubmitter;
import org.apache.kylin.source.adhocquery.IPushDownRunner;
import org.apache.kylin.source.adhocquery.PushdownResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDownRunnerSparkImpl
implements IPushDownRunner {
    public static final Logger logger = LoggerFactory.getLogger(PushDownRunnerSparkImpl.class);

    public void init(KylinConfig config) {
    }

    public void init(KylinConfig config, String project) {
        this.init(config);
    }

    public void executeQuery(String query, List<List<String>> results, List<SelectedColumnMeta> columnMetas, String project) throws SQLException {
        PushdownResult response = this.executeQueryToIterator(query, project);
        response.getRows().forEach(results::add);
        columnMetas.addAll(response.getColumnMetas());
    }

    public PushdownResult executeQueryToIterator(String query, String project) {
        PushdownResponse response = this.queryWithPushDown(query, project);
        int columnCount = response.getColumns().size();
        List<StructField> fieldList = response.getColumns();
        LinkedList<SelectedColumnMeta> columnMetas = new LinkedList<SelectedColumnMeta>();
        for (int i = 0; i < columnCount; ++i) {
            int nullable = fieldList.get(i).isNullable() ? 1 : 0;
            columnMetas.add(new SelectedColumnMeta(false, false, false, false, nullable, true, Integer.MAX_VALUE, fieldList.get(i).getName(), fieldList.get(i).getName(), null, null, null, fieldList.get(i).getPrecision(), fieldList.get(i).getScale(), fieldList.get(i).getDataType(), fieldList.get(i).getDataTypeName(), false, false, false));
        }
        return new PushdownResult(response.getRows(), response.getSize(), columnMetas);
    }

    public void executeUpdate(String sql, String project) {
        this.queryWithPushDown(sql, project);
    }

    private PushdownResponse queryWithPushDown(String sql, String project) {
        return SparkSubmitter.getInstance().submitPushDownTask(sql, project);
    }

    public String getName() {
        return "HIVE";
    }
}

