/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ddl;

import java.util.Set;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apache.spark.ddl.DDLConstant;

public class DDLCheckContext {
    public static final int LOGICAL_VIEW_CREATE_COMMAND = 2;
    public static final int LOGICAL_VIEW_DROP_COMMAND = 3;
    public static final int HIVE_COMMAND = 1;
    private String sql;
    private String project;
    private String userName;
    private Set<String> groups;
    private boolean kerberosEnv;
    private String commandType = "hive";
    private String logicalViewName;
    private String restrict;

    public DDLCheckContext(String sql, String project, String restrict, String userName, Set<String> groups, boolean kerberosEnv) {
        this.sql = sql;
        this.project = project;
        this.restrict = restrict;
        this.userName = userName;
        this.groups = groups;
        this.kerberosEnv = kerberosEnv;
    }

    public String getSql() {
        return this.sql;
    }

    public String getLogicalViewPersistSql() {
        String trimmedSql;
        Matcher matcher;
        if (this.isLogicalViewCommand() && (matcher = DDLConstant.LOGICAL_VIEW_DDL_CREATE_OR_REPLACE_SYNTAX.matcher(trimmedSql = this.sql.trim())).find()) {
            return matcher.replaceFirst("CREATE LOGICAL VIEW ");
        }
        return this.sql;
    }

    public String getProject() {
        return this.project;
    }

    public String getUserName() {
        return this.userName;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public boolean isLogicalViewCommand() {
        return this.commandType.equals("replaceLogicalView") || this.commandType.equals("createLogicalView") || this.commandType.equals("dropLogicalView");
    }

    public boolean isHiveCommand() {
        return this.commandType.equals("hive");
    }

    @Generated
    public boolean isKerberosEnv() {
        return this.kerberosEnv;
    }

    @Generated
    public String getCommandType() {
        return this.commandType;
    }

    @Generated
    public String getLogicalViewName() {
        return this.logicalViewName;
    }

    @Generated
    public String getRestrict() {
        return this.restrict;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setKerberosEnv(boolean kerberosEnv) {
        this.kerberosEnv = kerberosEnv;
    }

    @Generated
    public void setCommandType(String commandType) {
        this.commandType = commandType;
    }

    @Generated
    public void setLogicalViewName(String logicalViewName) {
        this.logicalViewName = logicalViewName;
    }

    @Generated
    public void setRestrict(String restrict) {
        this.restrict = restrict;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DDLCheckContext)) {
            return false;
        }
        DDLCheckContext other = (DDLCheckContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        Set<String> this$groups = this.getGroups();
        Set<String> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        if (this.isKerberosEnv() != other.isKerberosEnv()) {
            return false;
        }
        String this$commandType = this.getCommandType();
        String other$commandType = other.getCommandType();
        if (this$commandType == null ? other$commandType != null : !this$commandType.equals(other$commandType)) {
            return false;
        }
        String this$logicalViewName = this.getLogicalViewName();
        String other$logicalViewName = other.getLogicalViewName();
        if (this$logicalViewName == null ? other$logicalViewName != null : !this$logicalViewName.equals(other$logicalViewName)) {
            return false;
        }
        String this$restrict = this.getRestrict();
        String other$restrict = other.getRestrict();
        return !(this$restrict == null ? other$restrict != null : !this$restrict.equals(other$restrict));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DDLCheckContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        Set<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        result = result * 59 + (this.isKerberosEnv() ? 79 : 97);
        String $commandType = this.getCommandType();
        result = result * 59 + ($commandType == null ? 43 : $commandType.hashCode());
        String $logicalViewName = this.getLogicalViewName();
        result = result * 59 + ($logicalViewName == null ? 43 : $logicalViewName.hashCode());
        String $restrict = this.getRestrict();
        result = result * 59 + ($restrict == null ? 43 : $restrict.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DDLCheckContext(sql=" + this.getSql() + ", project=" + this.getProject() + ", userName=" + this.getUserName() + ", groups=" + this.getGroups() + ", kerberosEnv=" + this.isKerberosEnv() + ", commandType=" + this.getCommandType() + ", logicalViewName=" + this.getLogicalViewName() + ", restrict=" + this.getRestrict() + ")";
    }
}

