/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.controller.NIndexPlanController;
import org.apache.kylin.rest.request.OpenUpdateRuleBasedCuboidRequest;
import org.apache.kylin.rest.request.UpdateRuleBasedCuboidRequest;
import org.apache.kylin.rest.response.DiffRuleBasedIndexResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.OpenAddAggGroupResponse;
import org.apache.kylin.rest.service.FusionIndexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/index_plans"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenIndexPlanController
extends NBasicController {
    private static final String MODEL_ALIAS = "model";
    private static final String MODEL_NAME = "model_name";
    private static final String AGGREGATION_GROUPS = "aggregation_groups";
    @Autowired
    @Qualifier(value="fusionIndexService")
    private FusionIndexService fusionIndexService;
    @Autowired
    NIndexPlanController indexPlanController;

    @PutMapping(value={"/agg_groups"})
    public EnvelopeResponse<OpenAddAggGroupResponse> updateRule(@RequestBody OpenUpdateRuleBasedCuboidRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        this.checkRequiredArg(MODEL_ALIAS, request.getModelAlias());
        this.checkListRequiredArg(AGGREGATION_GROUPS, request.getAggregationGroups());
        request.setProject(projectName);
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)projectName);
        NDataModel model = modelManager.getDataModelDescByAlias(request.getModelAlias());
        if (model == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NOT_EXIST, new Object[0]);
        }
        UpdateRuleBasedCuboidRequest internalRequest = this.fusionIndexService.convertOpenToInternal(request, model);
        EnvelopeResponse<DiffRuleBasedIndexResponse> response = this.indexPlanController.calculateDiffRuleBasedIndex(internalRequest);
        this.indexPlanController.updateRule(internalRequest);
        return this.convertResponse(response);
    }

    @ApiOperation(value="batch deleteIndex", tags={"AI"})
    @DeleteMapping(value={"/index"})
    public EnvelopeResponse<String> batchDeleteIndex(@RequestParam(value="index_ids") Set<Long> layoutIds, @RequestParam(value="project") String project, @RequestParam(value="model_name") String modelName, @RequestParam(value="index_range", required=false) IndexEntity.Range indexRange) {
        NDataModel dataModel;
        this.checkProjectName(project);
        this.checkRequiredArg(MODEL_NAME, modelName);
        this.checkCollectionRequiredArg("index_ids", layoutIds);
        if (null == indexRange) {
            indexRange = IndexEntity.Range.BATCH;
        }
        if (null == (dataModel = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataModelDescByAlias(modelName))) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NOT_EXIST, new Object[0]);
        }
        this.fusionIndexService.batchRemoveIndex(project, dataModel.getUuid(), layoutIds, indexRange);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    private EnvelopeResponse<OpenAddAggGroupResponse> convertResponse(EnvelopeResponse<DiffRuleBasedIndexResponse> internal) {
        if (internal != null && internal.getData() != null) {
            OpenAddAggGroupResponse response = new OpenAddAggGroupResponse(((DiffRuleBasedIndexResponse)internal.getData()).getDecreaseLayouts(), ((DiffRuleBasedIndexResponse)internal.getData()).getIncreaseLayouts(), ((DiffRuleBasedIndexResponse)internal.getData()).getRollbackLayouts());
            return new EnvelopeResponse("000", (Object)response, "");
        }
        return new EnvelopeResponse("000", null, "");
    }
}

