/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.findfile;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jodd.inex.InExRuleMatcher;
import jodd.inex.InExRules;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.IOUtil;
import jodd.io.ZipUtil;
import jodd.io.findfile.FindFile;
import jodd.io.findfile.FindFileException;
import jodd.util.ArraysUtil;
import jodd.util.ClassLoaderUtil;
import jodd.util.ClassPathUtil;
import jodd.util.Consumers;
import jodd.util.StringUtil;

public class ClassScanner {
    private static final String CLASS_FILE_EXT = ".class";
    private static final String JAR_FILE_EXT = ".jar";
    protected static final String[] SYSTEM_JARS = new String[]{"**/jre/lib/*.jar", "**/jre/lib/ext/*.jar", "**/Java/Extensions/*.jar", "**/Classes/*.jar"};
    protected static final String[] COMMONLY_EXCLUDED_JARS = new String[]{"**/tomcat*", "**/jetty*", "**/javafx*", "**/junit*", "**/javax*", "**/org.eclipse.*", "**/ant*", "**/idea_rt.jar"};
    protected final InExRules<String, String, String> rulesJars;
    protected static final String[] COMMONLY_EXCLUDED_ENTRIES = new String[]{"java.*", "ch.qos.logback.*", "sun.*", "com.sun.*", "org.eclipse.*"};
    protected final InExRules<String, String, String> rulesEntries;
    protected boolean detectEntriesMode = false;
    protected boolean includeResources;
    protected boolean ignoreException;
    private final Consumers<ClassPathEntry> entryDataConsumers = Consumers.empty();
    private final Set<File> filesToScan = new LinkedHashSet<File>();

    public static ClassScanner create() {
        return new ClassScanner();
    }

    public ClassScanner() {
        this.rulesJars = new InExRules(InExRuleMatcher.WILDCARD_PATH_RULE_MATCHER);
        this.rulesEntries = new InExRules(InExRuleMatcher.WILDCARD_RULE_MATCHER);
        this.excludeJars(SYSTEM_JARS);
    }

    public ClassScanner excludeJars(String ... excludedJars) {
        for (String excludedJar : excludedJars) {
            this.rulesJars.exclude(excludedJar);
        }
        return this;
    }

    public ClassScanner excludeCommonJars() {
        return this.excludeJars(COMMONLY_EXCLUDED_JARS);
    }

    public ClassScanner includeJars(String ... includedJars) {
        for (String includedJar : includedJars) {
            this.rulesJars.include(includedJar);
        }
        return this;
    }

    public ClassScanner includeAllJars(boolean blacklist) {
        if (blacklist) {
            this.rulesJars.blacklist();
        } else {
            this.rulesJars.whitelist();
        }
        return this;
    }

    public ClassScanner excludeAllJars(boolean whitelist) {
        if (whitelist) {
            this.rulesJars.whitelist();
        } else {
            this.rulesJars.blacklist();
        }
        return this;
    }

    public ClassScanner includeEntries(String ... includedEntries) {
        for (String includedEntry : includedEntries) {
            this.rulesEntries.include(includedEntry);
        }
        return this;
    }

    public ClassScanner includeAllEntries(boolean blacklist) {
        if (blacklist) {
            this.rulesEntries.blacklist();
        } else {
            this.rulesEntries.whitelist();
        }
        return this;
    }

    public ClassScanner excludeAllEntries(boolean whitelist) {
        if (whitelist) {
            this.rulesEntries.whitelist();
        } else {
            this.rulesEntries.blacklist();
        }
        return this;
    }

    public ClassScanner excludeEntries(String ... excludedEntries) {
        for (String excludedEntry : excludedEntries) {
            this.rulesEntries.exclude(excludedEntry);
        }
        return this;
    }

    public ClassScanner excludeCommonEntries() {
        return this.excludeEntries(COMMONLY_EXCLUDED_ENTRIES);
    }

    public ClassScanner detectEntriesMode(boolean detectMode) {
        this.detectEntriesMode = detectMode;
        return this;
    }

    public ClassScanner includeResources(boolean includeResources) {
        this.includeResources = includeResources;
        return this;
    }

    public ClassScanner ignoreException(boolean ignoreException) {
        this.ignoreException = ignoreException;
        return this;
    }

    protected boolean acceptJar(File jarFile) {
        String path = jarFile.getAbsolutePath();
        path = FileNameUtil.separatorsToUnix((String)path);
        return this.rulesJars.match(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanJarFile(File file) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException ioex) {
            if (!this.ignoreException) {
                throw new FindFileException("Invalid zip: " + file.getName(), ioex);
            }
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String zipEntryName = zipEntry.getName();
            try {
                ClassPathEntry classPathEntry;
                String entryName;
                if (StringUtil.endsWithIgnoreCase((String)zipEntryName, (String)CLASS_FILE_EXT)) {
                    entryName = this.prepareEntryName(zipEntryName, true);
                    classPathEntry = new ClassPathEntry(entryName, zipFile, zipEntry);
                    try {
                        this.scanEntry(classPathEntry);
                        continue;
                    }
                    finally {
                        classPathEntry.closeInputStream();
                        continue;
                    }
                }
                if (!this.includeResources) continue;
                entryName = this.prepareEntryName(zipEntryName, false);
                classPathEntry = new ClassPathEntry(entryName, zipFile, zipEntry);
                try {
                    this.scanEntry(classPathEntry);
                }
                finally {
                    classPathEntry.closeInputStream();
                }
            }
            catch (RuntimeException rex) {
                if (this.ignoreException) continue;
                ZipUtil.close((ZipFile)zipFile);
                throw rex;
            }
        }
        ZipUtil.close((ZipFile)zipFile);
    }

    protected void scanClassPath(File root) {
        File file;
        String rootPath = root.getAbsolutePath();
        if (!rootPath.endsWith(File.separator)) {
            rootPath = rootPath + File.separatorChar;
        }
        FindFile ff = FindFile.create().includeDirs(false).recursive(true).searchPath(rootPath);
        while ((file = ff.nextFile()) != null) {
            String filePath = file.getAbsolutePath();
            try {
                if (StringUtil.endsWithIgnoreCase((String)filePath, (String)CLASS_FILE_EXT)) {
                    this.scanClassFile(filePath, rootPath, file, true);
                    continue;
                }
                if (!this.includeResources) continue;
                this.scanClassFile(filePath, rootPath, file, false);
            }
            catch (RuntimeException rex) {
                if (this.ignoreException) continue;
                throw rex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanClassFile(String filePath, String rootPath, File file, boolean isClass) {
        if (StringUtil.startsWithIgnoreCase((String)filePath, (String)rootPath)) {
            String entryName = this.prepareEntryName(filePath.substring(rootPath.length()), isClass);
            ClassPathEntry classPathEntry = new ClassPathEntry(entryName, file);
            try {
                this.scanEntry(classPathEntry);
            }
            finally {
                classPathEntry.closeInputStream();
            }
        }
    }

    protected String prepareEntryName(String name, boolean isClass) {
        String entryName = name;
        if (isClass) {
            entryName = name.substring(0, name.length() - 6);
            entryName = StringUtil.replaceChar((String)entryName, (char)'/', (char)'.');
            entryName = StringUtil.replaceChar((String)entryName, (char)'\\', (char)'.');
        } else {
            entryName = '/' + StringUtil.replaceChar((String)entryName, (char)'\\', (char)'/');
        }
        return entryName;
    }

    protected boolean acceptEntry(String entryName) {
        return this.rulesEntries.match(entryName);
    }

    protected void scanEntry(ClassPathEntry classPathEntry) {
        if (!this.acceptEntry(classPathEntry.name())) {
            return;
        }
        try {
            this.onEntry(classPathEntry);
        }
        catch (Exception ex) {
            throw new FindFileException("Scan entry error: " + classPathEntry, ex);
        }
    }

    public ClassScanner registerEntryConsumer(Consumer<ClassPathEntry> entryDataConsumer) {
        this.entryDataConsumers.add(entryDataConsumer);
        return this;
    }

    protected void onEntry(ClassPathEntry classPathEntry) {
        this.entryDataConsumers.accept(classPathEntry);
    }

    public static byte[] bytecodeSignatureOfType(Class type) {
        String name = 'L' + type.getName().replace('.', '/') + ';';
        return name.getBytes();
    }

    public ClassScanner scan(URL ... urls) {
        for (URL url : urls) {
            File file = FileUtil.toContainerFile((URL)url);
            if (file == null) {
                if (this.ignoreException) continue;
                throw new FindFileException("URL is not a valid file: " + url);
            }
            this.filesToScan.add(file);
        }
        return this;
    }

    public ClassScanner scanDefaultClasspath() {
        return this.scan(ClassPathUtil.getDefaultClasspath());
    }

    public ClassScanner scan(File ... paths) {
        this.filesToScan.addAll(Arrays.asList(paths));
        return this;
    }

    public ClassScanner scan(String ... paths) {
        for (String path : paths) {
            this.filesToScan.add(new File(path));
        }
        return this;
    }

    public void start() {
        if (this.detectEntriesMode) {
            this.rulesEntries.detectMode();
        }
        this.filesToScan.forEach(file -> {
            String path = file.getAbsolutePath();
            if (StringUtil.endsWithIgnoreCase((String)path, (String)JAR_FILE_EXT)) {
                if (!this.acceptJar((File)file)) {
                    return;
                }
                this.scanJarFile((File)file);
            } else if (file.isDirectory()) {
                this.scanClassPath((File)file);
            }
        });
    }

    public class ClassPathEntry {
        private final File file;
        private final ZipFile zipFile;
        private final ZipEntry zipEntry;
        private final String name;
        private InputStream inputStream;
        private byte[] inputStreamBytes;

        ClassPathEntry(String name, ZipFile zipFile, ZipEntry zipEntry) {
            this.name = name;
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
            this.file = null;
            this.inputStream = null;
        }

        ClassPathEntry(String name, File file) {
            this.name = name;
            this.file = file;
            this.zipEntry = null;
            this.zipFile = null;
            this.inputStream = null;
        }

        public String name() {
            return this.name;
        }

        public boolean isArchive() {
            return this.zipFile != null;
        }

        public String archiveName() {
            if (this.zipFile != null) {
                return this.zipFile.getName();
            }
            return null;
        }

        public boolean isTypeSignatureInUse(byte[] bytes) {
            try {
                byte[] data = this.readBytes();
                int index = ArraysUtil.indexOf((byte[])data, (byte[])bytes);
                return index != -1;
            }
            catch (IOException ioex) {
                throw new FindFileException("Read error", ioex);
            }
        }

        public byte[] readBytes() throws IOException {
            this.openInputStream();
            if (this.inputStreamBytes == null) {
                this.inputStreamBytes = IOUtil.readBytes((InputStream)this.inputStream);
            }
            return this.inputStreamBytes;
        }

        public InputStream openInputStream() {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            if (this.zipFile != null && this.zipEntry != null) {
                try {
                    this.inputStream = this.zipFile.getInputStream(this.zipEntry);
                    return this.inputStream;
                }
                catch (IOException ioex) {
                    throw new FindFileException("Input stream error: '" + this.zipFile.getName() + "', entry: '" + this.zipEntry.getName() + "'.", ioex);
                }
            }
            if (this.file != null) {
                try {
                    this.inputStream = new FileInputStream(this.file);
                    return this.inputStream;
                }
                catch (FileNotFoundException fnfex) {
                    throw new FindFileException("Unable to open: " + this.file.getAbsolutePath(), fnfex);
                }
            }
            throw new FindFileException("Unable to open stream: " + this.name());
        }

        public void closeInputStream() {
            if (this.inputStream == null) {
                return;
            }
            IOUtil.close((Closeable)this.inputStream);
            this.inputStream = null;
            this.inputStreamBytes = null;
        }

        public Class loadClass() throws ClassNotFoundException {
            try {
                return ClassLoaderUtil.loadClass((String)this.name);
            }
            catch (ClassNotFoundException | Error cnfex) {
                if (ClassScanner.this.ignoreException) {
                    return null;
                }
                throw cnfex;
            }
        }

        public String toString() {
            return "ClassPathEntry{" + this.name + '\'' + '}';
        }
    }
}

