/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;

public class Constant<T>
implements BindableColumn<T> {
    private final String alias;
    private final String value;

    private Constant(String value) {
        this(value, null);
    }

    private Constant(String value, String alias) {
        this.value = Objects.requireNonNull(value);
        this.alias = alias;
    }

    @Override
    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public String renderWithTableAlias(TableAliasCalculator tableAliasCalculator) {
        return this.value;
    }

    @Override
    public Constant<T> as(String alias) {
        return new Constant<T>(this.value, alias);
    }

    public static <T> Constant<T> of(String value) {
        return new Constant<T>(value);
    }
}

