/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.function.AbstractUniTypeFunction;

public class OperatorFunction<T>
extends AbstractUniTypeFunction<T, OperatorFunction<T>> {
    protected final BasicColumn secondColumn;
    protected final List<BasicColumn> subsequentColumns = new ArrayList<BasicColumn>();
    private final String operator;

    protected OperatorFunction(String operator, BindableColumn<T> firstColumn, BasicColumn secondColumn, List<BasicColumn> subsequentColumns) {
        super(firstColumn);
        this.secondColumn = Objects.requireNonNull(secondColumn);
        this.subsequentColumns.addAll(subsequentColumns);
        this.operator = Objects.requireNonNull(operator);
    }

    @Override
    protected OperatorFunction<T> copy() {
        return new OperatorFunction<T>(this.operator, this.column, this.secondColumn, this.subsequentColumns);
    }

    @Override
    public String renderWithTableAlias(TableAliasCalculator tableAliasCalculator) {
        String paddedOperator = " " + this.operator + " ";
        return Stream.of(Stream.of(this.column), Stream.of(this.secondColumn), this.subsequentColumns.stream()).flatMap(Function.identity()).map(column -> column.renderWithTableAlias(tableAliasCalculator)).collect(Collectors.joining(paddedOperator, "(", ")"));
    }

    public static <T> OperatorFunction<T> of(String operator, BindableColumn<T> firstColumn, BasicColumn secondColumn, BasicColumn ... subsequentColumns) {
        return OperatorFunction.of(operator, firstColumn, secondColumn, Arrays.asList(subsequentColumns));
    }

    public static <T> OperatorFunction<T> of(String operator, BindableColumn<T> firstColumn, BasicColumn secondColumn, List<BasicColumn> subsequentColumns) {
        return new OperatorFunction<T>(operator, firstColumn, secondColumn, subsequentColumns);
    }
}

