/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FragmentAndParameters {
    private final String fragment;
    private final Map<String, Object> parameters;

    private FragmentAndParameters(Builder builder) {
        this.fragment = Objects.requireNonNull(builder.fragment);
        this.parameters = Objects.requireNonNull(builder.parameters);
    }

    public String fragment() {
        return this.fragment;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public static Builder withFragment(String fragment) {
        return new Builder().withFragment(fragment);
    }

    public static class Builder {
        private String fragment;
        private final Map<String, Object> parameters = new HashMap<String, Object>();

        public Builder withFragment(String fragment) {
            this.fragment = fragment;
            return this;
        }

        public Builder withParameter(String key, Object value) {
            this.parameters.put(key, value);
            return this;
        }

        public Builder withParameters(Map<String, Object> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        public FragmentAndParameters build() {
            return new FragmentAndParameters(this);
        }

        public Optional<FragmentAndParameters> buildOptional() {
            return Optional.of(this.build());
        }
    }
}

