/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.mybatis.dynamic.sql.AbstractSingleValueCondition;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsNotLikeCaseInsensitive
extends AbstractSingleValueCondition<String> {
    private static final IsNotLikeCaseInsensitive EMPTY = new IsNotLikeCaseInsensitive(null){

        @Override
        public boolean shouldRender() {
            return false;
        }
    };

    public static IsNotLikeCaseInsensitive empty() {
        return EMPTY;
    }

    protected IsNotLikeCaseInsensitive(String value) {
        super(value);
    }

    @Override
    public String renderCondition(String columnName, String placeholder) {
        return "upper(" + columnName + ") not like " + placeholder;
    }

    @Override
    public String value() {
        return StringUtilities.safelyUpperCase((String)super.value());
    }

    public static IsNotLikeCaseInsensitive of(String value) {
        return new IsNotLikeCaseInsensitive(value);
    }

    public IsNotLikeCaseInsensitive filter(Predicate<? super String> predicate) {
        return this.filterSupport(predicate, IsNotLikeCaseInsensitive::empty, this);
    }

    public IsNotLikeCaseInsensitive map(UnaryOperator<String> mapper) {
        return this.mapSupport(mapper, IsNotLikeCaseInsensitive::new, IsNotLikeCaseInsensitive::empty);
    }
}

