/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCostCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryCostCollector.class);
    public static final Cache<String, AtomicLong> QUERY_CPU_TIME_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public static void addQueryMetrics(String queryId, long cpuCost) {
        long start = System.currentTimeMillis();
        try {
            QueryCostCollector.addQueryCounter(queryId, cpuCost);
        }
        catch (Exception e) {
            log.error("Error when add query metrics.", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        if (end - start > 100L) {
            log.warn("QueryCost collector cost too much time: {} ms ", (Object)(end - start));
        }
    }

    private static void addQueryCounter(String queryId, long step) throws ExecutionException {
        AtomicLong totalBlocks = (AtomicLong)QUERY_CPU_TIME_CACHE.get((Object)queryId, () -> new AtomicLong(0L));
        totalBlocks.addAndGet(step);
    }

    public static long getAndCleanStatus(String queryId) {
        try {
            AtomicLong cpuTime = (AtomicLong)QUERY_CPU_TIME_CACHE.get((Object)queryId, () -> new AtomicLong(0L));
            QUERY_CPU_TIME_CACHE.invalidate((Object)queryId);
            return cpuTime.get();
        }
        catch (ExecutionException e) {
            log.error("Error when log query metrics.", (Throwable)e);
            return 0L;
        }
    }

    private QueryCostCollector() {
    }
}

