/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.spark.common.logging;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.spark.common.logging.AbstractHdfsLogAppender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="DriverHdfsRollingAppender", category="Core", elementType="appender", printObject=true)
public class SparkDriverHdfsRollingLogAppender
extends AbstractHdfsLogAppender {
    private static SparkDriverHdfsRollingLogAppender appender;
    private long rollingByteSize;
    private String logPath;
    private boolean kerberosEnabled = false;
    private String kerberosPrincipal;
    private String kerberosKeytab;

    protected SparkDriverHdfsRollingLogAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, Property[] properties, AbstractHdfsLogAppender.HdfsManager manager) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, manager);
    }

    @PluginFactory
    public static synchronized SparkDriverHdfsRollingLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="kerberosEnabled") boolean kerberosEnabled, @PluginAttribute(value="kerberosPrincipal") String kerberosPrincipal, @PluginAttribute(value="kerberosKeytab") String kerberosKeytab, @PluginAttribute(value="workingDir") String hdfsWorkingDir, @PluginAttribute(value="logPath") String logPath, @PluginAttribute(value="logQueueCapacity") int logQueueCapacity, @PluginAttribute(value="flushInterval") int flushInterval, @PluginAttribute(value="rollingByteSize") long rollingByteSize, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Properties") Property[] properties) {
        if (appender != null) {
            return appender;
        }
        AbstractHdfsLogAppender.HdfsManager manager = new AbstractHdfsLogAppender.HdfsManager(name, layout);
        appender = new SparkDriverHdfsRollingLogAppender(name, layout, filter, false, false, properties, manager);
        appender.setKerberosEnabled(kerberosEnabled);
        if (kerberosEnabled) {
            appender.setKerberosPrincipal(kerberosPrincipal);
            appender.setKerberosKeytab(kerberosKeytab);
        }
        appender.setWorkingDir(hdfsWorkingDir);
        appender.setLogPath(logPath.concat("_processing"));
        appender.setRollingByteSize(rollingByteSize);
        if (appender.getRollingByteSize() == 0L) {
            appender.setRollingByteSize(524288000L);
        }
        appender.setLogQueueCapacity(logQueueCapacity);
        appender.setFlushInterval(flushInterval);
        return appender;
    }

    @Override
    String getAppenderName() {
        return "SparkDriverHdfsRollingLogAppender";
    }

    @Override
    public void init() {
        StatusLogger.getLogger().warn("spark.driver.log4j.appender.hdfs.File -> {}", (Object)this.getLogPath());
        StatusLogger.getLogger().warn("kerberosEnable -> {}", (Object)this.isKerberosEnabled());
        if (this.isKerberosEnabled()) {
            StatusLogger.getLogger().warn("kerberosPrincipal -> {}", (Object)this.getKerberosPrincipal());
            StatusLogger.getLogger().warn("kerberosKeytab -> {}", (Object)this.getKerberosKeytab());
        }
    }

    @Override
    public boolean isSkipCheckAndFlushLog() {
        return false;
    }

    @Override
    public void doWriteLog(int eventSize, List<LogEvent> transaction) throws IOException, InterruptedException {
        if (this.needRollingFile(this.getLogPath(), this.getRollingByteSize())) {
            StatusLogger.getLogger().debug("current log file size > {}, need to rolling", (Object)this.getRollingByteSize());
            this.setLogPath(this.updateOutPutPath(this.getLogPath()));
        }
        if (!this.isWriterInited() && !this.initHdfsWriter(new Path(this.getLogPath()), new Configuration())) {
            StatusLogger.getLogger().error("init the hdfs writer failed!");
        }
        while (eventSize > 0) {
            LogEvent loggingEvent = this.getLogBufferQue().take();
            transaction.add(loggingEvent);
            this.writeLogEvent(loggingEvent);
            --eventSize;
        }
    }

    @Override
    String getLogPathAfterRolling(String logPath) {
        Path pathProcess = new Path(logPath);
        return String.format(Locale.ROOT, "%s/driver.%s.log_processing", pathProcess.getParent().toString(), System.currentTimeMillis());
    }

    @Override
    String getLogPathRollingDone(String logPath) {
        return StringUtils.replace((String)logPath, (String)"_processing", (String)"");
    }

    @Generated
    public void setRollingByteSize(long rollingByteSize) {
        this.rollingByteSize = rollingByteSize;
    }

    @Generated
    public long getRollingByteSize() {
        return this.rollingByteSize;
    }

    @Generated
    public String getLogPath() {
        return this.logPath;
    }

    @Generated
    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    @Generated
    public boolean isKerberosEnabled() {
        return this.kerberosEnabled;
    }

    @Generated
    public void setKerberosEnabled(boolean kerberosEnabled) {
        this.kerberosEnabled = kerberosEnabled;
    }

    @Generated
    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    @Generated
    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    @Generated
    public String getKerberosKeytab() {
        return this.kerberosKeytab;
    }

    @Generated
    public void setKerberosKeytab(String kerberosKeytab) {
        this.kerberosKeytab = kerberosKeytab;
    }
}

