/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.spark.common.logging;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.spark.common.logging.AbstractHdfsLogAppender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.spark.SparkEnv;
import org.apache.spark.utils.SparkHadoopUtils;

@Plugin(name="ExecutorHdfsAppender", category="Core", elementType="appender", printObject=true)
public class SparkExecutorHdfsLogAppender
extends AbstractHdfsLogAppender {
    private static final long A_DAY_MILLIS = 86400000L;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
    @VisibleForTesting
    String outputPath;
    @VisibleForTesting
    String executorId;
    @VisibleForTesting
    long startTime = 0L;
    @VisibleForTesting
    int rollingPeriod = 5;
    private String metadataId;
    private String category;
    private String identifier;
    private String jobName;
    private String project;

    protected SparkExecutorHdfsLogAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, Property[] properties, AbstractHdfsLogAppender.HdfsManager manager) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, manager);
    }

    @PluginFactory
    public static SparkExecutorHdfsLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="workingDir") String workingDir, @PluginAttribute(value="metadataId") String metadataId, @PluginAttribute(value="category") String category, @PluginAttribute(value="identifier") String identifier, @PluginAttribute(value="jobName") String jobName, @PluginAttribute(value="project") String project, @PluginAttribute(value="rollingPeriod") int rollingPeriod, @PluginAttribute(value="logQueueCapacity") int logQueueCapacity, @PluginAttribute(value="flushInterval") int flushInterval, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Properties") Property[] properties) {
        AbstractHdfsLogAppender.HdfsManager manager = new AbstractHdfsLogAppender.HdfsManager(name, layout);
        SparkExecutorHdfsLogAppender appender = new SparkExecutorHdfsLogAppender(name, layout, filter, false, false, properties, manager);
        appender.setWorkingDir(workingDir);
        appender.setMetadataId(metadataId);
        appender.setCategory(category);
        appender.setIdentifier(identifier);
        appender.setJobName(jobName);
        appender.setProject(project);
        appender.setRollingPeriod(rollingPeriod);
        appender.setLogQueueCapacity(logQueueCapacity);
        appender.setFlushInterval(flushInterval);
        return appender;
    }

    @Override
    void init() {
        StatusLogger.getLogger().warn("metadataIdentifier -> " + this.getMetadataId());
        StatusLogger.getLogger().warn("category -> " + this.getCategory());
        StatusLogger.getLogger().warn("identifier -> " + this.getIdentifier());
        if (null != this.getProject()) {
            StatusLogger.getLogger().warn("project -> " + this.getProject());
        }
        if (null != this.getJobName()) {
            StatusLogger.getLogger().warn("jobName -> " + this.getJobName());
        }
    }

    @Override
    String getAppenderName() {
        return "SparkExecutorHdfsLogAppender";
    }

    @Override
    boolean isSkipCheckAndFlushLog() {
        if (SparkEnv.get() == null && StringUtils.isBlank((CharSequence)this.executorId)) {
            StatusLogger.getLogger().warn("Waiting for spark executor to start");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                StatusLogger.getLogger().error("Waiting for spark executor starting is interrupted!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            return true;
        }
        return false;
    }

    @Override
    void doWriteLog(int size, List<LogEvent> transaction) throws IOException, InterruptedException {
        while (size > 0) {
            LogEvent loggingEvent = this.getLogBufferQue().take();
            if (this.isTimeChanged(loggingEvent)) {
                this.updateOutPutDir(loggingEvent);
                Path file = new Path(this.outputPath);
                String sparkuser = System.getenv("SPARK_USER");
                String user = System.getenv("USER");
                StatusLogger.getLogger().warn("login user is " + UserGroupInformation.getLoginUser() + " SPARK_USER is " + sparkuser + " USER is " + user);
                UserGroupInformation ugi = SparkEnv.getUGI();
                if (ugi != null) {
                    StatusLogger.getLogger().warn("Login user hashcode is " + ugi.hashCode());
                    ugi.doAs(() -> {
                        if (!this.initHdfsWriter(file, SparkHadoopUtils.newConfiguration())) {
                            StatusLogger.getLogger().error("Failed to init the hdfs writer!");
                        }
                        this.doRollingClean(loggingEvent);
                        return null;
                    });
                } else {
                    if (!this.initHdfsWriter(file, SparkHadoopUtils.newConfiguration())) {
                        StatusLogger.getLogger().error("Failed to init the hdfs writer!");
                    }
                    this.doRollingClean(loggingEvent);
                }
            }
            transaction.add(loggingEvent);
            this.writeLogEvent(loggingEvent);
            --size;
        }
    }

    @Override
    String getLogPathAfterRolling(String logPath) {
        return null;
    }

    @Override
    String getLogPathRollingDone(String logPath) {
        return null;
    }

    @VisibleForTesting
    void updateOutPutDir(LogEvent event) {
        String rollingDir = this.dateFormat.format(new Date(event.getTimeMillis()));
        this.outputPath = this.getOutPutDir(rollingDir);
    }

    private String getOutPutDir(String rollingDir) {
        if (StringUtils.isBlank((CharSequence)this.executorId)) {
            this.executorId = SparkEnv.get() != null ? SparkEnv.get().executorId() : RandomUtil.randomUUIDStr();
            StatusLogger.getLogger().warn("executorId set to " + this.executorId);
        }
        if ("job".equals(this.getCategory())) {
            return this.getRootPathName() + "/" + rollingDir + "/" + this.getIdentifier() + "/" + this.getJobName() + "/executor-" + this.executorId + ".log";
        }
        return this.getRootPathName() + "/" + rollingDir + "/" + this.getIdentifier() + "/executor-" + this.executorId + ".log";
    }

    @VisibleForTesting
    void doRollingClean(LogEvent event) throws IOException {
        String rootPathName;
        Path rootPath;
        FileSystem fileSystem = this.getFileSystem();
        if (!fileSystem.exists(rootPath = new Path(rootPathName = this.getRootPathName()))) {
            return;
        }
        FileStatus[] logFolders = fileSystem.listStatus(rootPath);
        if (logFolders == null) {
            return;
        }
        String thresholdDay = this.dateFormat.format(new Date(event.getTimeMillis() - 86400000L * (long)this.rollingPeriod));
        for (FileStatus fs : logFolders) {
            Path fullPath;
            String fileName = fs.getPath().getName();
            if (fileName.compareTo(thresholdDay) >= 0 || !fileSystem.exists(fullPath = new Path(rootPathName + File.separator + fileName))) continue;
            fileSystem.delete(fullPath, true);
        }
    }

    @VisibleForTesting
    String getRootPathName() {
        switch (this.getCategory()) {
            case "job": {
                return this.parseHdfsWordingDir() + "/" + this.getProject() + "/spark_logs";
            }
            case "sparder": {
                return this.parseHdfsWordingDir() + "/_sparder_logs";
            }
            case "streaming_job": {
                return this.parseHdfsWordingDir() + "/streaming/spark_logs/" + this.getProject();
            }
        }
        throw new IllegalArgumentException("illegal category: " + this.getCategory());
    }

    public String getIdentifier() {
        try {
            return StringUtils.isBlank((CharSequence)this.identifier) ? SparkEnv.get().conf().getAppId() : this.identifier;
        }
        catch (Exception e) {
            return null;
        }
    }

    @VisibleForTesting
    boolean isTimeChanged(LogEvent event) {
        if (0L == this.startTime || event.getTimeMillis() / 86400000L - this.startTime / 86400000L > 0L) {
            this.startTime = event.getTimeMillis();
            return true;
        }
        return false;
    }

    private String parseHdfsWordingDir() {
        return StringUtils.appendIfMissing((String)this.getWorkingDir(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + StringUtils.replace((String)this.getMetadataId(), (String)"/", (String)"-");
    }

    @Generated
    public int getRollingPeriod() {
        return this.rollingPeriod;
    }

    @Generated
    public void setRollingPeriod(int rollingPeriod) {
        this.rollingPeriod = rollingPeriod;
    }

    @Generated
    public String getMetadataId() {
        return this.metadataId;
    }

    @Generated
    public void setMetadataId(String metadataId) {
        this.metadataId = metadataId;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }
}

