/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.datasource.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.engine.spark.utils.Metrics$;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.LayoutPartition;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.LayoutEntityConverter$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.datasource.storage.LayoutFormatWriter;
import org.apache.spark.sql.datasource.storage.LayoutFormatWriter$;
import org.apache.spark.sql.datasource.storage.StorageStore;
import org.apache.spark.sql.datasource.storage.WriteTaskStats;
import org.apache.spark.sql.execution.datasource.FilePruner;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0005\u000b\u0001]AQ\u0001\b\u0001\u0005\u0002uAQa\b\u0001\u0005B\u0001BQ\u0001\u0010\u0001\u0005\u0002uBQA\u001d\u0001\u0005BMD\u0011\"!\t\u0001#\u0003%\t!a\t\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!9\u0011\u0011\b\u0001\u0005B\u00055\u0003bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0002\u000f'R|'/Y4f'R|'/\u001a,2\u0015\tYA\"A\u0004ti>\u0014\u0018mZ3\u000b\u00055q\u0011A\u00033bi\u0006\u001cx.\u001e:dK*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033ii\u0011AC\u0005\u00037)\u0011Ab\u0015;pe\u0006<Wm\u0015;pe\u0016\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005e\u0001\u0011aG4fiN#xN]1hKB\u000bG\u000f[,ji\"|W\u000f\u001e)sK\u001aL\u0007\u0010\u0006\u0004\"]A\u0012DG\u000f\t\u0003E-r!aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u00192\u0012A\u0002\u001fs_>$hHC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQs%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y5\u0012aa\u0015;sS:<'B\u0001\u0016(\u0011\u0015y#\u00011\u0001\"\u0003\u001d\u0001(o\u001c6fGRDQ!\r\u0002A\u0002\u0005\n!\u0002Z1uC\u001adwn^%e\u0011\u001d\u0019$\u0001%AA\u0002\u0005\n\u0011b]3h[\u0016tG/\u00133\t\u000bU\u0012\u0001\u0019\u0001\u001c\u0002\u00111\f\u0017p\\;u\u0013\u0012\u0004\"a\u000e\u001d\u000e\u0003\u001dJ!!O\u0014\u0003\t1{gn\u001a\u0005\u0006w\t\u0001\rAN\u0001\tEV\u001c7.\u001a;JI\u0006q2\r[3dW\u0006sGm\u0016:ji\u0016\u0014h)Y:u\u0005&$X.\u00199MCf|W\u000f\u001e\u000b\u0006}\u0005\u0013\u0006\r\u001b\t\u0003o}J!\u0001Q\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0005\u000e\u0001\raQ\u0001\bI\u0006$\u0018m]3u!\t!uJ\u0004\u0002F\u001b:\u0011a\t\u0014\b\u0003\u000f.s!\u0001\u0013&\u000f\u0005\u0011J\u0015\"A\u000b\n\u0005M!\u0012BA\t\u0013\u0013\ty\u0001#\u0003\u0002O\u001d\u00059\u0001/Y2lC\u001e,\u0017B\u0001)R\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002O\u001d!)1k\u0001a\u0001)\u0006aA.Y=pkR,e\u000e^5usB\u0011QKX\u0007\u0002-*\u0011q\u000bW\u0001\u0006[>$W\r\u001c\u0006\u00033j\u000bAaY;cK*\u00111\fX\u0001\t[\u0016$\u0018\rZ1uC*\u0011QLE\u0001\u0006Wfd\u0017N\\\u0005\u0003?Z\u0013A\u0002T1z_V$XI\u001c;jifDQ!Y\u0002A\u0002\t\f\u0011b[1q\u0007>tg-[4\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015d\u0016AB2p[6|g.\u0003\u0002hI\nI1*\u00199D_:4\u0017n\u001a\u0005\u0006S\u000e\u0001\rA[\u0001\u000bY\u0006Lx.\u001e;QCRD\u0007CA6q\u001b\u0005a'BA7o\u0003\t17O\u0003\u0002p%\u00051\u0001.\u00193p_BL!!\u001d7\u0003\tA\u000bG\u000f[\u0001\u0005e\u0016\fG\r\u0006\u0005u}\u0006\u001d\u00111BA\f!\t)H0D\u0001w\u0015\t9\b0A\u0004m_\u001eL7-\u00197\u000b\u0005eT\u0018!\u00029mC:\u001c(BA>\u000f\u0003!\u0019\u0017\r^1msN$\u0018BA?w\u0005-aunZ5dC2\u0004F.\u00198\t\r}$\u0001\u0019AA\u0001\u0003!!\u0017\r^1gY><\bcA+\u0002\u0004%\u0019\u0011Q\u0001,\u0003\u00139#\u0015\r^1gY><\bBBA\u0005\t\u0001\u0007A+\u0001\u0004mCf|W\u000f\u001e\u0005\b\u0003\u001b!\u0001\u0019AA\b\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\t\t\"a\u0005\u000e\u00039I1!!\u0006\u000f\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011%\tI\u0002\u0002I\u0001\u0002\u0004\tY\"\u0001\u0007fqR\u0014\u0018m\u00149uS>t7\u000fE\u0003#\u0003;\t\u0013%C\u0002\u0002 5\u00121!T1q\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIQ*\"!!\n+\t\u0005m\u0011qE\u0016\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0005v]\u000eDWmY6fI*\u0019\u00111G\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u00055\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011\"/Z1e'B,7-[1m'\u0016<W.\u001a8u)%\u0019\u0015QHA$\u0003\u0013\nY\u0005C\u0004\u0002@\u0019\u0001\r!!\u0011\u0002\u000fM,w-\\3oiB\u0019Q+a\u0011\n\u0007\u0005\u0015cK\u0001\u0007O\t\u0006$\u0018mU3h[\u0016tG\u000f\u0003\u0004\u0002\n\u0019\u0001\r\u0001\u0016\u0005\b\u0003\u001b1\u0001\u0019AA\b\u0011%\tIB\u0002I\u0001\u0002\u0004\tY\u0002F\u0005D\u0003\u001f\n\t&a\u0015\u0002f!9\u0011qH\u0004A\u0002\u0005\u0005\u0003BBA\u0005\u000f\u0001\u0007A\u000bC\u0004\u0002V\u001d\u0001\r!a\u0016\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0014\u0001\u00026bm\u0006L1!OA.\u0011\u001d\tia\u0002a\u0001\u0003\u001f\t\u0011c]1wKN+w-\\3oi2\u000b\u0017p\\;u)1\tY'!\u001d\u0002t\u0005U\u0014qOA>!\rI\u0012QN\u0005\u0004\u0003_R!AD,sSR,G+Y:l'R\fGo\u001d\u0005\u0007\u0003\u0013A\u0001\u0019\u0001+\t\u000f\u0005}\u0002\u00021\u0001\u0002B!)\u0011\r\u0003a\u0001E\"1\u0011\u0011\u0010\u0005A\u0002\r\u000b\u0011\u0002Z1uC\u001a\u0013\u0018-\\3\t\u000bmB\u0001\u0019\u0001\u001c")
public class StorageStoreV1
extends StorageStore {
    @Override
    public String getStoragePathWithoutPrefix(String project, String dataflowId, String segmentId, long layoutId, long bucketId) {
        String parquet = "parquet";
        return layoutId < 0L ? new StringBuilder(3).append(project).append("/").append(parquet).append("/").append(dataflowId).append("/").append(segmentId).toString() : (bucketId < 0L ? new StringBuilder(4).append(project).append("/").append(parquet).append("/").append(dataflowId).append("/").append(segmentId).append("/").append(layoutId).toString() : new StringBuilder(5).append(project).append("/").append(parquet).append("/").append(dataflowId).append("/").append(segmentId).append("/").append(layoutId).append("/").append(bucketId).toString());
    }

    public void checkAndWriterFastBitmapLayout(Dataset<Row> dataset, LayoutEntity layoutEntity, KapConfig kapConfig, Path layoutPath) {
        if (!layoutEntity.getIndex().getIndexPlan().isFastBitmapEnabled()) {
            return;
        }
        List bitmaps = layoutEntity.listBitmapMeasure();
        if (bitmaps.isEmpty()) {
            return;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Begin write fast bitmap cuboid. layout id is ").append(layoutEntity.getId()).toString());
        Path outputPath = new Path(new StringBuilder(12).append(layoutPath.toString()).append("_fast_bitmap").toString());
        Dataset afterReplaced = StorageStoreV1.replaceCountDistinctEvalColumn$1(bitmaps, dataset);
        LayoutFormatWriter$.MODULE$.write((Dataset<Row>)afterReplaced, layoutEntity, outputPath, kapConfig, this.storageListener());
    }

    @Override
    public LogicalPlan read(NDataflow dataflow, LayoutEntity layout, SparkSession sparkSession, Map<String, String> extraOptions) {
        StructType structType = "true".equals(extraOptions.apply((Object)"isFastBitmapEnabled")) ? LayoutEntityConverter$.MODULE$.LayoutEntityConverter(layout).toExactlySchema() : LayoutEntityConverter$.MODULE$.LayoutEntityConverter(layout).toSchema();
        FilePruner indexCatalog = new FilePruner(sparkSession, extraOptions, structType);
        HadoopFsRelation fsRelation = new HadoopFsRelation((FileIndex)indexCatalog, indexCatalog.partitionSchema(), indexCatalog.dataSchema().asNullable(), (Option)None$.MODULE$, (FileFormat)new ParquetFileFormat(), extraOptions, sparkSession);
        return LogicalRelation$.MODULE$.apply((BaseRelation)fsRelation, LogicalRelation$.MODULE$.apply$default$2());
    }

    @Override
    public Map<String, String> read$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Dataset<Row> readSpecialSegment(NDataSegment segment, LayoutEntity layout, SparkSession sparkSession, Map<String, String> extraOptions) {
        long layoutId = layout.getId();
        String path = this.getStoragePath(segment, layoutId);
        return sparkSession.read().parquet(path);
    }

    @Override
    public Dataset<Row> readSpecialSegment(NDataSegment segment, LayoutEntity layout, Long partitionId, SparkSession sparkSession) {
        long layoutId = layout.getId();
        LayoutPartition dataPartition = segment.getLayout(layoutId).getDataPartition(partitionId);
        Predef$.MODULE$.require(Objects.nonNull(dataPartition));
        String path = this.getStoragePath(segment, layoutId, dataPartition.getBucketId());
        return sparkSession.read().parquet(path);
    }

    @Override
    public WriteTaskStats saveSegmentLayout(LayoutEntity layout, NDataSegment segment, KapConfig kapConfig, Dataset<Row> dataFrame, long bucketId) {
        LayoutFormatWriter.OutputSpec outputSpec;
        Path outputPath = new Path(this.getStoragePath(segment, layout.getId(), bucketId));
        Tuple2<Object, Object> tuple2 = this.collectFileCountAndSizeAfterSave(outputPath, (outputSpec = LayoutFormatWriter$.MODULE$.write(dataFrame, layout, outputPath, kapConfig, this.storageListener())).hadoopConf());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long fileCount = tuple2._1$mcJ$sp();
        long byteSize = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(fileCount, byteSize);
        Tuple2.mcJJ.sp sp3 = sp2;
        long fileCount2 = sp3._1$mcJ$sp();
        long byteSize2 = sp3._2$mcJ$sp();
        this.checkAndWriterFastBitmapLayout(dataFrame, layout, kapConfig, outputPath);
        return new WriteTaskStats(0, fileCount2, byteSize2, outputSpec.rowCount(), outputSpec.metrics().getMetrics(Metrics$.MODULE$.SOURCE_ROWS_CNT()), outputSpec.bucketNum(), new ArrayList<String>());
    }

    private static final Dataset replaceCountDistinctEvalColumn$1(List list, Dataset dataFrame) {
        Column[] columns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFrame.schema().names())).map((Function1 & Serializable & scala.Serializable)name -> list.contains(name) ? functions$.MODULE$.callUDF("eval_bitmap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(name)})).as(name) : functions$.MODULE$.col(name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns));
    }
}

