/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.profiler;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.profiler.BuildAsyncProfilerDriverPlugin;
import org.apache.kylin.profiler.BuildAsyncProfilerSparkPlugin;
import org.apache.kylin.profiler.Message$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.junit.Assert;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\f\u0019\u0001\u0005BQA\f\u0001\u0005\u0002=B\u0011B\r\u0001A\u0002\u0003\u0007I\u0011A\u001a\t\u0013]\u0002\u0001\u0019!a\u0001\n\u0003A\u0004\"C!\u0001\u0001\u0004\u0005\t\u0015)\u00035\u0011\u001d1\u0005A1A\u0005\u0012\u001dCa\u0001\u0015\u0001!\u0002\u0013A\u0005\u0002C)\u0001\u0011\u000b\u0007I\u0011\u0001*\t\u000fm\u0003!\u0019!C\u00019\"1q\r\u0001Q\u0001\nuCq\u0001\u001b\u0001C\u0002\u0013\u0005A\f\u0003\u0004j\u0001\u0001\u0006I!\u0018\u0005\bU\u0002\u0011\r\u0011\"\u0001]\u0011\u0019Y\u0007\u0001)A\u0005;\"9A\u000e\u0001b\u0001\n\u0003a\u0006BB7\u0001A\u0003%Q\fC\u0004o\u0001\t\u0007I\u0011\u0001/\t\r=\u0004\u0001\u0015!\u0003^\u0011\u0015\u0001\b\u0001\"\u0005r\u0011\u0015Y\b\u0001\"\u0003}\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u00111\u0001\u0001\u0005\u0012\u0005\u0015\u0001bBA\b\u0001\u0011\u0005\u0013\u0011\u0001\u0002#\u0005VLG\u000eZ!ts:\u001c\u0007K]8gS2,'\u000f\u0012:jm\u0016\u0014\b\u000b\\;hS:$Vm\u001d;\u000b\u0005eQ\u0012\u0001\u00039s_\u001aLG.\u001a:\u000b\u0005ma\u0012!B6zY&t'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001E!\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u000f\u0002\u000bM\u0004\u0018M]6\n\u0005\u001d\"#!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002*Y5\t!F\u0003\u0002,=\u0005I1oY1mCR,7\u000f^\u0005\u0003[)\u0012\u0011CQ3g_J,\u0017I\u001c3BMR,'/\u00117m\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0007\u0005\u00022\u00015\t\u0001$\u0001\u0002tGV\tA\u0007\u0005\u0002$k%\u0011a\u0007\n\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007g\u000e|F%Z9\u0015\u0005ez\u0004C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$\u0001B+oSRDq\u0001Q\u0002\u0002\u0002\u0003\u0007A'A\u0002yIE\n1a]2!Q\t!1\t\u0005\u0002;\t&\u0011Qi\u000f\u0002\niJ\fgn]5f]R\fq!\u001e;`[\u0016$\u0018-F\u0001I!\tIe*D\u0001K\u0015\tYE*\u0001\u0003mC:<'\"A'\u0002\t)\fg/Y\u0005\u0003\u001f*\u0013aa\u0015;sS:<\u0017\u0001C;u?6,G/\u0019\u0011\u0002\u00135,G/Y*u_J,W#A*\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016\u0001B;uS2T!\u0001\u0017\u000e\u0002\r\r|W.\\8o\u0013\tQVK\u0001\u000eO\u0019>\u001c\u0017\r\u001c$jY\u0016lU\r^1eCR\fG+Z:u\u0007\u0006\u001cX-A\bta\u0006\u00148\u000e\u00157vO&tg*Y7f+\u0005i\u0006C\u00010f\u001d\ty6\r\u0005\u0002aw5\t\u0011M\u0003\u0002cA\u00051AH]8pizJ!\u0001Z\u001e\u0002\rA\u0013X\rZ3g\u0013\tyeM\u0003\u0002ew\u0005\u00012\u000f]1sWBcWoZ5o\u001d\u0006lW\rI\u0001\fM2\fwMR5mK\u0012K'/\u0001\u0007gY\u0006<g)\u001b7f\t&\u0014\b%\u0001\bbGRLwN\u001c$jY\u0016\u0004\u0016\r\u001e5\u0002\u001f\u0005\u001cG/[8o\r&dW\rU1uQ\u0002\nab\u001d;biV\u001ch)\u001b7f\u001d\u0006lW-A\bti\u0006$Xo\u001d$jY\u0016t\u0015-\\3!\u00031!W/\u001c9GS2,g*Y7f\u00035!W/\u001c9GS2,g*Y7fA\u0005AQ.\u001a;bI\u0006$\u0018-F\u0001s!\r\u0019\b0\u0018\b\u0003iZt!\u0001Y;\n\u0003qJ!a^\u001e\u0002\u000fA\f7m[1hK&\u0011\u0011P\u001f\u0002\u0004'\u0016\f(BA<<\u000311\u0017\u000e\u001e)bi\"4uN]+U)\tiV\u0010C\u0003\u007f'\u0001\u0007Q,\u0001\u0003qCRD\u0017!\u00032fM>\u0014X-\u00117m)\u0005I\u0014aE8wKJ<(/\u001b;f'f\u001cH/Z7Qe>\u0004H#B\u001d\u0002\b\u0005-\u0001BBA\u0005+\u0001\u0007Q,A\u0002lKfDa!!\u0004\u0016\u0001\u0004i\u0016!\u0002<bYV,\u0017\u0001C1gi\u0016\u0014\u0018\t\u001c7")
public class BuildAsyncProfilerDriverPluginTest
extends SparkFunSuite {
    private NLocalFileMetadataTestCase metaStore;
    private transient SparkContext sc;
    private final String ut_meta;
    private final String sparkPluginName = BuildAsyncProfilerSparkPlugin.class.getName();
    private final String flagFileDir = new StringBuilder(18).append(System.getProperty("java.io.tmpdir")).append("default/jobStepId/").toString();
    private final String actionFilePath = new StringBuilder(7).append(this.flagFileDir()).append("/action").toString();
    private final String statusFileName = new StringBuilder(7).append(this.flagFileDir()).append("/status").toString();
    private final String dumpFileName = new StringBuilder(12).append(this.flagFileDir()).append("/dump.tar.gz").toString();
    private volatile boolean bitmap$0;

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public String ut_meta() {
        return this.ut_meta;
    }

    private NLocalFileMetadataTestCase metaStore$lzycompute() {
        BuildAsyncProfilerDriverPluginTest buildAsyncProfilerDriverPluginTest = this;
        synchronized (buildAsyncProfilerDriverPluginTest) {
            if (!this.bitmap$0) {
                this.metaStore = new NLocalFileMetadataTestCase();
                this.bitmap$0 = true;
            }
        }
        return this.metaStore;
    }

    public NLocalFileMetadataTestCase metaStore() {
        return !this.bitmap$0 ? this.metaStore$lzycompute() : this.metaStore;
    }

    public String sparkPluginName() {
        return this.sparkPluginName;
    }

    public String flagFileDir() {
        return this.flagFileDir;
    }

    public String actionFilePath() {
        return this.actionFilePath;
    }

    public String statusFileName() {
        return this.statusFileName;
    }

    public String dumpFileName() {
        return this.dumpFileName;
    }

    public Seq<String> metadata() {
        return (Seq)new .colon.colon((Object)this.fitPathForUT(this.ut_meta()), (List)Nil$.MODULE$);
    }

    private String fitPathForUT(String path) {
        return new File(path).exists() ? path : new StringBuilder(3).append("../").append(path).toString();
    }

    public void beforeAll() {
        this.metaStore().createTestMetadata((String[])this.metadata().toArray(ClassTag$.MODULE$.apply(String.class)));
        super.beforeAll();
    }

    public void overwriteSystemProp(String key, String value) {
        this.metaStore().overwriteSystemProp(key, value);
    }

    public void afterAll() {
        super.afterAll();
        this.metaStore().restoreSystemProps();
        this.metaStore().cleanupTestMetadata();
    }

    public BuildAsyncProfilerDriverPluginTest() {
        this.ut_meta = "../examples/test_case_data/localmeta";
        this.test("plugin initialization missing flagFileDir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            this.sc_$eq(new SparkContext(conf));
            Assert.assertEquals((Object)this.sparkPluginName(), (Object)this.sc().getConf().get("spark.plugins").toString());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("plugin initialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            Assert.assertEquals((Object)this.sparkPluginName(), (Object)this.sc().getConf().get("spark.plugins").toString());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("plugin checkAction Null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.init(this.sc(), null);
            HadoopUtil.writeStringToHdfs((String)"null", (Path)driverPlugin.actionFilePath());
            driverPlugin.checkAction();
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("plugin checkAction NOP", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.init(this.sc(), null);
            driverPlugin.checkAction();
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("plugin checkAction STA", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.init(this.sc(), null);
            String driverMessage = Message$.MODULE$.createDriverMessage(Message$.MODULE$.START(), "start,event=cpu");
            HadoopUtil.writeStringToHdfs((String)driverMessage, (Path)driverPlugin.actionFilePath());
            driverPlugin.checkAction();
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)driverPlugin.actionFilePath());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("plugin checkAction STA error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.init(this.sc(), null);
            driverPlugin.start("");
            String driverMessage = Message$.MODULE$.createDriverMessage(Message$.MODULE$.START(), "start,event=cpu");
            HadoopUtil.writeStringToHdfs((String)driverMessage, (Path)driverPlugin.actionFilePath());
            driverPlugin.checkAction();
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)driverPlugin.actionFilePath());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("plugin checkAction STA twice", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.init(this.sc(), null);
            String driverMessage = Message$.MODULE$.createDriverMessage(Message$.MODULE$.START(), "start,event=cpu");
            HadoopUtil.writeStringToHdfs((String)driverMessage, (Path)driverPlugin.actionFilePath());
            driverPlugin.start("");
            driverPlugin.checkAction();
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)driverPlugin.actionFilePath());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        this.test("plugin checkAction STOP", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.init(this.sc(), null);
            driverPlugin.start("");
            String driverMessage = Message$.MODULE$.createDriverMessage(Message$.MODULE$.STOP(), "start,event=cpu");
            HadoopUtil.writeStringToHdfs((String)driverMessage, (Path)driverPlugin.actionFilePath());
            driverPlugin.checkAction();
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)driverPlugin.actionFilePath());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("plugin checkAction STOP when not running", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.init(this.sc(), null);
            String driverMessage = Message$.MODULE$.createDriverMessage(Message$.MODULE$.STOP(), "start,event=cpu");
            HadoopUtil.writeStringToHdfs((String)driverMessage, (Path)driverPlugin.actionFilePath());
            driverPlugin.checkAction();
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)driverPlugin.actionFilePath());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("plugin checkAction DUMP", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.init(this.sc(), null);
            String driverMessage = Message$.MODULE$.createDriverMessage(Message$.MODULE$.DUMP(), "start,event=cpu");
            HadoopUtil.writeStringToHdfs((String)driverMessage, (Path)driverPlugin.actionFilePath());
            driverPlugin.checkAction();
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)driverPlugin.actionFilePath());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("plugin checkAction DUMP error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.init(this.sc(), null);
            String driverMessage = Message$.MODULE$.createDriverMessage(Message$.MODULE$.DUMP(), "start,event=cpu");
            HadoopUtil.writeStringToHdfs((String)driverMessage, (Path)driverPlugin.actionFilePath());
            driverPlugin.dump("");
            driverPlugin.checkAction();
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)driverPlugin.actionFilePath());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.test("plugin checkAction DUMP twice", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.init(this.sc(), null);
            String driverMessage = Message$.MODULE$.createDriverMessage(Message$.MODULE$.DUMP(), "start,event=cpu");
            HadoopUtil.writeStringToHdfs((String)driverMessage, (Path)driverPlugin.actionFilePath());
            driverPlugin.dump("");
            driverPlugin.dump("");
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)driverPlugin.actionFilePath());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        this.test("plugin checkAction DUMP when running", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.init(this.sc(), null);
            driverPlugin.start("");
            driverPlugin.dump("");
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)driverPlugin.actionFilePath());
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("plugin receive next", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.receive((Object)"NEX-1:start,event=cpu");
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        this.test("plugin receive result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.receive((Object)"RES-1:flamegraph");
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        this.test("plugin receive others", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            return driverPlugin.receive((Object)"OTH-1:start,event=cpu");
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        this.test("plugin start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.start("");
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        this.test("plugin start timeout", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.init(this.sc(), null);
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.start("");
            driverPlugin.dump("");
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        this.test("plugin dump", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            System.setProperty("spark.profiler.flagsDir", this.flagFileDir());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.init(this.sc(), null);
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.dumpFileName_$eq(new Path(this.dumpFileName()));
            driverPlugin.dump("");
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
        this.test("plugin dump with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setAppName(this.getClass().getName()).set("spark.master", "local[1]").set("spark.plugins", this.sparkPluginName());
            this.sc_$eq(new SparkContext(conf));
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.init(this.sc(), null);
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.actionFilePath_$eq(null);
            driverPlugin.dumpFileName_$eq(null);
            Assert.assertThrows(NullPointerException.class, () -> driverPlugin.dump(""));
            this.sc().stop();
            this.sc_$eq(null);
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        this.test("plugin initDirectory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.actionFilePath_$eq(new Path(this.actionFilePath()));
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.initDirectory(this.flagFileDir());
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        this.test("plugin shutdown", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BuildAsyncProfilerDriverPlugin driverPlugin = new BuildAsyncProfilerDriverPlugin();
            driverPlugin.statusFileName_$eq(new Path(this.statusFileName()));
            driverPlugin.shutdown();
        }, new Position("BuildAsyncProfilerDriverPluginTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
    }
}

